Ext.define('P5U.controller.FilePicker', {
    extend: 'Ext.app.Controller',

	init: function(){
		var me = this;
        me.control({
            '#clienttabpanel_id': {
                render: this.onClientRegionWestReady,
                select: me.onClientSelect
             },
            'servervolumegrid': {
                select: me.onVolumeSelect,
                beforeselect: function ( row, model, index ) {
                	// disable selection of folder
                	if (!model.data.leaf) return false;
                }
            },
            'foldercontentgrid': {
                selectionchange: me.onContentSelect,
                beforeselect: function ( row, model, index ) {
                	// disable selection of files
                	if (model.data.leaf) return false;
                }
            },
            'filePicker_x button[action=selectFolder]': {
                click: this.onSelectFolder
            }
		});
	},
    onClientRegionWestReady: function(obj) {
		console.log('Client Panel Ready');
        var panel_client = Ext.ComponentQuery.query('#clienttabpanel_id')[0];
        if (typeof panel_client != 'undefined') {
            var client_store = panel_client.getStore();
            client_store.proxy.extraParams = {
                caller: 'ajaxGetClients',
                defaultClient: 'localhost',
            };
            client_store.load();
        }
    },
    onClientSelect: function(view, record, item, index, event) {
		var me = this;
		console.log('Change Client');
        var panel_tree = Ext.getCmp('servervolumegrid_id');
        var tree_store = panel_tree.getStore();
        tree_store.load({
            params: {
                hostname: record.data.name
            }
        });
        var htxt = $$('Volumes on') + ' ' + record.data.name;
        panel_tree.columns[0].setText(htxt);   
		P5U.globals.parentClient = record.data.name;
    },
    onVolumeSelect: function(view, record, item, index, event) {
		var panel_tree = Ext.getCmp('foldercontentgrid_id');
		var tree_store = panel_tree.getStore();
		// reset panel and store
		tree_store.removeAll();
		tree_store.setRootNode();
		//panel_tree.setRootNode(null);
		var newRoot = {
			name: record.data.name,
			id: record.data.elementurl,
			path: record.data.path,
			iconCls: 'leafIcon_Dir',
			expanded: true
		}
		tree_store.setRootNode(newRoot);           
    },
    onContentSelect: function(model, selected) {
    	model.view.up().up().down('button[action=selectFolder]').setDisabled(!selected.length);
    },
    onSelectFolder: function(obj) {
		var panel_tree = Ext.getCmp('foldercontentgrid_id');
		numberElements   = 0;
		selectedelements = [];
		var selection    = panel_tree.getSelectionModel().getSelection();
		Ext.iterate(selection, function(obj, index) {
			var path = obj.get('path');
			selectedelements.push(path);
			numberElements++
		});
		P5U.globals.parentPath = selectedelements;
		Ext.ComponentQuery.query('filePicker_x')[0].aufrufer();
		obj.up().up().close();
    },
	onLaunch: function(){
		console.log('FilePicker controller ready');
	}
});
