Ext.define('P5Index.view.TroubleshootingHelp', {
    extend: 'Ext.window.Window',
    xtype: 'troubleshooting-help',
    
    title: 'Media Recovery Help',
    width: 600,
    height: 600,
    modal: true,
    resizable: true,
    closeAction: 'hide',
    layout: 'fit',
    
    items: [{
        xtype: 'panel',
        bodyPadding: 20,
        autoScroll: true,
        html: '<div style="font-family: Arial, sans-serif; line-height: 1.4;">' +
            
            '<h3 style="color: #333; margin: 0 0 6px 0; border-bottom: 1px solid #ddd; padding-bottom: 4px;">' +
            'Problem: Not finding expected files within index</h3>' +
            
            '<p style="color: #666; margin: 4px 0 10px 0;">' +
            'Files were extracted from your project file but not found in the archive.' +
            '</p>' +
            
            '<h4 style="color: #444; margin: 6px 0 4px 0;">Adjust search settings:</h4>' +
            '<ul style="margin: 4px 0 12px 16px;">' +
            '<li><strong>Search Mode:</strong></li>' +
            '<ul style="margin: 2px 0 6px 16px;">' +
            '<li><em>Exact</em>: Matches filename exactly (fastest, most restrictive)</li>' +
            '<li><em>Wildcard</em>: Finds files with same base name but different extensions</li>' +
            '<li><em>Word parts</em>: Searches for individual words within filename (most flexible)</li>' +
            '<li><em>Auto</em>: Tries all methods automatically</li>' +
            '</ul>' +
            '<li style="margin-top: 6px;"><strong>Path Matching:</strong></li>' +
            '<ul style="margin: 2px 0 0 16px;">' +
            '<li><em>Parent folder</em>: Requires matching folder name</li>' +
            '<li><em>Relative path</em>: Requires matching folder structure</li>' +
            '<li><em>Ignore path</em>: Filename-only matching</li>' +
            '</ul>' +
            '</ul>' +
            
            '<h4 style="color: #444; margin: 6px 0 4px 0;">Verify files exist:</h4>' +
            '<ul style="margin: 4px 0 16px 16px;">' +
            '<li>Use <strong>Archive Browser</strong> to manually search for a specific filename</li>' +
            '<li>Check if the file was archived under a different name or location</li>' +
            '</ul>' +
                        
            '<h3 style="color: #333; margin: 0 0 6px 0; border-bottom: 1px solid #ddd; padding-bottom: 4px;">' +
            'Problem: Not finding expected files within project file</h3>' +
            
            '<p style="color: #666; margin: 4px 0 10px 0;">' +
            'When your project file shows no files or an unexpected number of files, the parser that ' +
            'analyzes and extracts media references may not be trained for your specific format.' +
            '</p>' +
            
            '<h4 style="color: #444; margin: 6px 0 4px 0;">Report parser problems:</h4>' +
            '<p style="margin: 4px 0 4px 16px;">' +
            'If your project file isn\'t parsing correctly, we\'d like to fix it.' +
            '</p>' +
            '<p style="margin: 4px 0 12px 16px;">' +
            '<strong>Contact:</strong> <a href="javascript:sendFeedback();" style="color: #0066cc;">feedback@archiware.com</a> ' +
            'with your project file (confidential handling)' +
            '</p>' +
            
            '</div>'
    }],
    
    buttons: [{
        text: $$('Close'),
        handler: function() {
            this.up('window').close();
        }
    }],
    
    // Optional: Singleton pattern für bessere Performance
    statics: {
        show: function() {
            if (!this.instance) {
                this.instance = Ext.create('P5Index.view.TroubleshootingHelp');
            }
            this.instance.show();
            return this.instance;
        }
    }
});

// Globale sendFeedback Funktion
function sendFeedback() {
    var subject = encodeURIComponent('Media Recovery Parser Issue');
    var body = encodeURIComponent(
        'Project File Format: [Please specify: EDL/OTIO/FCPXML/ALE/etc.]\n' +
        'Expected number of files: \n' +
        'Actual number of files found: \n' +
        'Additional details: \n\n' +
        'Please attach your project file to this email.\n'
    );
    window.location = 'mailto:feedback@archiware.com?subject=' + subject + '&body=' + body;
}