Ext.define('P5Index.view.SelectionGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'mvvm-selectiongrid',
    reference: 'selectionGrid',
    
    multiSelect: true,
    border: false,
    
    columns: [
        { dataIndex: 'type', hidden: true },
        { header: $$('Files & folders'), dataIndex: 'name', renderer: eval('renderIconIdx'), flex: 1 },
        { /*header: $$('Prior snapshot'),*/ dataIndex: 'vtext', width: 120 }
    ],
    
    viewConfig: {
        emptyText: $$('No items selected')
    },
    
    bind: {
        store: '{basketContentStore}'
    },
    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        padding: '4 0 4 4',
        defaults: {
            xtype: 'button'
        },
        items: [{
            iconCls: 'btn-rem',
            tooltip: $$('Remove from selection'),
            handler: 'outBasket'
        }, {
            iconCls: 'btn-add',
            tooltip: $$('Add to selection'),
            handler: 'inBasket'
        }, {
            xtype: 'tbfill'
        }, {
            bind: {
                text: '{actionButtonAll}',
                disabled: '{!buttonAllEnabled}'
            },
            handler: 'onExecuteActionAll'
        }, {
            bind: {
                text: '{actionButton}',
                disabled: '{!buttonEnabled}'
            },
            handler: 'onExecuteAction'
        }]
    }]
});