Ext.define("P5Jobmanager.view.ParkedJobsGrid", {
    extend: 'Ext.grid.Panel',
    alias: "widget.parkedjobsgrid",

    stateful: true,
    stateId:   'stateParkedjobsgrid_id',
    reference: 'parkedjobsgrid_ref',
    itemId:    'parkedjobsgrid_id',

    bind:{
        store: '{parkedqueuestore}',
        hidden: '{!isParkedJobsQueuesChecked}'
    },

    applyState: function(state) {
        // disable stateful sorters and filters
        // ist a workaround for stateful "getViewModel() is null"
        state.sort = false;
        state.storeState = false;
        this.callParent(arguments);
    },

    viewConfig: {
        loadMask: false,
        preserveScrollOnReload: true,
        preserveScrollOnRefresh: true
    },

    border: false,
    flex: 1,

    selModel: {
        selType: 'checkboxmodel',
        injectCheckbox: 0
    },

    columns: [{
        dataIndex: 'jtype',
        align: 'center',
        text: '',
        menuDisabled : true,
        width: 32,
        tdCls: 'no-overflow-cell',
        renderer: function(value,metaData,record) {
            switch(value) {
                case 'archivejob':
                    metaData.tdCls = 'archivejob-icon';
                    break;
                case 'backupjob':
                    metaData.tdCls = 'backupjob-icon';
                    break;
                case 'backup2gojob':
                    metaData.tdCls = 'backup2gojob-icon';
                    break;
                case 'syncjob':
                    metaData.tdCls = 'syncjob-icon';
                    break;
                case 'synccloudjob':
                    metaData.tdCls = 'synccloudjob-icon';
                    break;
                case 'migrationjob':
                    metaData.tdCls = 'migrationjob-icon';
                    break;
                case 'verifyjob':
                    metaData.tdCls = 'verifyjob-icon';
                    break;
                case 'queryjob':
                    metaData.tdCls = 'queryjob-icon';
                    break;
                case 'restorejob':
                    metaData.tdCls = 'restorejob-icon';
                    break;
                default:
                    metaData.tdCls = 'otherjob-icon';
            }
        }
    },{ text: $$('Job Name'), dataIndex: 'text', width: 200
    },{ text: $$('Client'), dataIndex: 'client', width: 80
    },{ text: $$('User'), dataIndex: 'owner', width: 80
    },/*{ text: $$('Pool'), dataIndex: 'pool', width: 80
    },*/{ text: $$('Job'), dataIndex: 'jobid', flex: 1 }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        layout: { pack: 'left' },
        items: [{
            xtype: 'button',
            iconCls: 'fa fa-play inbutton',
            text: $$('Start'),
            handler: 'onStartNow'
        },{
            xtype: 'button',
            iconCls: 'fa fa-trash inbutton',
            text: $$('Remove'),
            handler: 'onStopRemove'
        }/*,{
            xtype: 'checkboxfield',
            boxLabel: $$('Automatic move to execution queue'),
            inputValue: 1,
            stateful : true,
            stateId: 'parkedjobs_stateId'
        }*/]
    }]
});