Ext.define('Dashboard.view.widget.SynchronizeOverview', {
    extend: 'Ext.grid.Panel',
    xtype: 'synchronize-overview-widget',
    
    requires: [
        'Dashboard.view.widget.SynchronizeOverviewController',
        'Dashboard.view.widget.SynchronizeOverviewModel'
    ],
    
    controller: 'synchronize-overview-widget',
    viewModel: {
        type: 'synchronize-overview-widget'
    },
    
    bind: {
        store: '{synchronizeOverview}'
    },
    
    columns: [{
        text: $$('Plan'),
        dataIndex: 'syncPlan',
        width: 80,
        renderer: function(value, meta, record) {
            return '<a href="javascript:void(0)" class="startd" data-action="view-plan" data-name="' + 
                   record.get('name') + '">' + value + '</a>';
        }
    }, {
        text: $$('Last Run'),
        dataIndex: 'statusText',
        flex: 1,
        renderer: function(value, meta, record) {
            var statusClass = record.get('statusClass');
            var jobId = record.get('jobId');
            var iconHtml = '';
            
            // Font Awesome Icon basierend auf Status
            switch(statusClass) {
                case 'running':
                    iconHtml = '<i class="fas fa-circle-notch fa-spin" style="color:#0088FF;"></i> ';
                    break;
                case 'finished':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'error':
                    iconHtml = '<i class="fas fa-circle" style="color:#FF3300;"></i> ';
                    break;
                case 'warning':
                case 'cancelled':
                    iconHtml = '<i class="fas fa-exclamation-triangle" style="color:#FF9900;"></i> ';
                    break;
                case 'never':
                    iconHtml = '<i class="fas fa-question-circle" style="color:#FFCC00;"></i> ';
                    break;
                default:
                    iconHtml = '<i class="fas fa-circle" style="color:#CCCCCC;"></i> ';
            }
            
            var html = iconHtml;
            
            if (jobId) {
                html += '<a href="javascript:void(0)" class="startd" ' +
                       'data-action="view-job" data-jobid="' + jobId + '">' + value + '</a>';
            } else {
                html += '<span>' + value + '</span>';
            }

            if (record.get('dataSize') > 0) {
                html += ' (' + CalcSize(record.get('dataSize')) + ')';
            }
            
            return html;
        
        }
    }, {
        text: $$('Last Successful'),
        dataIndex: 'lastSuccessText',
        flex: 1,
        renderer: function(value, meta, record) {
            var statusClass = record.get('lastSuccessClass');
            var jobId = record.get('lastSuccessJobId');
            var iconHtml = '';
            
            // Font Awesome Icon basierend auf Status
            switch(statusClass) {
                case 'recent':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'today':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'old':
                    iconHtml = '<i class="fas fa-clock" style="color:#FF9900;"></i> ';
                    break;
                case 'never':
                    iconHtml = '<i class="fas fa-question-circle" style="color:#FFCC00;"></i> ';
                    break;
                default:
                    iconHtml = '<i class="fas fa-circle" style="color:#CCCCCC;"></i> ';
            }
            
            var html = iconHtml;
            
            if (jobId) {
                html += '<a href="javascript:void(0)" class="startd" ' +
                       'data-action="view-job" data-jobid="' + jobId + '">' + value + '</a>';
            } else {
                html += '<span>' + value + '</span>';
            }
            
            if (record.get('lastSuccessDataSize') > 0) {
                html += ' (' + CalcSize(record.get('lastSuccessDataSize')) + ')';
            }
            
            return html;
        }
    }, {
        text: $$('Duration'),
        dataIndex: 'duration',
        width: 80
    }, {
        text: $$('Next Run'),
        dataIndex: 'nextRun',
        width: 80
    }, {
        text: $$('Source'),
        dataIndex: 'sourceHost',
        flex: 1,
        renderer: function(value) {
            return '<a href="javascript:void(0)" class="startd" data-action="view-client" ' + 
                   'data-name="' + value + '">' + value + '</a>';
        }
    }, {
        text: $$('Target'),
        dataIndex: 'targetHost',
        flex: 1,
        renderer: function(value) {
            return '<a href="javascript:void(0)" class="startd" data-action="view-client" ' + 
                   'data-name="' + value + '">' + value + '</a>';
        }
    }, {
        text: $$('Source Directories'),
        dataIndex: 'sourceDirs',
        flex: 2,
        renderer: function(value) {
            if (!value || !value.length) return '';
            
            if (value.length === 1) {
                return value[0];
            }
            
            return value[0] + ' <span class="more-dirs">(+' + (value.length - 1) + ' more)</span>';
        }
    }, {
        text: $$('Target Directory'),
        dataIndex: 'targetDir',
        flex: 2
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img8/synchronize_32.png',
            width: 24,
            height: 24
       },'->',{
            xtype: 'segmentedbutton',
            stateful: true,
            stateId: 'synchronize-overview-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            items: [{
                text: $$('All'),
                value: 'all'
            }, {
                text: $$('Successful'),
                value: 'okay'
            }, {
                text: $$('Other'),
                value: 'other'
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }]
    }],
    
    listeners: {
        cellclick: 'onCellClick'
    }
});