Ext.define('Dashboard.view.widget.RestoreStats', {
    extend: 'Ext.panel.Panel',
    xtype: 'restore-stats-widget',
    
    requires: [
        'Dashboard.view.widget.RestoreStatsModel',
        'Dashboard.view.widget.RestoreStatsController'
    ],
    
    controller: 'restore-stats',
    viewModel: {
        type: 'restore-stats'
    },
    
    layout: 'fit',

    items: [{
        xtype: 'container',
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        flex: 1,
        items: [{
            xtype: 'cartesian',
            flex: 1,
            insetPadding: '10 20 0 0',
            animation: false,
            bind: {
                store: '{restoreStats}'
            },
            border: 0,
            legend: {
                type: 'dom',
                docked: 'right',
                hidden: true // Legend is necessary to prevent flickering on mouseover
            },
            axes: [{
                type: 'numeric',
                position: 'left',
                label: {
                    fill: '#666',
                    fontSize: 10
                },
                renderer: function(axis, label) {
                    return CalcSize(label, 0);
                },
                grid: true,
                minimum: 0,
            }, {
                type: 'category',
                position: 'bottom',
                grid: true,
                label: {
                    fontSize: 10,
                    fill: '#666'
                }                
            }],
            series: [{
                type: 'bar',
                xField: 'dateShort',
                yField: 'dataAmountKiB',
                style: {
                    maxBarWidth: 50,
                    opacity: 0.80
                },
                colors: ['#6699cc'],
                tooltip: {
                    trackMouse: true,
                    renderer: function(tooltip, record) {
                        var date = Ext.util.Format.date(record.get('date'), 'M d, Y');
                        tooltip.setHtml(date + '<br>Size: ' + CalcSize(record.get('dataAmountKiB')) + '<br>Duration: ' + record.get('durationMin') + ' min');
                    }
                }
            }]
        }]
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img4/restore_24.png',
            width: 24,
            height: 24
       },'->',{
            xtype: 'segmentedbutton',
            stateful: true,
            stateId: 'restore-stats-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            defaults: {
                width: 50
            },
            items: [{
                text: '1W',
                value: 7
            }, {
                text: '2W',
                value: 14
            }, {
                text: '3W',
                value: 21
            }, {
                text: '4W',
                value: 28
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }]
    }]

});
