Ext.define('Dashboard.view.widget.DriveSpeed', {
    extend: 'Ext.panel.Panel',
    xtype: 'drive-speed-widget',
    
    requires: [
        'Dashboard.view.widget.DriveSpeedModel',
        'Dashboard.view.widget.DriveSpeedController'
    ],
    
    controller: 'drive-speed',
    viewModel: {
        type: 'drive-speed'
    },
    
    layout: 'fit',
 
    items: [{
        xtype: 'cartesian',
        reference: 'chart_ref',
        width: '100%',
        insetPadding: '10 20 5 0',
        animation: false,
        border: 0,
        axes: [{
            type: 'numeric',
            minimum: 0,
            grid: true,
            position: 'left',
            title: {
                text: 'MB/s',
                fontSize: 10
            },
            label: {
                fill: '#666',
                fontSize: 10
            },
        }, {
            type: 'numeric',
            minimum: 0,
            position: 'right',
            title: {
                text: 'MB/s',
                fontSize: 10
            },
            label: {
                fill: '#666',
                fontSize: 10
            },
        }, {
            type: 'time',
            dateFormat: 'G:i:s',
            segmenter: {
                type: 'time',
                step: {
                    unit: Ext.Date.SECOND,
                    step: 1
                }
            },
            label: {
                fill: '#666',
                fontSize: 10
            },
            grid: true,
            position: 'bottom',
            fields: ['dayTime']
        }],
        series: [{
            type: 'line',
            xField: 'dayTime',
            yField: 'speed',
            fill: true,
            style: {
                lineWidth: 1,
                opacity: 0.80
            },
            colors: ['#a0a6af'],
            marker: {
                radius: 2,
            }
        }],
        bind: {
            store: '{speedHistory}'
        }
     }],
 
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img4/lto_device_24.png',
            width: 24,
            height: 24
        }, '->', {
            xtype: 'combobox',
            reference: 'driveSelector',
            width: 180,
            queryMode: 'local',
            displayField: 'driveName',
            valueField: 'driveId',
            //value: 'all',
            bind: {
                store: '{drives}',
                value: '{selectedDriveId}'
            },
            listeners: {
                select: 'onSelectedDriveChange'
            }
        }]
    }]
 });