Ext.define("Dashboard.model.JobStats", {
    extend: 'Ext.data.Model',
    fields: [{ 
        name: 'date',
        type: 'date'
    },{
        name: 'dateShort',
        type: 'date',
        convert: function(v, record) {
            var value = record.get('date');
            return Ext.Date.format(new Date(value), 'M d');
        }
    },{ 
        name: 'error',
        type: 'number'
    },{ 
        name: 'warning',
        type: 'number'
    },{ 
        name: 'ok', 
        type: 'number',
        convert: function(value) {
            return value === 0 ? null : value;
        }
    },{ 
        name: 'warningDisplay',
        type: 'number',
        convert: function(v, record) {
            var value = record.get('warning');
            return value === 0 ? null : value - 0.3;
        }
    },{ 
        name: 'errorDisplay',
        type: 'number',
        convert: function(v, record) {
            var value = record.get('error');
            return value === 0 ? null : value + 0.3;
        }
    }],
    proxy:{
        type:'ajax',
        url: document.dashboardForm.startTdp.value,
        actionMethods:{
            read:'GET'
        },
        extraParams: {
            caller: 'ajaxJobStats',
            demoMode: localStorage.getItem('demoMode') === 'true'
        },
        reader:{
            type:'json',
            rootProperty:'data'
        }
    }
});
