// Main Window ----------------------------
Ext.define('P5U.toolbar.InfoWindow', {
	extend: 'Ext.Toolbar',
    alias : 'widget.infoWindowFooter',

	dock: 'bottom',
	ui: 'footer', 
	defaults: {
		padding: '5 15 5 15'
	},
	items: [{xtype: 'tbfill' },{
		xtype: 'button',
		text: $$('Close'),
		handler: function() {
			window.close();
		}
	},{
		xtype: 'button',
		text: $$('Restore ...'),
        itemId: 'restore_id',
        disabled: true,
		action: 'restoreWin'
	}]
})

Ext.define('P5U.toolbar.AssetInfoWindow', {
	extend: 'Ext.Toolbar',
    alias : 'widget.assetInfoWindowFooter',

	dock: 'bottom',
	defaults: {
		xtype : 'button',
		padding: '1 10 2 10'
	},
	items: [{xtype: 'tbfill' },
	{
		xtype: 'button',
		text: $$('Copy Link'),
		action: 'assetCopyLink'
	},{
		xtype: 'button',
		text: $$('Email Info ...'),
		action: 'assetMailTo'
	}]
})

Ext.define('P5U.view.InfoWindow', {
    extend: 'Ext.window.Window',
    alias : 'widget.infoWindow',

	header: false,
	layout: 'border',
	resizable: true,
	closable: false,
	border: false,
	constrain: true,
	defaults: {autoScroll: true},
	items: [{
		region: 'west',
		itemId: 'infoRegionWest_id',
		title: $$('Archive content'),
		width: 200,
		split: true,
		collapsible: true,
		collapsed: true,
		animCollapse: false,
		layout: 'fit',
	}, {
		region: 'center',
		itemId: 'infoRegionCenter_id',
		//layout: 'fit',
		title: $$('Information'),
		dockedItems: [{
			xtype: 'assetInfoWindowFooter'
		}]        
	}],
	dockedItems: [{
		xtype: 'infoWindowFooter'
	}]        
});

Ext.define('P5U.view.InfoWindowIn', {
    extend: 'Ext.window.Window',
    alias : 'widget.infoWindowIn',

	header: false,
	layout: 'border',
	resizable: true,
	closable: false,
	border: false,
	constrain: true,
	defaults: {autoScroll: true},
	items: [{
		region: 'center',
		itemId: 'infoRegionCenter_id',
		//layout: 'fit',
		title: $$('Information'),
		dockedItems: [{
			xtype: 'assetInfoWindowFooter'
		}]        
	}],
	dockedItems: [{
		xtype: 'infoWindowFooter'
	}]        
});

// Preview ----------------------------
var tpl = new Ext.XTemplate(
	'<tpl for=".">',
		'<tpl if="media == \'image\'">',
			'<div class="details" style="width: 600px; height: {ysize}px" >',
				'<img src="{clippath}" style="width: {xsize}px" title="{name}">',        
			'</div>',
		'<tpl else>',
            '<tpl if="container == \'.mp4\'">',		
                '<div class="details" style="width: 600px; height: {ysize}px" >',
                    '<video style="display:block; margin: 0 auto;" width=320 controls autoplay>',
                        '<source src="{clippath}" type="video/mp4"></source>',
                    '</video>',
                '</div>',
    		'<tpl else>',
                '<div class="details" style="width: 600px; height: {ysize}px" >',
                    '<object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" style="width: {xsize}px; height: {ysize}px" codebase="http://www.apple.com/qtactivex/qtplugin.cab">',
                        '<param name="src" value="{clippath}"/>',
                        '<param name="autoplay" value="true"/>',
                        '<param name="controller" value="true"/>',
                        '<param name="loop" value="false"/>',
                        '<param name="scale" value="aspect"/>',
                        '<embed src="{clippath}" style="width: {xsize}px; height: {ysize}px" scale="aspect" autoplay="true" controller="true" loop="false" pluginspage="http://www.apple.com/quicktime/"/>',
                    '</object>',
                '</div>',
    		'</tpl>',                
		'</tpl>',
	'</tpl>'
);

Ext.define('P5U.view.Preview' ,{
    extend: 'Ext.view.View',
    alias : 'widget.mdpreview',
	id: 'images-preview',

	store: 'Preview',
	tpl: tpl,
	itemSelector: 'div.details',
	width: '100%'
});
// Form ----------------------------
Ext.define('DisplayDatefield', {
	extend: 'Ext.form.field.Display',
	alias: ['widget.displaydatefield'],

	rawToValue: function(rawValue) {
		return renderDate(rawValue);
	},
	valueToRaw: function(value) {
		return renderDate(value);
	}
});

Ext.define('DisplaySizefield', {
	extend: 'Ext.form.field.Display',
	alias: ['widget.displaysizefield'],

	rawToValue: function(rawValue) {
		return calcSizeIdx(rawValue);
	},
	valueToRaw: function(value) {
		return calcSizeIdx(value);
	}
});

Ext.define('P5U.view.infoForm', {
	extend: 'Ext.form.Panel',
	alias : 'widget.infoForm',

	frame: true,
	waitMsgTarget:true,
	bodyStyle: 'padding: 5px',
	layout: 'anchor',
	myNode: '',
	myUpdate: function () {
        this.getForm().submit({
            url:  P5U.globals.serverpage,
			waitMsg: $$('Saving')+' ...',
			params: {
				caller: 'ajaxSetMetadata',
				node: P5U.globals.assetUrl
			},
			success:function(form, loadobj) {
				srvMsg(loadobj.response.responseXML);
			}
        });
	},
	myLoad: function (elementurl) {
		this.myNode = elementurl;
		this.getForm().reset();
		this.getForm().load({
			url: P5U.globals.serverpage,
			waitMsg: $$('Loading')+' ...',
			params: {
				caller: 'ajaxGetMetadata',
				node: elementurl
			},
			success:function(form, loadobj) {
				srvMsg(loadobj.response.responseXML);
			}
		});
	},
	myReset: function () {
		if (this.myNode != "") {
			this.myLoad(this.myNode);
		};
	},
	myRemoveall: function () {
		this.getForm().reset();
	},
    initComponent: function() {
        var me = this;
        Ext.apply(me, {
			reader: Ext.create('Ext.data.reader.Xml', {
				model: 'P5U.model.Metadata',
				root: 'metadata',
				record : 'node',
				successProperty: '@success'
			}),
			errorReader: Ext.create('Ext.data.reader.Xml', {
				model: 'P5U.model.ErrorMsg',
				record : 'field',
				successProperty: '@success'
			})
        });
        me.callParent(arguments);
    }
});

Ext.define('P5U.view.VersionGrid' ,{
    extend: 'Ext.grid.Panel',
    alias : 'widget.versiongrid',
    
	flex: 1,                        
	autoScroll : true,
	height : 120,
	initComponent: function() {
		var me = this;

		Ext.applyIf(me, {
			store: 'Versions'
		});    
		me.callParent(arguments);
	}
});    

Ext.define('P5U.view.IndexContentGrid', {
    extend: 'Ext.tree.Panel',
    alias : 'widget.indexcontentgrid',

	padding: '0 0 0 0',
	useArrows: true,
	multiSelect: false,
	rootVisible: true,
	border: false,
	bufferedRenderer: false,
	columns: [{ text: $$('Name'), dataIndex: 'name', xtype: 'treecolumn', flex: 1 }],
	initComponent: function() {
		var me = this;
		Ext.applyIf(me, {
			store: 'IndexContent'
		});    
		me.callParent(arguments);
	}
});
