//#############################################################################
//
//  lexxmainlib.js
//
//    JavaScript Client Library
//
//    See the file "license.txt" for information on usage and
//    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
//    Rcsid: @(#)$Id: lexxmainlib.js,v 1.177 2019/01/09 11:11:13 jd Exp $
//
//#############################################################################

ie5=document.all&&document.getElementById
ns6=document.getElementById&&!document.all
            
if ( navigator.platform == "MacPPC" ) {
    clientPlatform = '1'
} else {
    clientPlatform = '0'
}

if ( navigator.appName == "Netscape" ) {
    browserType = "ne"
} else if ( navigator.appName.indexOf("Microsoft") != -1 ) {
    browserType = "ie"
}

if ((navigator.appVersion.indexOf("Win") != -1)) {
    platformWin = true
} else {
    platformWin = false
}

if ((navigator.appVersion.indexOf("Mac") != -1)) {
    platformMac = true
} else {
    platformMac = false
}

cbe            = "cbe"
bgcolor        = "#CCCCCC"
lastElement    = ""
lastRow        = ""
checkedStatus  = true
pageSubmited   = false
moreThanOne    = ""
singleElement  = ""
selectedObject = ""
elementBgcolor = "#FFFFFF"
menuMarColor   = "#4E5A6C"
rowMarkColor   = "#BBD4EB"
checkedColor   = rowMarkColor
submenu        = "_dummy_"
hidePopUp      = ""
moreThanOne    = false
menuToHide     = ['PopFileBox','PopEditBox','PopViewBox','PopSelectHelpBox','PopPwdBox','PopApplicationBox','PopHelpBox','PopJobBox','PopBskPosBox','PopBasketBox']
YUC            = "YAHOO.util.Connect";
YUE            = "YAHOO.util.Event";
YUDD           = "YAHOO.util.DD";
markedRow      = 'home';
markedMenu     = '_dummy_';


function frameHeight() {
    var y;
    if (self.innerHeight) // all except Explorer
    {
        y = self.innerHeight;
    }
    else if (document.documentElement && document.documentElement.clientHeight)
        // Explorer 6 Strict Mode
    {
        y = document.documentElement.clientHeight;
    }
    else if (document.body) // other Explorers
    {
        y = document.body.clientHeight;
    }
    return y;
}

function frameWidth() {
    var x;
    if (self.innerHeight) // all except Explorer
    {
        x = self.innerWidth;
    }
    else if (document.documentElement && document.documentElement.clientHeight)
        // Explorer 6 Strict Mode
    {
        x = document.documentElement.clientWidth;
    }
    else if (document.body) // other Explorers
    {
        x = document.body.clientWidth;
    }
    return x;
}

function waitBox(frame) {
    var func = function() { nowWait(frame);}; 
    waitBoxTimer = setTimeout(func,100);
}

function nowWait(frame) {
    if ( typeof(frame) !== 'undefined' && parent.frames[frame] ) {
        parent.frames[frame].document.getElementById('ajxlod').style.visibility = "visible";
    } else {
        document.getElementById('ajxlod').style.visibility = "visible";
    }
}

function hideWait(frame) {
    if (waitBoxTimer) clearTimeout(waitBoxTimer);
    if ( typeof(frame) !== 'undefined' && parent.frames[frame] ) {
        parent.frames[frame].document.getElementById('ajxlod').style.visibility = "hidden";
    } else {
        document.getElementById('ajxlod').style.visibility = "hidden";
    }
}

function resetInput(eButton,str) {
    if ( eButton.value == str ) {
        eButton.value = '';
    }
}

function getWindowW() {
    if ( browserType == "ie" ) {
        return(parent.frames[0].document.body.offsetWidth)
    } else {
        return(parent.frames[0].window.innerWidth)
    }
}
function toolReady() {
    window.parent.toolFrame = true
    blockFunctions();
}
function menuReady() {
    window.parent.menuFrame = true
    document.oncontextmenu=new Function('return false')
    document.onselectstart=new Function('return false')
}
function infoReady() {
    window.parent.infoFrame = true
    blockFunctions();
}
function blockFunctions() {
    document.oncontextmenu=new Function('return false')
    document.onselectstart=new Function('return false')
    document.onmousedown=new Function('return false')
}
function pCursor(eButton) {
    eButton.style.cursor = 'pointer';
}
function iReduce(eButton) {
    if ( eButton && posWidth ) {
        eButton.style.width  = posWidth;
        eButton.style.height = posHeight;
    }
}
function iExpand(eButton) {
    posWidth  = eButton.style.posWidth
    posHeight = eButton.style.posHeight
    eButton.style.posHeight = 15
    eButton.style.width     = 280
}
function followcursor() {
    cursormessage.style.visibility="visible"
    cursormessage.style.left=document.body.scrollLeft+event.clientX+10
    cursormessage.style.top=document.body.scrollTop+event.clientY+10
}
function strInNr(str) {
    var reg = /[0-9]*/
    return(reg.exec(str))
}
function agentSetup(eButton) {
    if ( parent.frames[0] ) {
        parent.frames[0].MenuSwitchToolbar('agent')
    }
}
function menuBrowserFilelist(treetype) {
    if ( document.getElementById('PopFileBox') ) {
        if ( parent.frames[0].document.getElementById('MenuFileV') ) {
            parent.frames[0].document.getElementById('MenuFileV').style.visibility   = "visible";
            parent.frames[0].document.getElementById('MenuFileH').style.visibility   = "hidden";
        }
    } else {
        if ( parent.frames[0].document.getElementById('MenuFileV') ) {
            parent.frames[0].document.getElementById('MenuFileV').style.visibility   = "hidden";
            parent.frames[0].document.getElementById('MenuFileH').style.visibility   = "visible";
        }
    }
    if ( document.getElementById('PopEditBox') ) {
        if ( parent.frames[0].document.getElementById('MenuEditV') ) {
            parent.frames[0].document.getElementById('MenuEditV').style.visibility   = "visible";
            parent.frames[0].document.getElementById('MenuEditH').style.visibility   = "hidden";
        }
    } else {
        if ( parent.frames[0].document.getElementById('MenuEditV') ) {
            parent.frames[0].document.getElementById('MenuEditV').style.visibility   = "hidden";
            parent.frames[0].document.getElementById('MenuEditH').style.visibility   = "visible";
        }
    }
    if ( document.getElementById('PopViewBox') ) {
        if ( parent.frames[0].document.getElementById('MenuViewV') ) {
            parent.frames[0].document.getElementById('MenuViewV').style.visibility   = "visible";
            parent.frames[0].document.getElementById('MenuViewH').style.visibility   = "hidden";
        }
    } else {
        if ( parent.frames[0].document.getElementById('MenuViewV') ) {
            parent.frames[0].document.getElementById('MenuViewV').style.visibility   = "hidden";
            parent.frames[0].document.getElementById('MenuViewH').style.visibility   = "visible";
        }
    }
    if ( parent.frames[0].document.getElementById('MenuSearch') ) {
        parent.frames[0].document.getElementById('MenuSearch').style.display    = "none";
    }
}
function menuBrowserVolumenlist() {
    if ( parent.frames[0] ) {
        parent.frames[0].document.getElementById('MenuFileV').style.visibility   = "hidden";
        parent.frames[0].document.getElementById('MenuFileH').style.visibility   = "visible";
        parent.frames[0].document.getElementById('MenuEditV').style.visibility   = "hidden";
        parent.frames[0].document.getElementById('MenuEditH').style.visibility   = "visible";
        parent.frames[0].document.getElementById('MenuViewV').style.visibility   = "hidden";
        parent.frames[0].document.getElementById('MenuViewH').style.visibility   = "visible";
        parent.frames[0].document.getElementById('MenuSearch').style.display     = "none";
    }
}
function MenuSwitchToolbar(box,cmd) {
    hideMenu(markedMenu);
    if ( document.getElementById(markedRow) ) {
        if ( markedRow == 'home' ) {
            document.getElementById(markedRow + ':icon').className='home_48';
        }
        document.getElementById(markedRow).className='iconOuterBox';
    }
    if ( document.getElementById(box) ) {
        if ( box == 'home' ) {
            document.getElementById(box + ':icon').className='home_48_a';
            document.getElementById(box).className='iconOuterBoxS';
        } else {
            document.getElementById(box).className='iconOuterBoxS';
        }
        markedRow = box;
    }
    if ( parent.frames[1] ) {
        parent.frames[1].switchToolbar(box,cmd);
    }
}
function showMenu(e,box) {
    popupMenu(e,box);
    if ( document.getElementById(box) ) {
        markedMenu  = box;
        document.getElementById(box).className=box+'_a';
    }
}
function popupMenu(e,box) {
    popupHide();
    var evt = (e) ? e : ((event) ? event : null);
    var elm = (evt.target) ? evt.target : evt.srcElement;
    var nod = elm.parentNode
    if ( parent.frames[2].document.getElementById(box) ) {
        var menuBox = parent.frames[2].document.getElementById(box);
        var frWidth = parseInt(parent.frames[2].document.body.clientWidth);
        var winDif  = parseInt(parent.frames[0].document.body.clientWidth) - frWidth;
        posLeft = parseInt(nod.offsetLeft) - winDif
        var rSpace  = frWidth - posLeft;
        if (rSpace<menuBox.offsetWidth) {
            menuBox.style.left = posLeft + nod.offsetWidth - menuBox.offsetWidth + 'px';
        } else {
            menuBox.style.left = posLeft + 'px';
        }
        var topPos = getScrollHeight(parent.frames[2]);
        menuBox.style.top = topPos - 1 + 'px'
        menuBox.style.visibility = "visible";
    }
}
function getScrollHeight(eButton) {
   var h = eButton.pageYOffset ||
           eButton.document.body.scrollTop ||
           eButton.document.documentElement.scrollTop;
           
   return h ? h : 0;
}
function popupMenu2(eButton,box) {
    popupHide();
    if ( parent.frames[2].document.getElementById(box) ) {
        var menuBox = parent.frames[2].document.getElementById(box);
        var butRight = parseInt(eButton.style.right);
        menuBox.style.right = eButton.offsetWidth + 'px';
        var topPos = getScrollHeight(parent.frames[2]);
        menuBox.style.top = topPos - 1 + 'px'
        menuBox.style.visibility = "visible";
    }
}
function popupSubmenu(menu,box,wid) {
    var wid = parseInt(wid)
    var nod = menu.parentNode;
    if ( document.getElementById(box) ) {
        submenu = box;
        var posLeft = parseInt(nod.style.left) + wid - 7 + 'px';
        var posTop  = parseInt(nod.style.top) + parseInt(menu.style.top) + 2 + 'px';
        document.getElementById(box).style.left = posLeft;
        document.getElementById(box).style.top  = posTop;
        document.getElementById(box).className='PopLogBox';
        document.getElementById(box).style.visibility = "visible";
    }
}
function popupSubButton(e,box) {
    popupHide();
    var evt = (e) ? e : ((event) ? event : null);
    var elm = (evt.target) ? evt.target : evt.srcElement;
    var nod = elm.parentNode
    var sup = document.getElementById('buttonDock')
    if ( document.getElementById(box) ) {
        submenu = box
        var posLeft = parseInt(elm.offsetLeft) + 'px'
        var mHeight = parseInt(document.getElementById(box).style.height)
        var sOffset = parseInt(window.pageYOffset)
        var posTop  = parseInt(sup.offsetTop) + sOffset - mHeight + 5 + 'px'
        document.getElementById(box).style.left = posLeft;
        document.getElementById(box).style.top  = posTop
        document.getElementById(box).className='PopLogBoxBotLeft';
        document.getElementById(box).style.visibility = "visible";
    }
}
function popupButton(e,box) {
    popupHide();
    var evt = (e) ? e : ((event) ? event : null);
    var elm = (evt.target) ? evt.target : evt.srcElement;
    var nod = elm.parentNode
    var sup = document.getElementById('buttonDock')
    if ( document.getElementById(box) ) {
        var menuBox = document.getElementById(box);
        var posLeft = parseInt(nod.offsetLeft) + 18 + 'px'
        var mHeight = parseInt(document.getElementById(box).style.height)
        var sOffset = parseInt(window.pageYOffset)
        var posTop  = parseInt(sup.offsetTop) + sOffset - mHeight + 5 + 'px'
        document.getElementById(box).style.left = posLeft;
        document.getElementById(box).style.top  = posTop
        document.getElementById(box).style.visibility = "visible";
    }
}
function popupBox(e,box) {
    popupHide();
    var evt = (e) ? e : ((event) ? event : null);
    var elm = (evt.target) ? evt.target : evt.srcElement;
    if ( document.getElementById(box) ) {
        var posLeft = parseInt(elm.offsetLeft) + parseInt(elm.offsetWidth) - 14 + 'px'
        var posTop  = parseInt(elm.offsetTop)  + parseInt(window.pageYOffset) + parseInt(elm.offsetHeight) + 6 + 'px'
        document.getElementById(box).style.left = posLeft;
        document.getElementById(box).style.top  = posTop
        document.getElementById(box).style.visibility = "visible";
    }
}
function hideSubmenu() {
    if ( document.getElementById(submenu) ) {
        document.getElementById(submenu).style.visibility = "hidden";
    }
}
function popupHide(e) {
    var eve=window.event? event : e
    //#check if button is not right
    if (eve && eve.button == 2 ) return false;
    if (!parent.frames[2] ) return false;
    if ( parent.frames[2].lastRow  != "" ) popupUnmark(parent.frames[2].lastRow)
    for ( menuBox in menuToHide ) {
        if ( parent.frames[2].document.getElementById(menuToHide[menuBox]) ) {
            var menuDa = parent.frames[2].document.getElementById(menuToHide[menuBox]).style.visibility
            if ( menuToHide[menuBox] == parent.frames[0].markedMenu && menuDa == 'visible' ) {
                hideMenu(parent.frames[0].markedMenu);
            }
            parent.frames[2].document.getElementById(menuToHide[menuBox]).style.visibility = "hidden";
        }
    }
    if ( document.getElementById(submenu) ) {
        document.getElementById(submenu).style.visibility = "hidden";
    }
    if ( document.getElementById('hintHowToNewBox') ) {
        document.getElementById('hintHowToNewBox').style.visibility = "hidden";
    }
    if ( document.getElementById('msizebox') ) {
        document.getElementById('msizebox').style.visibility = "hidden";
    }
}
function hideMenu(box) {
    if ( parent.frames[0].document.getElementById(box) ) {
        parent.frames[0].document.getElementById(box).className=box;
    }
}
function popupMark(eButton) {
    popupUnmark(lastRow)
    if ( eButton ) {
        eButton.className='PopLogRow1M';
        lastRow = eButton
    }
}   
function popupUnmark(eButton) {
    if ( eButton ) {
        eButton.className='PopLogRow1';
    }
}
//# row mark
function elementMark(eButton,evt) {
    if ( evt.metaKey || ( evt.ctrlKey && !platformMac ) ) {
        if ( document.getElementById(cbe+eButton.id).checked == true ) {
            popupUnMarkElement(eButton)
            return
        }
        popupMarkElement(eButton)
        singleElement = document.getElementById(cbe+eButton.id).value
        moreThanOne = true
        lastElement = eButton
    } else if ( evt.shiftKey ) {
        checkRangeElements(eButton)
        lastElement = eButton
    } else {
        if ( moreThanOne ) {
            deCheckAllElements()
        }
        if ( lastElement != "" ) {
            popupUnMarkElement(lastElement)
        }
        if ( eButton ) {
            elementBgcolor = eButton.style.backgroundColor
            popupMarkElement(eButton)
            singleElement = document.getElementById(cbe+eButton.id).value
            lastElement = eButton
        }
    }
}   
function checkRangeElements(eButton) {
        var currentRow = eButton.id
        for ( var row = 0 ; row < elementCount ; row++ ) {
            if ( document.getElementById(cbe+row).checked ) {
                if ( typeof firstRow == 'undefined' ) {
                    var firstRow = row
                }
                var lastRow = row
            }
        }
        if ( typeof firstRow == 'number' ) {
            if ( currentRow < firstRow ) {
                var startRow = currentRow
                var endRow   = lastRow
            } else if ( currentRow > lastRow ) {
                var startRow = firstRow
                var endRow   = currentRow
            } else {
                var startRow = firstRow
                var endRow   = lastRow
            }
        } else {
            var startRow = currentRow
            var endRow   = currentRow
        }
        if ( startRow == endRow ) moreThanOne = false;
        for ( var row = startRow ; row <= endRow ; row++ ) {
            var elm  = document.getElementById(row)
            if ( row > currentRow && currentRow > startRow ) {
                popupUnMarkElement(elm)
            } else {
                popupMarkElement(elm)
            }
        }
        moreThanOne = true
}
function deCheckAllElements() {
        numberElements  = 0
        selecedElements = ""
        elementurl      = ""
        elementType     = ""
        for ( var row = 0 ; row < elementCount ; row++ ) {
            var elm  = document.getElementById(row)
            popupUnMarkElement(elm)
        }
        checkedStatus   = false
        moreThanOne     = false
}
function popupMarkElement(eButton) {
    if ( eButton ) {
        document.getElementById(cbe+eButton.id).checked = true
        eButton.style.backgroundColor = rowMarkColor;
    }
}   
function popupUnMarkElement(eButton) {
    if ( eButton ) {
        document.getElementById(cbe+eButton.id).checked = false
        eButton.style.backgroundColor = elementBgcolor;
        singleElement = ""
    }
}   
//# contex menu in file listing  
function contextMenu(e) {
	var posx = 0;
	var posy = 0;
	if (!e) var e = window.event;
	if (e.pageX || e.pageY) 	{
		posx = e.pageX;
		posy = e.pageY;
	}
	else if (e.clientX || e.clientY) 	{
		posx = e.clientX + document.body.scrollLeft
			+ document.documentElement.scrollLeft;
		posy = e.clientY + document.body.scrollTop
			+ document.documentElement.scrollTop;
	}
    menuBox=document.getElementById("PopEditBox")
    // if the left/right distance isn't enough to accomodate the width of the context menu
	var rightedge=Ext.getBody().getViewSize().width - posx + document.body.scrollLeft + document.documentElement.scrollLeft;
	var bottomedge=Ext.getBody().getViewSize().height - posy + document.body.scrollTop + document.documentElement.scrollTop;
    if (rightedge<menuBox.offsetWidth) {
        menuBox.style.left = posx - menuBox.offsetWidth  +'px'
    } else {
        menuBox.style.left = posx +'px';
    }
    if (bottomedge<menuBox.offsetHeight) {
         menuBox.style.top = posy - menuBox.offsetHeight  +'px'
    } else {
        menuBox.style.top  = posy +'px';
    }
    menuBox.style.visibility="visible"
    return false
}
//# hide menu with delay,
function delayHideMenu_dummy() {
    for ( obj in menuObjList ) {
        var localObj = document.getElementById(menuObjList[obj]);
        if ( localObj && !localObj.timeOut ) {
            localObj.timeOut  = true;
            var timeFunction  = function () { localObj.style.visibility = 'hidden'; localObj.timeOut = false; }
            localObj.timerID  = window.setTimeout(timeFunction,2000);
        }
    }
}
function thisVolumen(eButton) {
    waitBox('2');
    document.filelist.caller.value = "volumenListing";
    document.filelist.elementurl.value = document.getElementById('url'+eButton.id).value;
    document.filelist.elementtxt.value = document.getElementById('txt'+eButton.id).value;
    document.filelist.loginArea.value  = document.getElementById('lga'+eButton.id).value;
    document.filelist.workstation.value  = document.getElementById('wst'+eButton.id).value;
    document.filelist.submit();
}
function searchVolumen(eButton) {
    document.getElementById('wsbody').style.cursor = "wait"
    var la = eButton.value.split(':')
    document.filelist.caller.value = "volumenListing";
    document.filelist.elementurl.value  = la[0];
    document.filelist.loginArea.value   = la[1];
    document.filelist.submit();
}
function checkAllElements() {
        numberElements  = 0
        selecedElements = ""
        var elm         = ""
        var inloop      = ""
        var outloop     = ""
        for ( var row = 0 ; row < elementCount ; row++ ) {
            checkBox = cbe+row
            document.getElementById(checkBox).checked = true
            document.getElementById(checkBox).parentNode.parentNode.style.backgroundColor = rowMarkColor
            elm             = document.getElementById(checkBox).value
            selecedElements = selecedElements+inloop
            inloop          = elm+"\r"
            outloop         = elm
            elementurl      = document.getElementById(checkBox).value
            elementType     = document.getElementById(checkBox).name
            numberElements++
        }
        selecedElements = selecedElements+outloop        
        checkedStatus   = true
        moreThanOne     = true
}
function getCheckedElements(eButton) {
    numberElements  = 0
    selecedElements = ""
    var elm         = ""
    var inloop      = ""
    var outloop     = ""
    for ( var row = 0 ; row < elementCount ; row++ ) {
        checkBox = cbe+row
        if ( document.getElementById(checkBox).checked ) {
            elm             = document.getElementById(checkBox).value
            selecedElements = selecedElements+inloop
            inloop          = elm+"\r"
            outloop         = elm
            elementurl      = document.getElementById(checkBox).value
            elementType     = document.getElementById(checkBox).name
            numberElements++
        }
    }
    selecedElements = selecedElements+outloop
}
function checkForSingle() {
    if ( numberElements > 1 ) {
        alert(top.opener.document.msgForm.jsmsg2.value)
        return 0
    }
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    return 1
}
function checkForMulti() {
    if ( numberElements < 1 ) {
        alert(top.opener.document.msgForm.jsmsg18.value)
        return 0
    }
    return 1
}
function actSelected(eButton,evt) {
    popupHide()
    elementMark(eButton,evt)
}
function inBasket(basket) {
    popupHide()
    getCheckedElements()
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    waitBox('2');
    document.filelist.caller.value = "inBasket";
    document.filelist.basket.value = basket;
    document.filelist.selectedelements.value = selecedElements;
    document.filelist.submit();
}
function wstRestore(evt) {
    popupHide()
    getCheckedElements(evt)
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    if ( confirm(top.opener.document.msgForm.jsmsg23.value) ) {
        document.filelist.caller.value = "wstRestore";
        document.filelist.selectedelements.value = selecedElements;
        parent.frames[3].gorestore(evt);
    }
}
function wstRestoreTo(evt) {
    popupHide()
    getCheckedElements(evt)
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    document.filelist.caller.value = "wstRestoreTo";
    document.filelist.selectedelements.value = selecedElements;
    parent.frames[3].filePicker();
}
function toDownload(eButton) {
    popupHide()
    getCheckedElements(eButton)
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    document.filelist.action = document.filelist.action+"/download.zip";
    document.filelist.caller.value = "toDownload";
    document.filelist.selectedelements.value = selecedElements;
    document.filelist.submit();
}
function emptyBasketMelement(eButton) {
    popupHide()
    checkedStatus = true
    checkedColor  = rowMarkColor
    checkAllElements()
    if ( confirm(top.opener.document.msgForm.jsmsg13.value) ) {
        parent.frames[2].document.filelist.caller.value = "deleteElement";
        parent.frames[2].document.filelist.selectedelements.value = selecedElements;
        parent.frames[2].document.filelist.submit();
    }
}
function deleteBasketMelement(eButton) {
    popupHide()
    getCheckedElements(eButton)
    if ( confirm(top.opener.document.msgForm.jsmsg14.value) ) {
        parent.frames[2].document.filelist.caller.value = "deleteElement";
        parent.frames[2].document.filelist.selectedelements.value = selecedElements;
        parent.frames[2].document.filelist.submit();
    }
}
function deleteBasketSelement(eButton) {
    popupHide()
    getCheckedElements(eButton)
    parent.frames[2].document.filelist.caller.value = "deleteElement";
    parent.frames[2].document.filelist.selectedelements.value = singleElement;
    parent.frames[2].document.filelist.submit();
}
function infoTranslat(eButton) {
    popupHide()
    getCheckedElements(eButton)
    if ( checkForSingle() == 0) return
    infoTranslatWindow(elementPathById)
}
function downloadElement(eButton) {
    popupHide()
    getCheckedElements(eButton)
    if ( checkForSingle() == 0 ) return
    if ( elementType != "file" ) {
        alert(top.opener.document.msgForm.jsmsg2.value)
        return
    }
    if ( window.clientInformation.platform == "MacPPC" ) {
        appendix = '?mb'
    } else {
        appendix = ''
    }
    alert(singleElement)
    if ( confirm(top.opener.document.msgForm.jsmsg15.value) ) {
        parent.location.href='download'+escape(singleElement)+appendix
    }    
}
function changeView(eButton) {
    parent.frames[2].document.forms[0].viewstyle.value  = eButton;
    parent.frames[2].document.forms[0].caller.value     = "sortColumn";
    parent.frames[2].document.forms[0].sortColumn.value = 'name' ;
    parent.frames[2].document.forms[0].submit();
}
function sortCol(eButton) {
    if ( document.forms[0].sortColumn.value == eButton ) {
        if (document.forms[0].sortDirection.value == "dec" ) {
            document.forms[0].sortDirection.value = "inc"
        } else {
            document.forms[0].sortDirection.value = "dec"
        }
    } else {
        document.forms[0].sortDirection.value = "inc"
    }
    document.forms[0].caller.value = "sortColumn";
    document.forms[0].sortColumn.value = eButton ;
    document.forms[0].submit();
}
function jslog() {
    if ( document.errorForm.pageErrorMsg.value != "" ) {
        alert(document.errorForm.pageErrorMsg.value)
    } else {
        if ( document.infoForm.isMsg && document.infoForm.isMsg.value == "true" ) {
            var buttonsOpts = {};
            var button_ok = document.infoForm.button_ok.value;
            buttonsOpts[button_ok] = function() { $( this ).dialog( "close");}
            $( "#dialog-modal" ).dialog({
                width: 400,
                modal: true,
                autoOpen:true,
                buttons: buttonsOpts
            });
            $('.ui-widget-overlay').click(function() { $("#dialog-modal").dialog("close"); });
        }
    }
}
function ialert(obj) {
    var buttonsOpts = {};
    var button_ok = 'OK';
    buttonsOpts[button_ok] = function() { $( this ).dialog( "close");}
    $( obj ).dialog({
        width: $(obj).attr("width"),
        modal: true,
        autoOpen:true,
        buttons: buttonsOpts
    });
    $('.ui-widget-overlay').click(function() { $( obj ).dialog("close"); });
}
function jalert(title,message) {
    if ( message === "" ) return true;
    // Newlines durch <br> ersetzen
    message = message.replace(/\n/g, '<br>');
    var buttonsOpts = {};
    var button_ok = document.infoForm.button_ok.value;
    buttonsOpts[button_ok] = function() { $( this ).dialog( "close");}
    $("#dialog-modal").html('<p>'+message+'</p>')
    $("#dialog-modal").dialog({
        modal: true,
        title: title,
        autoOpen:true,
        width: 400,
        height: 200,
        classes: {
            "ui-dialog": "jalert-dialog"
        },
        buttons: buttonsOpts
    });
    $('.ui-widget-overlay').click(function() { $("#dialog-modal").dialog("close"); });
    
    return true;
}
function smartAlert(message) {
    if (typeof $ !== 'undefined' && 
        typeof $.fn.dialog !== 'undefined' && 
        $('#dialog-modal').length > 0) {
        jalert('Note', message);
    } else {
        alert(message);
    }
}
function jkualert(msg) {
    if (typeof(msg) !== 'undefined' && msg != null && msg != "" ) {
        alert(msg)
    }
}
function checkElementName(elementname) {
    var reg2 = /[^a-zA-Z0-9-_]+/;
    var result  = reg2.exec(elementname)    
    if ( result != null ) {
        smartAlert(top.opener.document.msgForm.jsmsg101.value)
        return 0
    }
    return 1
}
function checkResourceName(elementname) {
    if ( elementname == '' ) {
        smartAlert(document.msgForm.jsmsg20.value)
        return 0 
    }
    var reg = / |\/|{|}|\\|:|\*|\?|<|>|\||~|\$|\'|\"/ ;
    if ( reg.exec(elementname) ) {
        smartAlert(document.msgForm.jsmsg21.value)
        return 0
    }
    return 1
}
function checkPathName(elementname) {
    var reg = /\\|\"|\'|<|>|\|/ ;
    if ( reg.exec(elementname) ) {
        smartAlert(top.opener.document.msgForm.jsmsg7.value)
        return 0
    }
    return 1
}
function checkNumber(elementname) {
    var reg = /^\d+$/ ;
    if ( !reg.test(elementname) ) {
        alert(top.opener.document.msgForm.jsmsg20.value)
        return 0
    }
    return 1
}
function checkPathAbsolut(elementname,msg) {
    var reg = /^\// ;
    if ( (!reg.exec(elementname) || elementname == '' ) && elementname != 'ALL' ) {
        smartAlert(msg)
        return 0
    }
    return 1
}
function checkDriveLetter(elementname,msg) {
    var reg = /^\/[A-Za-z]$/ ;
    if ( (!reg.exec(elementname) || elementname == '' ) ) {
        alert(msg)
        return 0
    }
    return 1
}
function checkIfRoot(isAdminUser) {
    if ( isAdminUser == 0 ) {
        alert(top.opener.document.msgForm.jsmsg9.value)
        return 0
    }
    return 1
}
function checkEmailAddress(email) {
    var reg = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/ ;
    if ( !reg.test(email) ) {
        alert(document.msgForm.jsmsg10.value)
        return 0
    }
    return 1
}
function calcModeDecimalBin(protarray,mode) {
    for ( var opt = 0 ; opt < protarray.length ; opt++ ) {
        pos = Math.pow(2,opt)
        if ( ( mode & pos ) > 0 ) {
            document.resourceForm[protarray[opt]].checked = true
        }
    }
}
function calcModeBinDecimal(protarray) {
    var mode = 0
    for ( var opt = 0 ; opt < protarray.length ; opt++ ) {
        if ( document.resourceForm[protarray[opt]].checked ) {
            mode = mode + Math.pow(2,opt)
        }
    }
    return mode
}
function collectAllAttributesOnPage() {
    allAttributesOnPage = ""
    for ( var index = 0 ; 1 == 1 ; index++ ) {
        if ( document.resourceForm.elements[index] ) {
            allAttributesOnPage = allAttributesOnPage + document.resourceForm.elements[index].name + " "
        } else {
           break
        }
    }
    return allAttributesOnPage
}
function selectSelected(selected,option) {
    for ( var opt = 0 ; opt < document.planForm.elements[option].options.length ; opt++ ) {
        if ( selected == document.planForm.elements[option].options[opt].value ) {
            document.planForm.elements[option].options[opt].selected = true
        }
    }
}
function actDblClick(eButton) {
    if ( pageSubmited ) return
    var elementurl  = document.getElementById(cbe+eButton.id).value
    var elementType = document.getElementById(cbe+eButton.id).name
    if ( elementType == "Directory" || elementType == "Container" ) {
        waitBox('2');
        pageSubmited = true
        parent.frames[2].document.forms[0].caller.value     = "nextDir";
        parent.frames[2].document.forms[0].elementurl.value = elementurl;
        parent.frames[2].document.forms[0].submit();
    } else {
        getCheckedElements(eButton)
        if ( numberElements > 1 ) {
            eval(client[elementType].open.jsfunc)
        } else {
            openWindow(elementType,elementurl)
        }
    }
}
function actDblClickRes(eButton) {
    if ( pageSubmited ) return
    var elementurl  = '';
    var elementType  = document.getElementById(cbe+eButton.id).name
    document.hammerForm.selected.value  = document.getElementById(cbe+eButton.id).value;
    openWindow(elementType,elementurl)
}
function actLinkRes(typ,res) {
    var elementurl  = '';
    var elementType  = typ;
    document.hammerForm.selected.value  = res;
    openWindow(elementType,elementurl)
}
function prevDirDbl(eButton) {
    if ( pageSubmited ) return
    waitBox('2');
    parent.frames[2].document.forms[0].caller.value = "previousDir";
    parent.frames[2].document.forms[0].elementurl.value = document.getElementById('cbi'+eButton.id).value;
    pageSubmited = true
    parent.frames[2].document.forms[0].submit();
}
function prevDir(eButton) {
    if ( pageSubmited ) return
    waitBox('2');
    parent.frames[2].document.forms[0].caller.value = "previousDir";
    parent.frames[2].document.forms[0].elementurl.value = eButton.id ;
    pageSubmited = true
    parent.frames[2].document.forms[0].submit();
}
function aosf(row) {
    if ( pageSubmited ) return
    var elementurl  = parent.frames[2].document.getElementById(cbe+row).value
    var elementType = parent.frames[2].document.getElementById(cbe+row).name
    if ( elementType == "Directory" || elementType == "Container" ) {
        pageSubmited = true
        parent.frames[2].document.forms[0].caller.value     = "nextDir";
        parent.frames[2].document.forms[0].elementurl.value = elementurl;
        parent.frames[2].document.forms[0].submit();
    } else {
        openWindow(elementType,elementurl)
    }
}
function cdLog(elementurl) {
    if ( elementurl == "" ) return
    parent.frames[2].document.filelist.caller.value     = "cdLog";
    parent.frames[2].document.filelist.elementurl.value = elementurl;
    parent.frames[2].document.filelist.submit();
}
function mkTCLlist(inobj, outobj) {
    if ( inobj && outobj ) {
        for ( var opt = 0 ; opt < inobj.options.length ; opt++ ) {
            if ( inobj.options.length == 1 || opt == 0 ) {
                outobj.value = '{'+inobj.options[opt].value+'}'
            } else {
                outobj.value = outobj.value+' {'+inobj.options[opt].value+'}'
            }
        }
    }
}
function muliTCLlist(inobj, outobj) {
    for ( var opt = 0 ; opt < inobj.options.length ; opt++ ) {
        if (!inobj.options[opt].selected ) continue    
        if (inobj.options[opt].value == '' ) continue    
        if ( inobj.options.length == 1 || opt == 0 ) {
            outobj.value = '{'+inobj.options[opt].value+'}'
        } else {
            outobj.value = outobj.value+' {'+inobj.options[opt].value+'}'
        }
    }
}
function mkTCLradio(inobj, outobj) {
    outobj.value = '';
    for ( var opt = 0 ; opt < inobj.length ; opt++ ) {
        if (inobj[opt].checked) {
            outobj.value +=' {'+inobj[opt].value+'}';
        }
    }
}
function getRadioSelected(radioGroup) {
    for (var i=0; i<radioGroup.length; i++) {
        if (radioGroup[i].checked) {
            return radioGroup[i].value
        }
    }
}
function newOrUpdate(sendform, selected) {
    if (document.getElementById("ajxlod")) {
        document.getElementById('ajxlod').style.visibility = "visible";
    }
    if ( selected == "" ) {
        sendform.caller.value = "new"
        sendform.submit();
    } else {
        sendform.caller.value = "update"
        sendform.submit();
    }
}
function updateOK(sendform, resForm, updateOK) {
    if ( updateOK == "true" ) {
        sendform.submit();
        setTimeout('top.close(this)',50)
    } else {
        resForm.uButton.disabled = false
    }
}
//#############################################################################
// window functions
//#############################################################################
function openWindow(elementType, elementurl) {
    if ( client[elementType] && client[elementType].open ) {
        win = window.open("", client[elementType].open.target, client[elementType].open.wsize);
        win.focus();
        winOpenClose(win);
        document.hammerForm.elementType.value = elementType;
        document.hammerForm.elementCall.value = "open";
        document.hammerForm.elementurl.value  = elementurl;
        document.hammerForm.target            = client[elementType].open.target;
        document.hammerForm.submit();
    } else {
        alert(top.opener.document.msgForm.jsmsg10.value + ': ' +elementType)
    }
}
function newElement(eButton) {
    popupHide()
    elementType = document.hammerForm.elementType.value
    if ( client[elementType] && client[elementType].create ) {
        win = window.open("", client[elementType].create.target, client[elementType].create.wsize);
        win.focus();
        winOpenClose(win);
        document.hammerForm.elementCall.value = "create";
        document.hammerForm.elementurl.value  = "";
        document.hammerForm.selected.value    = "";
        document.hammerForm.target            = client[elementType].create.target;
        document.hammerForm.submit();
    } else {
        elementWindow = window.open(eButton.id,"newelementframe","height=160,width=420,scrollbars=no,resizable");
        elementWindow.focus();
    }
}
function newElement1(elementType, application) {
    popupHide()
    win = window.open("", client[elementType][application].target, client[elementType][application].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value = elementType;
    document.hammerForm.elementCall.value = application;
    document.hammerForm.elementurl.value  = "";
    document.hammerForm.selected.value    = "";
    document.hammerForm.target            = client[elementType][application].target;
    document.hammerForm.submit();
}
function deleteElement(eButton) {
    popupHide()
    getCheckedElements(eButton)
    if ( checkForSingle() == 0 ) return
    if ( client[elementType] && client[elementType].remove ) {
        win = window.open("", client[elementType].remove.target, client[elementType].remove.wsize);
        win.focus();
        winOpenClose(win);
        document.hammerForm.elementType.value = elementType;
        document.hammerForm.elementCall.value = "remove";
        document.hammerForm.elementurl.value  = elementurl;
        document.hammerForm.target            = client[elementType].remove.target;
        document.hammerForm.submit();
    } else {
        if ( confirm(top.opener.document.msgForm.jsmsg16.value) ) {
            document.filelist.caller.value = "deleteElement";
            document.filelist.elementurl.value = elementurl;
            document.filelist.submit();
        }
    }
}
function versionElement(eButton) {
    popupHide()
    getCheckedElements()
    if ( checkForSingle() == 0 ) return
    win = window.open("","versionElementFrame","height=300,width=980,scrollbars=auto,resizable,status");
    win.focus();
    winOpenClose(win);
    document.versionElementForm.elementurl.value = elementurl;
    document.versionElementForm.submit();
}
function basketWindow(eButton) {
    popupHide()
    basketFrame = window.open("","basketFrame","height=400,width=900,scrollbars=auto,resizable");
    basketFrame.focus();
    winOpenClose(basketFrame);
    document.basketForm.action = eButton.id;
    document.basketForm.submit();
}
function searchWindow(eButton) {
    popupHide()
    searchFrame = window.open("","searchFrame","height=450,width=980,scrollbars=auto,resizable,status");
    searchFrame.focus();
    winOpenClose(searchFrame);
    document.searchForm.submit();
}
function filePicker(eButton) {
    //popupHide()
    pickerFrame = window.open("","pickerFrame","height=500,width=650,scrollbars=auto,resizable,status");
    pickerFrame.focus();
    winOpenClose(pickerFrame);
    document.pickerForm.submit();
}
function jobMonitor(eButton) {
    popupHide()
    jobMonitorFrame = window.open("","jobMonitorFrame","height=550,width=950,scrollbars=auto,resizable");
    jobMonitorFrame.focus();
    winOpenClose(jobMonitorFrame);
    document.jobMonitorForm.submit();
}
function aboutPresSTORE(eButton) {
    popupHide()
    aboutFrame = window.open("","aboutFrame","height=300,width=400,scrollbars=no,resizable");
    aboutFrame.focus();
    winOpenClose(aboutFrame);
    document.windowForm.target = 'aboutFrame';
    document.windowForm.action = eButton.id;
    document.windowForm.submit();
}
function queryLog(eButton) {
    popupHide()
    queryLogFrame = window.open("","queryLogFrame","height=670,width=950,scrollbars=no,resizable,status");
    queryLogFrame.focus();
    winOpenClose(queryLogFrame);
    document.windowForm.target = 'queryLogFrame';
    document.windowForm.action = eButton.id;
    document.windowForm.submit();
}
function resourceProc(aktion) {
    popupHide()
    getCheckedElements()
    if ( checkForSingle() == 0 ) return
    if ( !client[elementType] ) {
        alert(top.opener.document.msgForm.jsmsg11.value)
        return
    }
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value  = elementType;
    document.hammerForm.elementCall.value  = aktion;
    document.hammerForm.elementurl.value   = elementurl;
    document.hammerForm.target             = client[elementType][aktion].target;
    document.hammerForm.submit();
}
function newWindowZ(action,elementType,aktion) {
    popupHide()
    getCheckedElements()
    if ( numberElements == 0 ) {
        alert(top.opener.document.msgForm.jsmsg1.value)
        return 0
    }
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.windowForm.action = action;
    document.windowForm.elementCall.value  = aktion;
    document.windowForm.target = client[elementType][aktion].target;
    document.windowForm.elementurl.value = selecedElements;
    document.windowForm.submit();

}
function newWindow(eButton,elementType,aktion) {
    popupHide()
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.windowForm.action = eButton.id;
    document.windowForm.target = client[elementType][aktion].target;
    document.windowForm.submit();
}
function newResourceProc(elementType,aktion) {
    popupHide()
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value  = elementType;
    document.hammerForm.elementCall.value  = aktion;
    document.hammerForm.elementurl.value   = "";
    document.hammerForm.target             = client[elementType][aktion].target;
    document.hammerForm.submit();
}
function commonProc(elementType,aktion) {
    popupHide()
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value  = elementType;
    document.hammerForm.elementCall.value  = aktion;
    document.hammerForm.target             = client[elementType][aktion].target;
    document.hammerForm.submit();
}
function openRefRsrc(rsrc,elementType,action) {
    win = window.open("", client[elementType][action].target, client[elementType][action].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.target = client[elementType][action].target;
    document.hammerForm.selected.value = rsrc
    document.hammerForm.elementCall.value = action
    document.hammerForm.elementType.value = elementType
    document.hammerForm.submit();
}
function winOpenClose(win) {
    win.document.open();
    win.document.close();
}
function searchSwitch() {
    document.filelist.searchFlag.value = !eval(document.filelist.searchFlag.value)
    waitBox('2');
    document.filelist.caller.value = "searchFlag";
    document.filelist.submit();
}
function doSearch() {
    waitBox('2');
    document.filelist.caller.value = "newSearch";
    document.filelist.submit();
}
function showPreview(eButton,xsize,ysize) {
    var ysize = parseInt(ysize) + 25
    var xsize = parseInt(xsize) + 25
    var imgid = eButton.id
    var wp = 'height='+ysize+',width='+xsize+',scrollbars=yes,resizable,status';
    var clipW = window.open(imgid,'previewWindow',wp);
    clipW.resizeTo(xsize,ysize)
    clipW.focus();
}
function reloadWS() {
    if ( top.opener ) {
        if ( top.opener.parent.frames[2] && top.opener.parent.frames[2].document.resourceForm ) {
            top.opener.parent.frames[2].document.getElementById('ajxlod').style.visibility = "visible";
            top.opener.parent.frames[2].document.resourceForm.submit()
        } else if ( top.opener.reload2WS ) {
            top.opener.reload2WS();
        }
    }
}
function reload2WS() {
    if ( parent.frames[2] ) {
        waitBox('2');
        if ( parent.frames[2].document.filelist && parent.frames[2].document.filelist.content.value == 'filelist' ) {
            parent.frames[2].document.filelist.caller.value = 'reload'
            parent.frames[2].document.filelist.submit()
        } else if ( parent.frames[2].document.filelist && parent.frames[2].document.filelist.content.value == 'volumelist' ) {
            parent.frames[2].document.volumenlist.submit()
        } else if ( parent.frames[2].document.localForm && parent.frames[2].document.localForm.server.value != '' ) {
            document.notifyForm.submit();
        }
    }
}
function addSelect(element,wert) {
    if ( typeof(element) != 'object' ) {
        var element  = document.getElementById(element)
    }
    var newdir   = document.createElement('OPTION')
    newdir.text  = wert   
    newdir.value = wert
    if ( ie5 ) {
        element.add(newdir);
    } else {
        element.add(newdir,null);
    }
}
//# logout
function logoutSession() {
    parent.frames[0].document.logoutForm.submit();
}
//# set/unset autologin cookie
function cookieFlag(eButton) {
    if ( eButton.checked ) {
        createCookie('autologin',loginUser,loginDays)
        if ( readCookie('autologin') == null ) {
            alert(document.msgForm.jsmsg3.value)
        }
    } else {
        eraseCookie('autologin')
    }
}
//# create a cookie
function createCookie(name,value,days) {
    if (days)
    {
        var date = new Date();
        date.setTime(date.getTime()+(days*24*60*60*1000));
        var expires = "; expires="+date.toGMTString();
    }
    else var expires = "";
    document.cookie = name+"="+value+expires+"; path=/";
}
//# read a cookie
function readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++)
    {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}
//# delete a cookie
function eraseCookie(name) {
    createCookie(name,"",-1);
}
//# open the docu frame   
function onlineDocuFrame(eButton) {
    popupHide()
    docuSpace = window.open(eButton,"DocumentationBrowser","height=700,width=1024,scrollbars=yes,resizable,status");
    docuSpace.focus();
}
//# open the docu frame   
function openArchiware(eButton) {
    popupHide()
    archSpace = window.open(eButton,"ArchiwareBrowser","height=700,width=1024,scrollbars=yes,resizable,status,toolbar,location");
    archSpace.focus();
}
//# get the position from element 
function getPos(obj) {
    var curleft = curtop = 0;
    if (obj.offsetParent) {
        curleft = obj.offsetLeft
        curtop = obj.offsetTop
        while (obj = obj.offsetParent) {
            curleft += obj.offsetLeft
            curtop += obj.offsetTop
        }
    }
    return [curleft,curtop];
}
//# replace from browser_filelist.tdp 
function supportInfo(evt) {
    popupHide()
    if ( evt.shiftKey ) {
        document.downloadSupport.caller.value = "supportInfoAll";
    } else {
        document.downloadSupport.caller.value = "supportInfo";
    }
    document.downloadSupport.submit();
}
function winStatus() {
    window.status = document.msgForm.jsmsg2.value + document.hammerForm.parenturl.value + document.msgForm.jsmsg3.value;
}
function setShnapShot(eButton) {
    popupHide()
    document.filelist.caller.value = "setShnapShot";
    document.filelist.snapshot.value = eButton.id;
    document.filelist.submit();
}                
// restore selection
function selectSelection(eButton) {
    if ( lastSelection ) {
        lastSelection.style.backgroundColor = elementBgcolor;
    } 
    elementBgcolor = eButton.style.backgroundColor;
    eButton.style.backgroundColor = rowMarkColor;
    lastSelection = eButton
}
function UselectSelection() {
    if ( lastSelection ) {
        lastSelection.style.backgroundColor = elementBgcolor;
    } 
}
function outBasket(basket) {
    popupHide()
    if ( !lastSelection ) return;
    waitBox('2');
    document.filelist.caller.value = "outBasket";
    document.filelist.basket.value = basket;
    document.filelist.selectedelements.value = lastSelection.id;
    document.filelist.submit();
}
function emptyBasket(basket) {
    popupHide()
    waitBox('2');
    document.filelist.caller.value = "emptyBasket";
    document.filelist.basket.value = basket;
    document.filelist.submit();
}
function doSelection(eButton,elementType,aktion) {
    popupHide()
    win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.windowForm.action = eButton.id;
    document.windowForm.elementCall.value  = aktion;
    document.windowForm.target = client[elementType][aktion].target;
    document.windowForm.submit();
}
function isRightClick(e) {
    var rightclick;
    if (!e) var e = window.event;
    if (e.which) rightclick = (e.which == 3);
    else if (e.button) rightclick = (e.button == 2);
    //alert('Rightclick: ' + rightclick); // true or false
    return rightclick;
}
function lockGUI(msg) {
    if (document.getElementById("ajxlod")) {
        if (typeof(msg) !== 'undefined' && msg != null) {
            document.getElementById("lockmsg").innerHTML = msg;
        }
        $('#loaico').css({top:'50%',left:'50%',margin:'-'+($('#loaico').height() / 2)+'px 0 0 -'+($('#loaico').width() / 2)+'px'});
        document.getElementById("ajxlod").style.visibility = "visible";
    }
}
function initCal(datefield) {
    $( datefield ).datepicker({
        dateFormat: "dd-M-yy"
    });
    $('#calimg').click(function() {
        $( datefield ).datepicker('show');
    });
}
function initCal1(datefield,format) {
    $( datefield ).datepicker({
        dateFormat: format
    });
    $('#calimg').click(function() {
        $( datefield ).datepicker('show');
    });
}
function initCal2(datefield,format) {
    $( datefield ).datepicker({
        dateFormat: format
    });
    $('#calimg2').click(function() {
        $( datefield ).datepicker('show');
    });
}
function convertTo(str) {
    if ( str == "true" ) {
        return true;
    } else if ( str == "false" ) {
        return false;
    } else if ( !isNaN(str) ) {
        return parseInt(str);
    } else {
        return str;
    }
};
(function () {
    if (!window.$$) {
        window.$$ = function(){
            var tran = [];
            var arg = arguments;
            var msg = arg[0];
            
            var idx = 0;
            var reg = /\%s/;
            var parts = [];
            
            // try to find translation
            if(typeof AWLOC !== 'undefined') {
                var translation = AWLOC[msg];
                var msg = (translation) ? translation : msg
            };
            
            //analyze the string, extract the parts with the %s identifier.
            for ( var m = reg.exec(msg); m; m = reg.exec(msg) ) {        
                parts.push(msg.substr(0, m[0][0] == "%" ? m.index : m.index));
                parts.push("%s");
                msg = msg.substr(m.index+m[0].length);
            }
            
            parts.push(msg);
                        
            //analyze the parts, replace the %s with the given arguments. beware of undefined!
            for (var i = 0; i < parts.length; ++i){
                var part = parts[i];
                
                if (part && part === "%s") {
                    var object = arg[++idx];
                
                    if (object === undefined) {
                        tran.push("%s");
                    } else {
                        tran.push(object);
                    };
                } else {
                    tran.push(part);
                };            
            };
            return tran.join('');
        };
    };
})();
function dblClickRes(res) {
    openRes(res)
}
function openRes(res) {
    var restype = document.hammerForm.elementType.value;
    selecedElements = [];
    selecedElements.push(res);
    if ( client[restype] && client[restype].open ) {
        win = window.open("", client[restype].open.target, client[restype].open.wsize);
        win.focus();
        winOpenClose(win);
        document.hammerForm.elementCall.value = "open";
        document.hammerForm.selected.value    = Ext.encode(selecedElements);
        document.hammerForm.target            = client[restype].open.target;
        document.hammerForm.submit();
    } else {
        alert(top.opener.document.msgForm.jsmsg10.value + ': ' +restype)
    }
}
function getSelctedResources() {
    numberElements  = 0
    selecedType     = document.hammerForm.elementType.value;
    selecedElements = [];
    var thisGrid    = tabPanel.getActiveTab().getComponent(0);
    var selection   = thisGrid.getSelectionModel().getSelection();
    Ext.iterate(selection, function(obj, index) {
        var elm = obj.get('name');
        selecedElements.push(elm);
        numberElements++
    });
}
function resProc3m(aktion) {
    popupHide()
    getSelctedResources();
    if ( checkForMulti() == 0 ) return
    if ( !client[selecedType] ) {
        alert(top.opener.document.msgForm.jsmsg11.value)
        return
    }
    win = window.open("", client[selecedType][aktion].target, client[selecedType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value  = selecedType;
    document.hammerForm.elementCall.value  = aktion;
    document.hammerForm.selected.value     = Ext.encode(selecedElements);
    document.hammerForm.target             = client[selecedType][aktion].target;
    document.hammerForm.submit();
}
function resProc3(aktion) {
    popupHide();
    getSelctedResources();
    if ( checkForSingle() == 0 ) return
    if ( !client[selecedType] ) {
        alert(top.opener.document.msgForm.jsmsg11.value)
        return
    }
    win = window.open("", client[selecedType][aktion].target, client[selecedType][aktion].wsize);
    win.focus();
    winOpenClose(win);
    document.hammerForm.elementType.value  = selecedType;
    document.hammerForm.elementCall.value  = aktion;
    document.hammerForm.selected.value     = Ext.encode(selecedElements);
    document.hammerForm.target             = client[selecedType][aktion].target;
    document.hammerForm.submit();
}
function reloadWS3() {
    if ( top.opener ) {
        if ( top.opener.tabPanel && typeof top.opener.reloadStore === "function" ) {
            top.opener.reloadStore();
        }
    }
}
versionCompare = function(left, right) {
    if (typeof left + typeof right != 'stringstring')
        return false;
    
    var a = left.split('.')
    ,   b = right.split('.')
    ,   i = 0, len = Math.max(a.length, b.length);
        
    for (; i < len; i++) {
        if ((a[i] && !b[i] && parseInt(a[i]) > 0) || (parseInt(a[i]) > parseInt(b[i]))) {
            return 1;
        } else if ((b[i] && !a[i] && parseInt(b[i]) > 0) || (parseInt(a[i]) < parseInt(b[i]))) {
            return -1;
        }
    }
    
    return 0;
}
function moreDetails(elm) {
    if ($(elm).hasClass('is-hidden')) {
        $(elm).removeClass('is-hidden');
    } else {
        $(elm).addClass('is-hidden');
    }
};