Ext.define('P5Index.view.SelectionWindow', {
    extend: 'Ext.window.Window',
    xtype: 'mvvm-selectionwindow',
    
    requires: [
        'P5Index.view.SelectionWindowController',
        'P5Index.view.SelectionWindowViewModel',
        'P5Index.view.SelectionGrid',
    ],
    
    controller: 'selectionwindow',
    viewModel: {
        type: 'selectionwindow'
    },
    
    id: 'basketswindow_id',  // Behalten der Original-ID für die Kompatibilität
    
    bind: {
        title: '{windowTitle}'
    },
    
    border: false,
    height: '70%',
    width: 350,
    layout: {
        type: 'vbox',
        pack: 'start',
        align: 'stretch'
    },
    closeAction: 'hide',
    constrain: true,
    
    items: [{
        xtype: 'toolbar',
        layout: 'hbox',
        margin: '0 0 0 0',
        items: [{
            xtype: 'combo',
            reference: 'basketListCombo',
            itemId: 'basketList_id', // ID aus dem alten Code für Kompatibilität
            width: 200,
            editable: false,
            bind: {
                store: '{basketListStore}'
            },
            queryMode: 'local',
            displayField: 'name',
            valueField: 'id',
            emptyText: $$('Saved selections') + '...',
            listConfig: {
                itemTpl: [
                    '<div style="white-space:nowrap;overflow:hidden;text-overflow:ellipsis;" data-qtip="{id}">{name}</div>'
                ]
            },
            listeners: {
                change: 'onBasketListSelection'
            }
        }, {
            xtype: 'button',
            iconCls: 'tbar-save',
            tooltip: $$('Add empty selection'),
            handler: 'onAddEmptySelection'
        }, {
            xtype: 'button',
            iconCls: 'tbar-rem',
            tooltip: $$('Delete selection'),
            handler: 'onDeleteSelection'
        }]
    }, {
        xtype: 'mvvm-selectiongrid',
        flex: 1
    }]
});