Ext.define('P5Index.view.PathImportWindow', {
    extend: 'Ext.window.Window',
    xtype: 'mvvm-pathimportwindow',
    
    requires: [
        'P5Index.view.PathImportWindowController',
        'P5Index.view.PathImportWindowViewModel',
        'P5Index.view.PathImportGrid',
        'P5Index.view.TroubleshootingHelp',
        'P5Index.view.ParserLogWindow',
        //'P5Index.util.ParserLogger',
        'P5Index.util.OptimizedMediaParser',
        'P5Index.util.MediaCustomerFilter',
        'P5Index.util.OTIOParser',
        'P5Index.util.TEXTParser',
        'P5Index.util.EDLParser',
        'P5Index.util.ALEParser',
        'P5Index.util.FCPXMLParser',
        'P5Index.util.XMEMLParser',
        'P5Index.util.TSVParser'
    ],
    
    controller: 'pathimportwindow',
    viewModel: {
        type: 'pathimportwindow'
    },

    id: 'pathimportwindow_id',
    
    title: $$('Media Recovery'),
    border: false,
    height: '70%',
    width: 800,
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    closeAction: 'hide',
    constrain: true,
    maximizable: true,
    
    items: [{
        xtype: 'toolbar',
        margin: '0 0 0 0',
        items: [{
            xtype: 'tbtext',
            text: $$('Search') + ':'
        }, {
            xtype: 'combobox',
            reference: 'searchModeCombo', 
            width: 140,
            editable: false,
            value: 'exact',
            displayField: 'text',
            valueField: 'value',
            store: {
                fields: ['value', 'text'],
                data: [
                    {value: 'auto', text: $$('Auto')},
                    {value: 'exact', text: $$('Exact')},
                    {value: 'wildcard', text: $$('Wildcard')}, 
                    {value: 'tokens', text: $$('Word parts')}
                ]
            }
        }, {
            xtype: 'tbtext',
            text: $$('Path Matching') + ':'
        }, {
            xtype: 'combobox',
            reference: 'pathMatchingCombo',
            width: 140,
            editable: false,
            value: 'parent',
            displayField: 'text',
            valueField: 'value',
            store: {
                fields: ['value', 'text'],
                data: [
                    {value: 'parent', text: $$('Parent folder')},
                    {value: 'relative', text: $$('Relative path')},
                    {value: 'ignore', text: $$('Ignore path')}
                ]
            }
        }, {
            xtype: 'button',
            tooltip: $$('Redo search'),
            iconCls: 'fa fa-redo',
            reference: 'searchBtn',
            disabled: true,
            handler: 'onSearchArchive'
        }, {
            xtype: 'button',
            tooltip: $$('Reset'),
            iconCls: 'fa fa-trash-alt',
            reference: 'resetBtn',
            disabled: true,
            handler: 'onResetImport'
        }, {
            xtype: 'tbfill'
        }, {
            xtype: 'button',
            tooltip: $$('Troubleshooting'),
            iconCls: 'fa fa-question-circle',
            reference: 'troubleshootingBtn',
            handler: 'onShowTroubleshootingHelp'
        }]
    }, {
        xtype: 'mvvm-pathimportgrid',
        flex: 1
    }],
    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        reference: 'statusToolbar',
        items: [{
            xtype: 'checkbox',
            boxLabel: $$('Log'),
            reference: 'enableLogging',
            checked: false,
            hidden: false,
            listeners: {
                change: 'onLoggingToggle',
                click: {
                    element: 'el',
                    fn: function(e) {
                        if (e.shiftKey) {
                            var controller = this.component.up('window').getController();
                            controller.onDebugModeToggle(this.component);
                        }
                    }
                }
            }
        }, {
            xtype: 'button',
            tooltip: $$('Show parsing and searching details'),
            iconCls: 'fa fa-info-circle',
            reference: 'showLogBtn',
            hidden: true,
            handler: 'onShowLogWindow'
        }, {
            xtype: 'tbseparator'
        }, {
            xtype: 'tbtext',
            reference: 'statusText',
            text: $$('Ready to analyze'),
            padding: '2 0 0 0'
        }, {
            xtype: 'tbfill'
        }, {
            xtype: 'button',
            text: $$('Restore'),
            reference: 'addSelectedBtn',
            disabled: true,
            handler: 'onAddSelectedItems'
        }]
    }],
    
    listeners: {
        afterrender: 'setupWindowDropZone'
    }
});