Ext.define('P5Jobmanager.controller.Main', {
    extend: 'Ext.app.Controller',

    refs: {
        previewPane: 'panel#previewPane',
        mainRegion: 'panel#mainRegion',
        previewButton: 'splitbutton#previewButton'
    },

    init: function(application) {
        this.control({
            "menuitem[opt]": {
                click: this.setPreviewRegion
            }
        });
    },

    setPreviewRegion: function(item) {
        var me = this,
            mainRegion = me.getMainRegion(),
            previewPane = me.getPreviewPane(),
            previewButton = me.getPreviewButton(),
            previewText = 'Preview: ' + item.text;

        //evalute the items custom "opt" property to dictate
        //the preview pane view state.
        if (item.opt !== 'hide') {
            if (previewPane.isHidden()) {
        		previewPane.show();
            }
            //remove the preview pane from the main region
            //without destroying it
            mainRegion.remove(previewPane, false);
            //assign the new region to the preview pane
            previewPane.region = item.opt;
            //add the preview pane back to the main region
            mainRegion.add(previewPane);
        } else {
            if (!previewPane.isHidden()) {
        		previewPane.hide();
            }
        }

        previewButton.setText(previewText);
    }

});
