Ext.define('Dashboard.view.widget.InstallationInfo', {
    extend: 'Ext.container.Container',
    xtype: 'installation-info-widget',
    
    requires: [
        'Dashboard.view.widget.InstallationInfoModel',
        'Dashboard.view.widget.InstallationInfoController'
    ],
    
    controller: 'installation-info',
    viewModel: {
        type: 'installation-info'
    },
    
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    
    style: {
        paddingTop: '2px',
        backgroundColor: '#ffffff'
    },
    
    items: [{/*
        // Logo-Header mit Grid-ähnlichem Layout
        xtype: 'container',
        layout: {
            type: 'hbox',
            align: 'middle'
        },
        margin: '0 0 0 0',
        height: 70,
        items: [{
            // P5 Logo in "linker Spalte"
            xtype: 'component',
            reference: 'p5logo_ref',
            maxWidth: 200,
            minWidth: 130,
            flex: 1,
            style: {
                textAlign: 'right',  // Rechts aligniert wie die anderen Labels
                paddingRight: '5px'
            },
            listeners: {
                element: 'el',
                click: 'activateDemoMode'
            },
            html: '<div class="p5_256"></div>'
        }, {
            // ARCHIWARE Logo in "rechter Spalte"
            xtype: 'component',
            flex: 2,
            style: {
                paddingLeft: '6px'
            },
            html: '<div class="archiware_logo"></div>'
        }]
    }, {*/
        // Informations-Grid
        xtype: 'grid',
        flex: 1,
        border: false,
        hideHeaders: true,
        disableSelection: true,
        bind: {
            store: '{installInfoFiltered}'
        },
        bodyStyle: {
            border: 'none',
            backgroundColor: 'transparent'
        },
        columns: [{
            dataIndex: 'text',
            align: 'right',
            flex: 1,
            maxWidth: 200,
            minWidth: 130
        }, {
            dataIndex: 'value',
            flex: 2,
            renderer: 'valueRenderer'     
        }]
    }]
});