//#############################################################################
//
//  filterlib.js
//
//    JavaSribt Filter Library
//
//    See the file "license.txt" for information on usage and
//    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
//    Rcsid: @(#)$Id: filterlib.js,v 1.5 2015/03/06 11:36:32 jd Exp $
//
//#############################################################################

//# Validates new filter expressions and blocks problematic combinations
function validateNewFilterExpression(filterString) {
    // Check if the filter expression contains -type directory
    var isDirectoryType = /-type\s+directory/.test(filterString);
    
    if (isDirectoryType) {
        // Check if -name is present (required for directory type)
        var hasNamePattern = /-name\s+'[^']*'/.test(filterString);
        
        // Check for forbidden options with directory type
        var hasMdate = /-mdate\s+[^\s-]+/.test(filterString);
        var hasSize = /-size\s+[^\s-]+/.test(filterString);
        
        // For -type directory, -name is required and -mdate/-size are forbidden
        if (!hasNamePattern) {
            return {
                isValid: false,
                errorMessage: "When selecting the 'File type' directory, the 'File name' option is required."
            };
        }
        
        if (hasMdate || hasSize) {
            return {
                isValid: false,
                errorMessage: "When selecting the 'File type' directory, the 'Modification date' and 'Size' options are not possible."
            };
        }
    }
    
    return { isValid: true };
}
//# add a filter to the list
function addExpr(eButton) {
    FromObj = eval('document.resourceForm.' + eButton);
    var fstring = getPattern();
    if (fstring == "") return;
    
    // New validation only for new expressions
    var validationResult = validateNewFilterExpression(fstring);
    if (!validationResult.isValid) {
        alert(validationResult.errorMessage);
        return;
    }
    
    //# check if expression is already defined
    for (var opt = 0; opt < FromObj.options.length; opt++) {
        if (fstring == FromObj.options[opt].value) return;
    }
    
    addSelect(FromObj, fstring);
}//# get pattern flag and parameter
function getPattern() {
    var pstr = document.resourceForm.pattern1.value
    //# parse pattern string
    var reg = /\{|\}|\|/ ;
    if ( reg.exec(pstr) ) {
        alert(document.msgForm.jsmsg1.value)
        return ""
    }
    var reg = /\// ;
    if ( document.resourceForm.fileType.value != 'path' && reg.exec(pstr) ) {
        alert(document.msgForm.jsmsg2.value)
        return ""
    }
    var qt = "\'"
    var wc = "*"
    var eq = "="
    var gr = ">"
    var sm = "<"
    var fstring = ''
    //# create expression
    //# 1. file name
    if ( pstr != '' ) {
        if        (document.resourceForm.patternRule.value == 0 ) {
            var fstring = fstring + "-name "+qt+pstr+qt
        } else if (document.resourceForm.patternRule.value == 1 ) {
            var fstring = fstring + "-name "+qt+wc+pstr+qt
        } else if (document.resourceForm.patternRule.value == 2 ) {
            var fstring = fstring + "-name "+qt+pstr+wc+qt
        } else if (document.resourceForm.patternRule.value == 3 ) {
            var fstring = fstring + "-name "+qt+wc+pstr+wc+qt
        } else {
            alert(document.msgForm.jsmsg10.value)
            return ""
        }
    }
    //# 2. file type
    if ( document.resourceForm.fileType.value != '' ) {
        var fstring = fstring+" -type "+document.resourceForm.fileType.value
    }
    //# 3. modification date
    var mdat = document.resourceForm.mdate.value
    if ( mdat != '' ) {
        var mrul = document.resourceForm.mdateRule.value
        if ( mrul == eq || mrul == gr || mrul == sm ) {
            var mdat = vdateAbsolut(mdat)
            if ( mdat != '' ) {
                var fstring = fstring+" -mdate "+mrul+mdat
            }
        } else if ( mrul == '+' || mrul == '-' ) {
            var mdat = vdateRelativ(mdat)
            if ( mdat != '' ) {
                var fstring = fstring+" -mdate "+mrul+mdat
            }
        } else if ( mrul == '' ) {
            alert(document.msgForm.jsmsg8.value)
            return ""
        }
    }
    //# 4. file size
    var fsiz = document.resourceForm.filesize.value
    if ( fsiz != '' ) {
        var srul = document.resourceForm.sizeRule.value
        if ( srul == gr || srul == sm ) {
            var fsiz = vdateRelativ(fsiz)
            if ( fsiz != '' ) {
                var fstring = fstring+" -size "+srul+fsiz
            }
        } else if ( srul == '' ) {
            alert(document.msgForm.jsmsg9.value)
            return ""
        }
    }
    
    return fstring
}
//# remove a filter from a list
function rmExpr(eButton) {
    FromObj = eval('document.resourceForm.' + eButton);
    if ( FromObj.selectedIndex < 0 ) return
    var opt = FromObj.selectedIndex
    FromObj.remove(opt)
}
//# select the the filter
function selectdir(eButton) {
    FromObj = eval('document.resourceForm.' + eButton);
    if ( FromObj.selectedIndex < 0 ) return
    if ( lastExpr != FromObj ) {
        if ( lastExpr && (lastExpr.selectedIndex >= 0 ) && lastExpr.options[lastExpr.selectedIndex]) {
            lastExpr.options[lastExpr.selectedIndex].selected = false
        }
    }
    lastExpr = FromObj
    getExprName(FromObj.options[FromObj.selectedIndex].text)
    getExprType(FromObj.options[FromObj.selectedIndex].text)
    getExprMdat(FromObj.options[FromObj.selectedIndex].text)
    getExprFsiz(FromObj.options[FromObj.selectedIndex].text)
}
//# set file name
function getExprName(findString) {
    var regName = /-name\s\'((?:\\.|[^"\\])*)\'/;
    var regWcA  = /^[*]+(.*)/;
    var regWcE  = /(.*[^*])[*]+$/;
    var regWcAE = /^[*]+(.*[^*])[*]+$/;
    var result  = regName.exec(findString)
    if ( result != null ) {
        var resultWcA  = regWcA.exec(result[1])
        var resultWcE  = regWcE.exec(result[1])
        var resultWcAE = regWcAE.exec(result[1])
        if        ( resultWcAE != null ) {
           document.resourceForm.pattern1.value = resultWcAE[1]
           document.resourceForm.patternRule.options[4].selected = true
        } else if ( resultWcE != null ) {
           document.resourceForm.pattern1.value = resultWcE[1]
           document.resourceForm.patternRule.options[3].selected = true
        } else if ( resultWcA != null ) {
           document.resourceForm.pattern1.value = resultWcA[1]
           document.resourceForm.patternRule.options[2].selected = true
        } else {
           document.resourceForm.pattern1.value = result[1]
           document.resourceForm.patternRule.options[1].selected = true
        }
    } else {
        document.resourceForm.patternRule.options[0].selected = true
        document.resourceForm.pattern1.value = ""
    }
}
//# set file type
function getExprType(findString) {
    var regType = /-type\s([^\s]*)/;
    var result  = regType.exec(findString)
    if ( result != null ) {
        for ( var opt = 0 ; opt <document.resourceForm.fileType.options.length ; opt++ ) {
            if (document.resourceForm.fileType.options[opt].value == result[1] ) {
               document.resourceForm.fileType.options[opt].selected = true
            }  
        }
    } else {
        document.resourceForm.fileType.options[0].selected = true
    }
}
//# set modufication date 
function getExprMdat(findString) {
    var regName = /-mdate\s(\+|\-|=|<|>)([^\s]*)/;
    var result  = regName.exec(findString)
    if ( result != null ) {
        document.resourceForm.mdate.value = result[2]
        for ( var opt = 0 ; opt <document.resourceForm.mdateRule.options.length ; opt++ ) {
            if (document.resourceForm.mdateRule.options[opt].value == result[1] ) {
               document.resourceForm.mdateRule.options[opt].selected = true
            }  
        }
    } else {
        document.resourceForm.mdateRule.options[0].selected = true
        document.resourceForm.mdate.value = ""
    }
}
//# set file size 
function getExprFsiz(findString) {
    var regName = /-size\s(<|>)([^\s]*)/;
    var result  = regName.exec(findString)
    if ( result != null ) {
        document.resourceForm.filesize.value = result[2]
        for ( var opt = 0 ; opt <document.resourceForm.sizeRule.options.length ; opt++ ) {
            if (document.resourceForm.sizeRule.options[opt].value == result[1] ) {
               document.resourceForm.sizeRule.options[opt].selected = true
            }  
        }
    } else {
        document.resourceForm.sizeRule.options[0].selected = true
        document.resourceForm.filesize.value = ""
    }
}
//###### date validation  ######
function vdateAbsolut(checkDate) {
    var objRegExp  = /^(\d{1,2})(\/|\.|\-|\:|\ )(\d{1,2})(\/|\.|\-|\:|\ )(\d{4})$/;
    var resultDATE = objRegExp.exec(checkDate)
    if ( resultDATE == null ) {
        alert(document.msgForm.jsmsg4.value)
        return ""
    }
    var maxDay = 0;
    var aa = resultDATE[0]
    if ( resultDATE[2] == '/' ) {
        var dd = resultDATE[3]; // day
        var mm = resultDATE[1]; // month
        var yy = resultDATE[5]; // year
    } else {
        var dd = resultDATE[1]; // day
        var mm = resultDATE[3]; // month
        var yy = resultDATE[5]; // year
    }
    // calling function to get maximum day for this month
    maxDay = max_day(mm, yy);  
    if((dd <= 0) || (dd > maxDay) || (mm <= 0) || (mm > 12) || (yy <= 1970) ) {
        alert(document.msgForm.jsmsg5.value)
        return ""
    }
    return mm+'/'+dd+'/'+yy
}
function vdateRelativ(checkDate) {
    var objRegExp  = /^(\d+)$/;
    var resultDATE = objRegExp.exec(checkDate)
    if ( resultDATE == null ) {
        alert(document.msgForm.jsmsg6.value)
        return ""
    }
    return resultDATE[1]
}
//# function for calculating maximum day 
function max_day(mn, yr) {
    var mDay;
    if((mn == 4) || (mn == 6) || (mn == 9) || (mn == 11)) { 
        mDay = 30;
    } else if(mn == 2) {
        //calling leap year function 
        mDay = isLeapYear(yr) ? 29 : 28;    
    } else {
        mDay = 31;
    }
    return mDay; 
}
//# function to check leap year
function isLeapYear(yr) {
    if      (yr % 4 != 0)   return false;
    else if (yr % 400 == 0) return true;
    else if (yr % 100 == 0) return false;
    else                    return true;
}
//###### end of date validation  ######
