Ext.define('P5Index.view.ParserLogWindow', {
    extend: 'Ext.window.Window',
    xtype: 'parserlogwindow',
    
    requires: [
        'P5Index.view.ParserLogWindowController',
        'P5Index.util.ParserLogger'
    ],
    
    controller: 'parserlogwindow',
    
    title: $$('Parsing and Searching Details'),
    width: 800,
    height: 600,
    layout: 'border',
    maximizable: true,
    modal: true,
    resizable: true,
    closeAction: 'hide',
    border: false,

    items: [{
        region: 'north',
        height: 250,
        split: true,
        xtype: 'panel',
        bodyStyle: 'border-width: 0px 0px 0px 0px;',
        title: $$('Client Parsing Log'),
        border: false,
        layout: 'fit',
        collapsible: true,
        items: [{
            xtype: 'textarea',
            margin: '0 0 0 0',
            bodyStyle: 'border-width: 0px 0px 0px 0px;',
            reference: 'clientLogArea',
            readOnly: true,
            style: {
                fontFamily: 'monospace',
                fontSize: '12px',
                backgroundColor: '#f4f4f4'
            }
        }]
    }, {
        region: 'center',
        xtype: 'grid',
        border: false,
        margin: '0 0 0 0',
        bodyStyle: 'border-width: 1px 1px 0px 1px;',
        viewConfig: {
            stripeRows: false,
            trackOver: false,
            markDirty: false
        },
        reference: 'serverLogGrid',
        title: $$('Server Search Logs'),
        bind: {
            store: '{pathProjectStore}'  // Direkt gebunden!
        },
        columns: [{
            text: $$('File'),
            dataIndex: 'fileName',
            width: 200
        }, {
            text: $$('Found'),
            dataIndex: 'foundVersionCount',
            width: 60,
            align: 'center',
            renderer: function(value) {
                var color = value > 0 ? 'green' : 'red';
                return '<span style="color:' + color + ';">' + value + '</span>';
            }
        }, {
            text: $$('Search Mode'),
            dataIndex: 'searchMode',
            width: 100
        }, {
            text: $$('Path Matching'),
            dataIndex: 'pathMatching', 
            width: 100,
            renderer: function(value) {
                // Optional: Bessere Anzeige
                switch(value) {
                    case 'parent': return 'Parent Folder';
                    case 'relative': return 'Relative Path';
                    case 'ignore': return 'Ignored';
                    default: return value;
                }
            }
        }, {
            text: $$('Query'),
            dataIndex: 'searchQuery',
            flex: 1,
            renderer: function(value) {
                return '<code>' + Ext.String.htmlEncode(value) + '</code>';
            }
        }, {
            xtype: 'actioncolumn',
            width: 50,
            align: 'center',
            items: [{
                iconCls: 'fa fa-external-link-alt',
                tooltip: $$('View full log'),
                handler: 'onViewServerLog'
            }]
        }]
    }],
    
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            text: $$('Export Logs'),
            iconCls: 'fa fa-download',
            handler: 'onExportLogs'
        }, '->', {
            text: $$('Close'),
            handler: 'onClose'
        }]
    }],
    // Optional: Singleton pattern für bessere Performance
    statics: {
        show: function() {
            if (!this.instance) {
                this.instance = Ext.create('P5Index.view.ParserLogWindow');
            }
            this.instance.show();
            return this.instance;
        }
    }
});