Ext.define('P5Index.util.ParserLogger', {
    singleton: true,
    
    logBuffer: [],
    isLogging: false,
    
    startLogging: function() {
        this.logBuffer = [];
        this.isLogging = true;
        // KEIN console.log Override!
    },
    
    stopLogging: function() {
        this.isLogging = false;
    },
    
    addLog: function(message, level) {
        if (!this.isLogging) return;
        
        // Level normalisieren
        level = level || 'NOTICE';
        if (level === 'ERROR') level = 'ERROR';
        else if (level === 'WARNING') level = 'WARNING';
        else level = 'NOTICE';
        
        this.logBuffer.push({
            timestamp: new Date(),
            level: level,
            message: message
        });
    },
    
    getFormattedLogs: function() {
        return this.logBuffer.map(function(entry) {
            var time = Ext.Date.format(entry.timestamp, 'd/M/Y:H:i:s');
            var level = Ext.String.leftPad(entry.level, 7);
            return '[' + time + '] [' + level + '] ' + entry.message;
        }).join('\n');
    },
    
    clearLogs: function() {
        this.logBuffer = [];
    }
});