console.log('Starting P5Jobhistory');

if( Ext.supports.LocalStorage ) {
    Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider());
} else {
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());
}

Ext.define('PanelOverride',{
    override:'Ext.panel.Panel',
 
       convertCollapseDir: function(collapseDir) {	
 
        if(typeof collapseDir == 'boolean'){
            collapseDir = this.collapseDirection
        }
        return collapseDir.substr(0, 1);	
    },
});

Ext.define("P5Jobhistory.Application", {
    extend: "Ext.app.Application",
    name: "P5Jobhistory",
    launch: function() {
        Ext.create('P5Jobhistory.view.MainView');

        console.log(Ext.Loader.getPath('P5Jobhistory'));
        console.log(Ext.Loader.getPath('P5Jobhistory.view.MainPanelViewModel'));
    }
});

Ext.onReady(function() {

    Ext.define('P5Jobhistory.globals',{
        singleton : true,
        attention: 0,
        serverpage: document.hammerForm.tdpswitch.value,
        stores: ["periodgrid", "resultgrid", "jobtypegrid", "clientgrid"]
    });

    Ext.scopeCss = true;
    Ext.application({
        name: "P5Jobhistory",
        extend: "P5Jobhistory.Application",
        appFolder: '/lexxapp/jobhistory'
    });

    Ext.Ajax.on('requestexception', function(con, resp, op, e) {
        if (resp && resp.status === 404) {
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Page not found!') );
            },200);
        } else if (resp && resp.status === 500) {
            P5Jobhistory.globals.attention = 1;
            // delay needed because of refreshing after loading will overwrite the Msg
            setTimeout(function(){
                Ext.Msg.show({
                    title:'Session Expired',
                    message: resp.responseText + '<br>' + resp.statusText,
                    buttons: Ext.Msg.YESNO,
                    buttonText:{ 
                        yes: "Login", 
                        no: 'Cancel' 
                    },
                    icon: Ext.Msg.WARNING,
                    fn: function(btn) {
                        if (btn === 'yes') {
                            console.log('Reloading');
                            window.location.href=window.location.href.split('#')[0]
                        }
                    }
                });
            },200);
        } else if (resp && resp.status === 0) {
            P5Jobhistory.globals.attention = 1;
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Server has aborted the connection'));
            },200);
        } else if (resp && resp.status !== undefined) {
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Server connection error: ') + resp.status );
            },200);
        } else {
            P5Jobhistory.globals.attention = 1;
            setTimeout(function(){
                Ext.Msg.alert('Error', 'Server error');
            },200);
        }
    });
	
});
// pre-defined date formats
Ext.Date.patterns = {
    formatDateTimeInt:"d-M-Y H:i",
    formatDateInt:"d-M-Y",
    ISO8601Long:"Y-m-d H:i:s",
    ISO8601Short:"Y-m-d",
    ISO8601ShortTime:"H:i",
    ShortDate: "n/j/Y",
    LongDate: "l, F d, Y",
    FullDateTime: "l, F d, Y g:i:s A",
    MonthDay: "F d",
    ShortTime: "g:i A",
    LongTime: "g:i:s A",
    SortableDateTime: "Y-m-d\\TH:i:s",
    UniversalSortableDateTime: "Y-m-d H:i:sO",
    YearMonth: "F, Y",
    formatDateTimeLongDe: "D d.M.Y H:i",
    formatDateTimeShortDe: "d.M.Y H:i",
    formatDateTimeDe: "d.m.y H:i",
    formatDateTimeLongUSA: "D M d, Y h:i a",
    formatDateTimeShortUSA: "d M Y h:i a",
    formatDateShortUSA: "d M Y",
    formatDateTimeUSA: "m/d/y h:i a",
    formatDateUSA: "m/d/y",
    formatTimeShort: "d.M H:i",
    formatTimeLong: "d.M H:i:s",
    formatDateTimeJa: "y/m/d h:i a"
};

Ext.Date.defaultFormat = Ext.Date.patterns['formatTimeShort'];

// general Ext message
function extAlert(attention,msg) {
	if ( attention == 1 ) {
		var icon = Ext.Msg['ERROR'];
		var text = $$('Error');
	} else if ( attention == 2 ) {
		var icon = Ext.Msg['WARNING'];
		var text = $$('Warning');
	} else if ( attention == 3 ) {
		var icon = Ext.Msg['INFO'];
		var text = $$('Note');
	} else {
		var icon = '';
	}
	// br required because of line cropping
	if ( attention > 0 ) {
		Ext.MessageBox.alert({
		   title: text, 
		   msg: msg+'<br>',
		   icon: icon,
		   minHeight: 150,
		   minWidth: 350,
		   buttons:  Ext.MessageBox.OK
		});
	}
}
// try to fetch values for page status and message
function testResponse(req, res) {
	// test if document has xml mime type
	if (!req.getOperation().success) {
		alert($$('Server session has expired.'))
	} else {
	    var XMLdata = req.getOperation().getResponse().responseXML;
		var attention = DQ.selectValue('attention', XMLdata);
		var message   = DQ.selectValue('message', XMLdata);
		if (typeof attention == 'undefined') {
			extAlert(1,$$('Server communication error. (Invalid XML message)'));
		} else if (attention > 0 ) {
			extAlert(attention,message);
		}
	}
}
// translation
(function () {
    if (!window.$$) {
        window.$$ = function(){
            var tran = [];
            var arg = arguments;
            var msg = arg[0];
            
            var idx = 0;
            var reg = /\%s/;
            var parts = [];
            
            // try to find translation
            if(typeof AWLOC !== 'undefined') {
                var translation = AWLOC[msg];
                var msg = (translation) ? translation : msg
            };
            
            //analyze the string, extract the parts with the %s identifier.
            for ( var m = reg.exec(msg); m; m = reg.exec(msg) ) {        
                parts.push(msg.substr(0, m[0][0] == "%" ? m.index : m.index));
                parts.push("%s");
                msg = msg.substr(m.index+m[0].length);
            }
            
            parts.push(msg);
                        
            //analyze the parts, replace the %s with the given arguments. beware of undefined!
            for (var i = 0; i < parts.length; ++i){
                var part = parts[i];
                
                if (part && part === "%s") {
                    var object = arg[++idx];
                
                    if (object === undefined) {
                        tran.push("%s");
                    } else {
                        tran.push(object);
                    };
                } else {
                    tran.push(part);
                };            
            };
            return tran.join('');
        };
    };
})();

// render date as pre-defined in Ext.Date.patterns
function renderDate (value, metaData, record, rowIndex, colIndex, store, view) {
    if ( value > 0 ) {
        var clockSeconds = new Date( value * 1000);
        return Ext.Date.format(value, "d-M-y H:i");
    } else {
        return '';
    }
};
function sec2min(secs) {
    if (!secs) return;
	var min = Math.floor(secs / 60);
	var sec = secs - (min * 60);
	if (sec < 10) {sec = "0" + sec;}
	return min + ' min ' + sec + ' s ';
};
// caculate bytes for index
function calcSizeIdx(kbytes) {

    var bytes = kbytes * 1024;  
    var precision = 2;
    var kilobyte  = 1024;
    var megabyte  = kilobyte * 1024;
    var gigabyte  = megabyte * 1024;
    var terabyte  = gigabyte * 1024;
      
   	if ( bytes == 0 ) {
        return '--';   	
    } else if ((bytes >= 0) && (bytes < kilobyte)) {
        return bytes + ' bytes';
 
    } else if ((bytes >= kilobyte) && (bytes < megabyte)) {
        return (bytes / kilobyte).toFixed(precision) + ' KB';
 
    } else if ((bytes >= megabyte) && (bytes < gigabyte)) {
        return (bytes / megabyte).toFixed(precision) + ' MB';
 
    } else if ((bytes >= gigabyte) && (bytes < terabyte)) {
        return (bytes / gigabyte).toFixed(precision) + ' GB';
 
    } else if (bytes >= terabyte) {
        return (bytes / terabyte).toFixed(precision) + ' TB';
 
    } else {
        return bytes + ' bytes';
    }
};
// try to fetch values for page status and message
function srvMsg(XMLdata) {
	var attention = DQ.selectValue('attention', XMLdata);
	var message   = DQ.selectValue('message', XMLdata);
	if (typeof attention == 'undefined') {
		extAlert(1,$$('Server communication error. (Invalid XML message)'));
	} else if (attention > 0 ) {
		extAlert(attention,message);
	}
}

var run = function(pbar, btn, cb) {
    Ext.Ajax.request({
        url: './account/getStatus',
        method: 'GET',
        success: function(result, request) {
            //alert(result.responseText);
            var json = Ext.decode(result.responseText);
            pbar.updateProgress(json.step / json.steps, 'Working on ' + json.status + ' Step ' + json.step + ' of ' + json.steps + '...');
            if (json.step < json.steps) setTimeout(function() {
                run(pbar, btn, cb, step + 1);
            }, 200);
            else {
                btn.dom.disabled = false;
                cb();
            }
        },
        failure: function(result, request) {
            Ext.MessageBox.alert('Failed', result.responseText);
        }
    });
}
