Ext.define('Dashboard.view.widget.JobStats', {
    extend: 'Ext.panel.Panel',
    xtype: 'job-stats-widget',
    
    requires: [
        'Dashboard.view.widget.JobStatsModel',
        'Dashboard.view.widget.JobStatsController'
    ],
    
    controller: 'job-stats',
    viewModel: {
        type: 'job-stats'
    },
    
    layout: 'fit',

    items: [{
        xtype: 'container',
        layout: {
            type: 'vbox',
            align: 'stretch'
        },
        flex: 1,
        items: [{
            xtype: 'cartesian',
            flex: 1,
            insetPadding: '10 20 0 0',
            animation: false,
            bind: {
                store: '{jobStats}'
            },
            border: 0,
            legend: {
                type: 'dom',
                docked: 'right'
            },
            interactions: ['itemhighlight'],
            axes: [{
                type: 'numeric',
                position: 'left',
                fields: ['ok', 'warning', 'error'],
                title: {
                    text: $$('Jobs'),
                    fontSize: 10
                },
                label: {
                    fill: '#666',
                    fontSize: 10
                },
                grid: true,
                minimum: 0
            }, {
                type: 'category',
                position: 'bottom',
                grid: true,
                label: {
                    fontSize: 10,
                    fill: '#666'
                }
            }],
            series: {
                type: 'bar',
                stacked: true,
                title: [$$('Successful'), $$('Warning'), $$('Error')],
                xField: 'dateShort',
                yField: ['ok', 'warning', 'error'],
                style: {
                    maxBarWidth: 50,
                    opacity: 0.80
                },
                colors: ['#66CC00', '#FF9900', '#FF3300'],
                tooltip: {
                    trackMouse: true,
                    renderer: function(tooltip, record, item) {
                        var date = Ext.Date.format(new Date(record.get('date')), 'M d, Y');
                        var value = record.get(item.field);
                        var type = '';
                        switch(item.field) {
                            case 'ok': type = 'Successful'; break;
                            case 'warning': type = 'Warning'; break;
                            case 'error': type = 'Error'; break;
                        }
                        tooltip.setHtml(date + '<br>' + type + ' jobs: ' + value);
                    }
                }
            }
        }],
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: ['->',{
            xtype: 'segmentedbutton',
            reference: 'periodToggle_ref',
            stateful: true,
            stateId: 'job-stats-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            defaults: {
                width: 50
            },
            items: [{
                text: '1W',
                value: 7
            }, {
                text: '2W',
                value: 14
            }, {
                text: '3W',
                value: 21
            }, {
                text: '4W',
                value: 28
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }]
    }]
});
