Ext.define("Dashboard.model.ArchiveIndexUsage", {
    extend: 'Ext.data.Model',
    fields: [{
        name: 'queryName', type: 'string'
    }, {
        name: 'date', type: 'date'
    }, {
        name: 'dateShort',
        type: 'string',
        convert: function(v, record) {
            var value = record.get('date');
            return Ext.Date.format(new Date(value), 'M j');
        }
    }, {
        name: 'totalSizeKiB', type: 'float'  // Hauptfeld vom Backend
    }, {
        name: 'totalSizeGiB',
        type: 'float',
        convert: function(v, record) {
            var kbyte = record.get('totalSizeKiB');
            return (kbyte / (1024 * 1024)); // KiB → GiB
        }
    }, {
        name: 'changeFromPrevious', type: 'float'  // In KiB vom Backend
    }],
    proxy: {
        type: 'ajax',
        url: document.dashboardForm.startTdp.value,
        actionMethods: {
            read: 'GET'
        },
        extraParams: {
            caller: 'ajaxArchiveIndexUsage',
            demoMode: localStorage.getItem('demoMode') === 'true',
            days: 7
        },
        reader: {
            type: 'json',
            rootProperty: 'data'
        }
    }
});