Ext.define('P5Index.view.SelectionWindowViewModel', {
    extend: 'Ext.app.ViewModel',
    alias: 'viewmodel.selectionwindow',
    
    requires: [
        'P5Index.model.Selection',
        'P5Index.model.SavedSelection'
    ],

    data: {
        windowTitle: '',
        actionButton: '',
        actionButtonAll: '',
        treeType: '',
        operation: ''
    },
    
    stores: {
        // Store für gespeicherte Auswahlen
        basketListStore: {
            model: 'P5Index.model.SavedSelection',
            autoLoad: false,
            proxy: {
                type: 'ajax',
                url: browser_index,
                actionMethods: 'POST',
                extraParams: {
                    caller: 'ajaxGetBasketList'
                },
                reader: {
                    type: 'xml',
                    record: 'baskets'
                }
            },
            listeners: {
                load: 'onBasketListLoaded'
            }
        },
        
        // Store für den Inhalt der aktuellen Auswahl
        basketContentStore: {
            model: 'P5Index.model.Selection',
            storeId: 'store_selection',
            autoLoad: false,
            proxy: {
                type: 'ajax',
                url: browser_index,
                timeout: 3600000,
                actionMethods: {
                    create: 'POST',
                    read: 'POST',
                    update: 'POST',
                    destroy: 'POST'
                },
                extraParams: {
                    caller: 'ajaxGetBasketContent',
                    node: rootUrl,
                    isXml: true
                },
                reader: {
                    type: 'xml',
                    root: 'nodes',
                    record: 'node'
                },
                // Hinzufügen des afterRequest-Handlers zur Verarbeitung der basketID
                afterRequest: function(req, res) {
                    if (req.getOperation().success) {
                        console.log("3 store_selection loaded");
                        var XMLdata = req.getOperation().getResponse().responseXML;

                        if (!XMLdata) {
                            console.error("No XML data in the response");
                            return;
                        }
                        var basketID = DQ.selectValue('basketID', XMLdata);
                        // basketID für restore oder archive start setzen
                        // vm.set('basketID', basketID);
                        var selectionCombo = Ext.ComponentQuery.query('#basketList_id')[0];                        
                        if (selectionCombo) {
                            // Den Store der ComboBox neu laden
                            console.log('4 LOAD BasketListStore');
                            selectionCombo.store.on('load', function(store, records) {
                                console.log("5 EVENT BasketListStore loaded");
                                if (basketID && records.length > 0) {
                                    console.log("-> 6 SELECT basketID: " + basketID);
                                    // Selektiere den Eintrag ohne Event-Trigger
                                    selectionCombo.select(basketID,1,1);
                                }
                            }, null, {single: true});
                            
                            selectionCombo.store.load();
                        }
                    }
                }
            },
            listeners: {
                load: 'onBasketContentLoaded'
            }
        }
    },
    formulas: {
        buttonEnabled: {
            // An explicit bind to the store records
            bind: '{basketContentStore.data.items}',
            get: function(records) {
                var hasRecords = records && records.length > 0;
                return hasRecords;
            }
        },
        buttonAllEnabled: {
            bind: '{basketListStore.data.items}',
            get: function(records) {
                var hasMultiple = records && records.length > 1;
                return hasMultiple;
            }
        }
    }
});