Ext.define('P5Index.util.TSVParser', {
    singleton: true,
    
    debugMode: false,  // NEU: Als Property für externe Steuerung
    
    parseTSV: function(tsvContent) {
        var logger = P5Index.util.ParserLogger;  // NEU
        var debugMode = this.debugMode;         // NEU
        
        try {
            var lines = tsvContent.split(/\r?\n/);
            var mediaItems = [];
            var uniquePaths = {};
            
            // NEU: Log parse start
            if (logger.isLogging) {
                logger.addLog('Starting TSV parse (' + lines.length + ' lines)');
            }
            
            var firstRowColumnCount = 0;  // NEU: für Column-Detection
            var emptyRows = 0;            // NEU: für Statistik
            var duplicateCount = 0;       // NEU: für Statistik
            
            lines.forEach(function(line, lineIndex) {
                if (!line.trim()) {
                    emptyRows++;  // NEU
                    return;
                }
                
                // TSV: Tab-separiert
                var cells = line.split('\t');
                
                // NEU: First row column detection & logging
                if (firstRowColumnCount === 0) {
                    firstRowColumnCount = cells.length;
                    if (logger.isLogging) {
                        logger.addLog('Detected ' + firstRowColumnCount + ' columns');
                        
                        if (debugMode) {
                            var sample = cells.slice(0, 5).map(function(cell) {
                                return '"' + cell.substring(0, 20) + 
                                       (cell.length > 20 ? '...' : '') + '"';
                            }).join(' | ');
                            if (cells.length > 5) sample += ' | ...';
                            logger.addLog('First row: ' + sample);
                        }
                    }
                }
                
                // Alle Spalten nach Pfaden durchsuchen
                cells.forEach(function(cell, index) {
                    cell = cell.trim();
                    if (this.isMediaPath(cell)) {
                        var path = this.normalizePath(cell);
                        var fileName = this.extractFileName(path);
                        
                        if (!uniquePaths[path]) {
                            uniquePaths[path] = {
                                fileName: fileName,
                                path: path,
                                columnIndex: index,
                                usedDurationTC: '',
                                availableDurationTC: ''
                            };
                            
                            // NEU: Debug log first few items
                            if (logger.isLogging && debugMode && Object.keys(uniquePaths).length <= 3) {
                                logger.addLog('Row ' + (lineIndex + 1) + ', Col ' + (index + 1) + 
                                            ': Found "' + fileName + '"');
                            }
                        } else {
                            duplicateCount++;  // NEU
                        }
                    }
                }, this);
            }, this);
            
            var totalItems = Object.keys(uniquePaths).length;
            
            // NEU: Log summary
            if (logger.isLogging) {
                logger.addLog('Found ' + totalItems + ' unique paths');
                
                if (emptyRows > 0) {
                    logger.addLog('Skipped ' + emptyRows + ' empty rows');
                }
                
                if (duplicateCount > 0) {
                    logger.addLog('Removed ' + duplicateCount + ' duplicates');
                }
            }
            
            return {
                success: true,
                mediaItems: Object.values(uniquePaths),
                totalCount: totalItems,
                formatType: 'TSV',
                detectedFormat: 'Tab-Separated Values (TSV)'
            };
            
        } catch (error) {
            // NEU: Log error
            if (logger.isLogging) {
                logger.addLog('TSV parse failed - ' + error.message, 'ERROR');
            }
            console.error('Error parsing TSV content:', error);
            return {
                success: false,
                error: error.message
            };
        }
    },
    
    isMediaPath: function(text) {
        // Spezifische Logik für TSV - strenger als TEXTParser
        return text && 
               (text.includes('/') || text.includes('\\')) &&
               text.length > 3 &&
               !text.includes('http://') && 
               !text.includes('https://') &&
               !text.match(/^\d+$/); // Keine reinen Zahlen
    },
    
    normalizePath: function(path) {
        // Handle Windows-style escaped characters
        path = path.replace(/\^([0-9a-fA-F]{2})/g, function(match, hex) {
            return String.fromCharCode(parseInt(hex, 16));
        });
        
        // Standard Unix path normalization
        var unixPath = path.replace(/\\/g, '/');
        unixPath = unixPath.replace(/^([A-Za-z]):/, function(match, driveLetter) {
            return '/' + driveLetter.toLowerCase() + '/';
        });
        unixPath = unixPath.replace(/\/+/g, '/');
        
        return unixPath;
    },
    
    extractFileName: function(path) {
        return path.split('/').pop().split('\\').pop();
    }
});