Ext.define('P5Jobmanager.view.MainView', {
    extend: 'Ext.container.Viewport',
    alias: 'widget.mainview',

    requires: [
        'P5Jobmanager.view.MainViewViewModel',
        'P5Jobmanager.view.MainViewViewController',
        'P5Jobmanager.view.JobmonitorGrids',
        'P5Jobmanager.view.ScheduledJobsGrid',
        'P5Jobmanager.view.ParkedJobsGrid',
        'P5Jobmanager.view.JoblogGrids',
        'P5Jobmanager.view.ConfigRegion'
    ],

    controller: 'mainview',

    viewModel: {
        type: 'mainview'
    },
    
    layout: 'border',
    items: [{
        header: false,
        xtype: 'configregion',
        region:'west',
        stateId: 'stateConfigregion_id',
        stateful: true,
        split: true,
        collapsed: false,
        collapsible: true,
        floatable: true,
        border: false,
    },{
        xtype: 'container',
        region: 'center',
        itemId: 'mainRegion',
        layout: 'border',
        border: false,
        items: [{
            xtype: 'panel',
            region: 'north',
            stateId: 'stateJobQueuegrids_id',
            stateful: true,
            title: $$('Queued Jobs'),
            bind:{
	            title: '{queueTitle}'
	        },
            headerPosition: 'left',
            collapsible: true,
            titleCollapse: true,
            flex: 1,
            border: false,
            split: true,
            layout: { type: 'vbox', pack: 'start', align: 'stretch' },
            items: [{
                xtype: 'scheduledjobsgrid',
            },{
                xtype: 'parkedjobsgrid'
            }]
        },{
            xtype: 'jobmonitorgrids',
            region: 'center',
            title: $$('Running Jobs'),
            headerPosition: 'left',
            flex: 1,
            border: false,
            split: true
        },{
            xtype: 'jobloggrids',
            cls: 'joblog-grid',
            region: 'south',
            stateId: 'stateJobloggrids_id',
            stateful: true,
            title: $$('Finished Jobs'),
            headerPosition: 'left',
            collapsible: true,
            titleCollapse: true,
            flex: 1,
            border: false,
            split: true
        }]
    }]
});