/**
 * Main.js - Main Container for the Dashboard Application
 * 
 * This is the root container that initializes the dashboard and handles state management.
 * It uses MVVM architecture with separate view, viewmodel, and controller.
 * 
 * Key features:
 * - Stateful configuration (stateId: 'dashboard-state')
 * - MVVM pattern implementation
 * - Central container for the p5-dashboard component
 */

Ext.define('Dashboard.view.Main', {
    extend: 'Ext.container.Container',
    xtype: 'app-dashboard',

    requires: [
        'Dashboard.view.Dashboard',
        'Dashboard.view.MainViewModel',
        'Dashboard.view.MainController',
        'Dashboard.view.widget.LicenseUsage',
        'Dashboard.view.widget.Notification',
        'Dashboard.view.widget.InstallationInfo',
        'Dashboard.view.widget.BackupStats',
        'Dashboard.view.widget.SynchronizeStats',
        'Dashboard.view.widget.ArchiveStats',
        'Dashboard.view.widget.RestoreStats',
        'Dashboard.view.widget.JobStats',
        'Dashboard.view.widget.PoolUsage',
        'Dashboard.view.widget.CloudDiskUsage',
        'Dashboard.view.widget.DriveSpeed',
        'Dashboard.view.widget.WelcomeScreen',
        'Dashboard.view.widget.BackupOverview',
        'Dashboard.view.widget.SynchronizeOverview',
        'Dashboard.view.widget.ArchiveOverview',
        'Dashboard.view.widget.ArchiveIndexUsage'
    ],
    
    controller: {
        type: 'dashboard'
    },
    viewModel: {
        type: 'dashboard'
    },

    stateful: true,
    stateId: 'dashboard-state',

    padding: '0',
    border: false,
    items: [{
        region: 'center',
        autoScroll: true,
        items: [{
            xtype: 'p5-dashboard'
        }]
    }]
});