Ext.define('Dashboard.view.widget.Notification', {
    extend: 'Ext.grid.Panel',
    xtype: 'notification-widget',
    
    requires: [
        'Dashboard.view.widget.NotificationModel',
        'Dashboard.view.widget.NotificationController'
    ],
    
    controller: 'notification',
    viewModel: {
        type: 'notification'
    },
    
    bind: {
        store: '{notificationData}'
    },
 
    multiSelect: false,
    hideHeaders: true,
    disableSelection: true,
    features: [{
        ftype: 'rowbody',
        getAdditionalData: function (data, idx, record, orig) {
            return {
                rowBody: '<div style="padding-left: 10px;padding-bottom: 10px">' + record.get("body") + '</div>'
            };
        }
    }],
    columns:[{
        xtype:'gridcolumn',
        text:'Message',
        flex: 1,
        dataIndex:'subject',
        renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
            metaData.tdStyle = "font-size: 12px;font-weight: bold !important;";
            return value;
        }
    },{
        xtype:'datecolumn',
        text:'Message',
        width: 120,
        dataIndex:'created',
        format: Ext.Date.patterns[userDateFormat]
    },{
        xtype: 'actioncolumn',
        width: 40,
        items: [{
            iconCls: 'fa fa-times',
            tooltip: $$('Dismiss Note'),
            handler: 'onDismissNote'
        }]
    }]
}); 
