Ext.define('Dashboard.view.widget.ArchiveOverview', {
    extend: 'Ext.grid.Panel',
    xtype: 'archive-overview-widget',
    
    requires: [
        'Dashboard.view.widget.ArchiveOverviewController',
        'Dashboard.view.widget.ArchiveOverviewModel'
    ],
    
    controller: 'archive-overview-widget',
    viewModel: {
        type: 'archive-overview-widget'
    },
    
    bind: {
        store: '{archiveOverview}'
    },
    
    columns: [{
        text: $$('Archive Job'),
        dataIndex: 'jobtext',
        flex: 3,
    }, {
        text: $$('Status'),
        dataIndex: 'statusText',
        flex: 1,
        renderer: function(value, meta, record) {
            var statusClass = record.get('statusClass');
            var jobId = record.get('jobId');
            var iconHtml = '';
            
            // Icon basierend auf Status
            switch(statusClass) {
                case 'running':
                case 'scheduled':
                    iconHtml = '<i class="fas fa-circle-notch fa-spin" style="color:#0088FF;"></i> ';
                    break;
                case 'finished':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'error':
                    iconHtml = '<i class="fas fa-circle" style="color:#FF3300;"></i> ';
                    break;
                case 'warning':
                case 'cancelled':
                    iconHtml = '<i class="fas fa-exclamation-triangle" style="color:#FF9900;"></i> ';
                    break;
                default:
                    iconHtml = '<i class="fas fa-circle" style="color:#CCCCCC;"></i> ';
            }
            
            var html = iconHtml;
            
            if (jobId) {
                html += '<a href="javascript:void(0)" class="startd" ' +
                       'data-action="view-job" data-jobid="' + jobId + '">' + value + '</a>';
            } else {
                html += '<span>' + value + '</span>';
            }
            
            return html;
        }
    }, {
        text: $$('Start Time'),
        dataIndex: 'timeStarted',
        width: 80,
    }, {
        text: $$('Duration'),
        dataIndex: 'duration',
        width: 80,
    }, {
        text: $$('Data Size'),
        dataIndex: 'dataSize',
        width: 80,
        renderer: function(value) {
            if (value > 0) {
                return CalcSize(value);
            }
            return '';
        }
    }, {
        text: $$('Client'),
        dataIndex: 'client',
        flex: 1,
        renderer: function(value) {
            return '<a href="javascript:void(0)" class="startd" data-action="view-client" ' + 
                   'data-name="' + value + '">' + value + '</a>';
        }
    }, {
        text: $$('Pool'),
        dataIndex: 'pool',
        flex: 1,
        renderer: function(value) {
            if (!value) return '';
            
            return '<a href="javascript:void(0)" class="startd" data-action="view-pool" ' + 
                   'data-name="' + value + '">' + value + '</a>';
        }
    }, {
        text: $$('Archived Files'),
        dataIndex: 'dirlist',
        flex: 1,
        renderer: function(value) {
            if (!value || !value.length) return '';
            
            if (value.length === 1) {
                return value[0];
            }
            
            return value[0] + ' <span class="more-dirs">(+' + (value.length - 1) + ' more)</span>';
        }
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img8/archive_32.png',
            width: 24,
            height: 24
       },'->',{
            xtype: 'segmentedbutton',
            reference: 'periodToggle_ref',
            stateful: true,
            stateId: 'archive-overview-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            items: [{
                text: $$('Today'),
                value: 'today'
            }, {
                text: $$('Since Yesterday'),
                value: 'yesterday'
            }, {
                text: $$('Since Last Week'),
                value: 'week'
            }, {
                text: $$('Since Last Month'),
                value: 'month'
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }]
    }],
    
    listeners: {
        cellclick: 'onCellClick'
    }
});