##############################################################################
#
# workspace_lib.tcl
#
#    P5 TCL GUI Library
#
#    See the file "license.txt" for information on usage and
#    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
#    Rcsid: @(#)$Id: workspace_lib.tcl,v 1.218 2019/01/09 11:11:13 jd Exp $
#
##############################################################################

proc createFileListing { elementListe layout viewstyle sortCol sortDirection searchFlag treeStep { resourcegrp {} } } {

    #
    set filterDot [session::get loginAreaFilterDot]
    set collayout [getWSLayout $layout]
    set dbname    [session::get database]
    
    set sortColumn ""
    #
    # check if the databse or ressource has this colume to sort
    #
    foreach col [keylkeys collayout col] {
        if { [keylget collayout col.$col.field] == $sortCol } {
            set sortColumn $sortCol
            break
        }
    }
    if { $sortColumn == "" } {
        set sortColumn [keylget collayout sortcol]
    }
    keylset collayout sortcol $sortColumn
    
    if { $sortDirection == "" } {
        set sortDirection [keylget collayout sortdir]
    } else {
        keylset collayout sortdir $sortDirection
    }
    
    set rowid     0
    set unsortCol [list]

    # get search query and current database and path 
    set query [session::get env_query]
    set curl  [session::get currentUrl]
    #
    if { $searchFlag == "true" } {
        if  { ![keylget query query.$curl.skeys skeys] } { set skeys ""}
        foreach skey $skeys {
            if { [keylget query query.$curl.$skey.sval sval] && $sval != "" } {
                # check if field is a date field
                if { [string match "*time*" $skey] || [string match "*date*" $skey] } {
                    keylset query query.$curl.$skey.stype "date"
                    if { [catch { keylset query query.$curl.$skey.rval [resolveDate $sval] }] } {
                        keylset query query.$curl.$skey.sval "Invalid date format"
                        keylset query query.$curl.$skey.rval [list 0  [clock seconds]]
                    }
                } elseif { [regexp {^(=|<|>|<=|>=)?(\d+)$} $sval match oper rval] } {
                    keylset query query.$curl.$skey.stype "integer"
                    keylset query query.$curl.$skey.rval  $rval
                    if { $oper == "" || $oper == "=" } {
                        keylset query query.$curl.$skey.oper "=="
                    } else {
                        keylset query query.$curl.$skey.oper $oper
                    }
                } else {
                    keylset query query.$curl.$skey.stype "string"
                    if { [regexp {^=(.*)$} $sval match rval] } {
                        keylset query query.$curl.$skey.rval "^$rval$"
                    } else {
                        keylset query query.$curl.$skey.rval $sval
                    }
                }
            }
        }
    }
    foreach hd $elementListe {
        # ns_log notice "Time in getAttributeP4 proc: [time {        }]"
        if { [catch {getAttributeP4 $hd attribute workspace $resourcegrp} tres] || $tres != 1 } continue   
        if { $filterDot } {
            if { [string first . $attribute(name)] == 0 || [string first . [file tail $attribute(parentPathByName)]] == 0 } {
               continue
            }
        }
        if { $searchFlag == "true" } {
            #
            set mustTrue 0
            set isTrue   0
            foreach skey $skeys {
                if { [keylget query query.$curl.$skey.stype stype] && $stype != "" } {
                    keylget query query.$curl.$skey.rval rval
                    incr mustTrue
                    if { $stype == "date" } {
                        if { $attribute(${skey}) > [lindex $rval 0] && $attribute(${skey}) < [lindex $rval 1] } {
                            incr isTrue
                        }
                    } elseif { $stype == "integer" } {
                        if { [string is integer -strict $attribute(${skey})] && [expr $attribute(${skey}) [keylget query query.$curl.$skey.oper] $rval] } {
                            incr isTrue
                        }
                    } else {
                        if { [regexp -nocase $rval $attribute(${skey}) match rest] } {
                            incr isTrue
                        }
                    }
                }
            }
            # skip if element is not searched
            if { $mustTrue > $isTrue } continue
        }
        # add element to list
        set tblRow($rowid) [array get attribute]
        lappend unsortCol  [list $rowid $attribute($sortColumn) $attribute(name)]
        incr rowid
    }   
    # 
    set attribute(elementCount) $rowid
    set sortCommand [getSortCommand $sortColumn $sortDirection]
    #ns_log notice "Time in firstsort proc: [time { }]"
    set sortCol [eval $sortCommand { $unsortCol }]

    # if another column as "name" is selected sort "name" as second column
    if { $sortColumn != "name" } {
        set lastSort  "_NUL_"
        set secsort   [list] 
        set unsortCol [list]
        set sortSec   "lsort -dictionary -index 2 -increasing"
        #
        foreach cell $sortCol {
            set nextCell [lindex $cell 0]
            set nextSort [lindex $cell 1]
            set nextName [lindex $cell 2]
            if { $lastSort != "_NUL_" } {
                if { $nextSort != $lastSort } {
                    set secsort   [concat $secsort [eval $sortSec { $unsortCol }]]
                    set unsortCol [list]
                }
            }
            lappend unsortCol [list $nextCell $nextSort $nextName]
            set lastSort $nextSort
        }
        set sortCol [concat $secsort [eval $sortSec { $unsortCol }]]
    }

    set nr 0
    mkWsCSS $collayout
    set top [keylget collayout top]
    html::table -class ptabl -width 100% -border "0" -cellpadding "0" -cellspacing "0" {
        html::tr {
            foreach col [keylkeys collayout col] {
                if { $col == 1 } {
                    # html::td -class th1
                    # disable search for 4.0
                    html::td -class th$col {
                        html::img -class ficon -style "left:7px;padding-right:10px" -src [session::url /img4/10x11.gif]  { html::t  "" }
                    }
                } else {
                    if { [set sortField [keylget collayout col.$col.field]] != "" } {
                        html::td -class th$col -onclick "sortCol('$sortField')" -style "cursor: pointer" { 
                            html::span -class ti$col { html::t [translate [keylget collayout col.$col.text]] }
                        }
                    } else {
                        html::td -class th$col { 
                            html::span -class ti$col { html::t [translate [keylget collayout col.$col.text]] }
                        }
                    }
                }
            }
            html::td -style "display: none"
        }
        # disable search for 4.0
        if { 0 } {
            html::tr {
                foreach col [keylkeys collayout col] {
                    if { $col == 1 } {
                        html::td -class thf$col {
                           html::img -class ficon -style "left:7px;padding-right:5px" -onclick "doSearch()" -src [session::url /img4/tfind.png] { html::t  "" }
                        }
                    } else {
                        if {[catch {keylget collayout col.$col.field} skey]}     { set skey ""}
                        if {[catch {keylget query query.$curl.$skey.sval} sval]} { set sval ""}
                        html::td -class thf$col {
                            html::input -class tf$col -type text -name S_$skey -value $sval
                        }
                    }
                }
                html::td -style "display: none"
            }
        }
    # for fixed column header
    #incr top 21
    #html::table -style "position: absolute;top:${top}px;left:0px;" -width 100% -border "0" -cellpadding "0" -cellspacing "0"
        #
        # first line with parent folder
        #
        if { $dbname != "customerconfig" && $treeStep != "" } {
            tr_CurrentUrl $nr $treeStep
            incr nr
        }
        #
        # draw listing
        #
        set nr [tr_$layout $nr $sortCol tblRow $sortColumn]
        #
        # empty row to fill body
        #
        html::tr { html::td -height 60 }
    }
    return $nr
}

##############################################################################
#
proc createPickerListing { elementListe layout sortCol sortDirection treeStep } {

    #
    set filterDot [session::get loginAreaFilterDot]
    set collayout [getWSLayout $layout]
 
    #ns_log notice treeStep:$treeStep   
    set hd          [$::lexxCommand elementHandle [decodeLexxUrl elementpath $treeStep]]
    set database    [$::lexxCommand set database]
    set elementPath [$::lexxCommand elementPath $hd]
    set elementPath [encodeLexxUrl $database $elementPath]
    #ns_log notice elementPath:$elementPath

    
    set sortColumn ""
    #
    # check if the databse or ressource has this colume to sort
    #
    foreach col [keylkeys collayout col] {
        if { [keylget collayout col.$col.field] == $sortCol } {
            set sortColumn $sortCol
            break
        }
    }
    if { $sortColumn == "" } {
        set sortColumn [keylget collayout sortcol]
    }
    keylset collayout sortcol $sortColumn
    
    if { $sortDirection == "" } {
        set sortDirection [keylget collayout sortdir]
    } else {
        keylset collayout sortdir $sortDirection
    }
    
    set rowid     0
    set unsortCol [list]

    # get search query and current database and path 
    set query [session::get env_query]
    set curl  [session::get currentUrl]
    #
    foreach hd $elementListe {
        # ns_log notice "Time in getAttributeP4 proc: [time {        }]"                      
        if { [catch {getAttributeP4 $hd attribute workspace} tres] || $tres != 1 } continue   
        if { $filterDot } {
            if { [string first . $attribute(name)] == 0 || [string first . [file tail $attribute(parentPathByName)]] == 0 } {
               continue
            }
        }
        # add element to list
        set tblRow($rowid) [array get attribute]
        lappend unsortCol  [list $rowid $attribute($sortColumn)]
        incr rowid
    }   
    # 
    set attribute(elementCount) $rowid
    set sortCommand [getSortCommand $sortColumn $sortDirection]
    set sortCol [eval $sortCommand { $unsortCol }]

    set nr 0
    mkWsCSS $collayout
    html::table -class ftabl -style "z-index: 2;top:0px;left:0px;position: fixed" -width 100% -border "0" -cellpadding "0" -cellspacing "0" {
        html::tr {
            foreach col [keylkeys collayout col] {
                if { $col == 1 } {
                    html::td -class th1
                } else {
                    if { [set sortField [keylget collayout col.$col.field]] != "" } {
                        html::td -class th$col -onclick "sortCol('$sortField')" -style "cursor: pointer" { 
                            html::span -class ti$col { html::t [translate [keylget collayout col.$col.text]] }
                        }
                    } else {
                        html::td -class th$col { 
                            html::span -class ti$col { html::t [translate [keylget collayout col.$col.text]] }
                        }
                    }
                }
            }
        }
    }
    html::table -style "position: absolute;top:20px;left:0px;" -width 100% -border "0" -cellpadding "0" -cellspacing "0" {
        #
        # first line with parent folder
        #
        if { $treeStep != "" } {
            set filePickerPath [session::get filePickerPath]
            array set treeArray [session::get filePickerPath]
            if {[set parentDir [lindex $filePickerPath [expr [lsearch $filePickerPath $treeStep] -2]]] == "" } {
                 set parentDir [lindex $filePickerPath 0]
            }
            html::tr -id $nr -onclick "rowMark(this)" -onDblClick "prevDirDbl(this)" {
                html::td -class td1 -align "right" {
                    html::img -src [session::url /img4/back.png] { html::t "" } 
                }
                html::td -colspan 3 -class td2 { html::span -class tdiv -style "font-weight:900" {html::t [LexxTree displayName $treeArray(${treeStep})] } }
                html::td -style "display: none" {
                    html::input -id cbp$nr -style "display: none" -type checkbox -value $elementPath
                    html::input -id cbi$nr -style "display: none" -type checkbox -value $parentDir
                }
            }
            incr nr
        }
        #
        # draw listing
        #
        set nr [tr_$layout $nr $sortCol tblRow $sortColumn]
    }
    return $nr
}

##############################################################################
# create the job popup menu in tool page

proc popupSTARTJob { } {

    html::table -id "PopJobBox" -class PopLogBoxTop -style "top:0px; right:30px;" -onmouseover "event.cancelBubble=true" -border "0" -cellpadding "2" -cellspacing "0" {
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "jobMonitor(this)" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "Job Monitor"] }
            html::td { html::t "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" }
        }
        html::tr -id [session::url /log_query/index.tdp] -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "queryLog(this)" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "Job History/Log"] }
            html::td { html::t "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" }
        }
        html::tr { html::td -height 2 }
    }
}

##############################################################################
# create the job popup menu for help and suuport

proc popupHelp { } {

    set lang [session::browserLanguage]

    set manLang $lang

    if { [session::isadmin] } {
        set isAdminUser 1
    } else {
        set isAdminUser 0
    }
        
    html::table -id "PopHelpBox" -class PopLogBoxTop -style "top:0px; right:30px;" -onmouseover "event.cancelBubble=true" -border "0" -cellpadding "2" -cellspacing "0" {
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "onlineDocuFrame('/docs/pdf/P5Manual_EN.pdf')" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "User Guide"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "openArchiware('http://p5.archiware.com/masterclass')" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "P5 Masterclass"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -colspan 3 { html::div -class PopMenuLine { html::t {} }}}
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "openArchiware('http://www.archiware.com/account')" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "License Registration"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "openArchiware('https://support.archiware.com')" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "Technical Support"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        #html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick #"openArchiware('http://www.archiware.com/download')" {
            #html::td { html::t "&nbsp;&nbsp;" }
            #html::td -class PopUpColTxt -valign center { html::t [translate "Product Updates"] }
            #html::td { html::t "&nbsp;&nbsp;" }
        #}
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "updateP5(this)" -id [session::url /etc/updateP5.tdp] {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "Software Update"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -colspan 3 { html::div -class PopMenuLine { html::t {} }}}
        # Agent Setup 
        if { $isAdminUser } {
            set mouseover    {this.className='PopUpRowM'}
            set mouseout     {this.className='PopUpRow'}
            set onclick      {agentSetup(this)}
            set style        ""
        } else {
            set mouseover    {return false}
            set mouseout     {return false}
            set onclick      {return false}
            set style        "color: gray"
        }
        html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick $onclick {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center -style $style { html::t [translate "Agent Setup"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        # LTFS Exchange 
        if { $isAdminUser } {
            set mouseover    {this.className='PopUpRowM'}
            set mouseout     {this.className='PopUpRow'}
            set onclick      {ltfsExchange(this)}
            set style        ""
        } else {
            set mouseover    {return false}
            set mouseout     {return false}
            set onclick      {return false}
            set style        "color: gray"
        }
        html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick $onclick {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center -style $style { html::t [translate "LTFS Exchange"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        # Configuration restore 
        if { $isAdminUser } {
            set mouseover    {this.className='PopUpRowM'}
            set mouseout     {this.className='PopUpRow'}
            set onclick      {commonProc('CustIndex','ixck')}
            set style        ""
        } else {
            set mouseover    {return false}
            set mouseout     {return false}
            set onclick      {return false}
            set style        "color: gray"
        }
        html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick $onclick {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center -style $style { html::t [translate "Configuration restore"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        # Download support data 
        if { $isAdminUser } {
            set mouseover    {this.className='PopUpRowM'}
            set mouseout     {this.className='PopUpRow'}
            set onclick      {supportInfo(event)}
            set style        ""
        } else {
            set mouseover    {return false}
            set mouseout     {return false}
            set onclick      {return false}
            set style        "color: gray"
        }        
        if { [ns_conn protocol] eq "http" } {
            html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick $onclick {
                html::td { html::t "&nbsp;&nbsp;" }
                html::td -class PopUpColTxt -valign center -style $style { html::t [translate "Download support data"] }
                html::td { html::t "&nbsp;&nbsp;" }
            }
        } else {
            html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick "exportSupportData(this, event)" -id [session::url /etc/export-support-data.tdp]  {
                html::td { html::t "&nbsp;&nbsp;" }
                html::td -class PopUpColTxt -valign center -style $style { html::t [translate "Export support data"] }
                html::td { html::t "&nbsp;&nbsp;" }
            }
        }
        # Advanced Settings
        if { $isAdminUser } {
            set mouseover    {this.className='PopUpRowM'}
            set mouseout     {this.className='PopUpRow'}
            set onclick      {advancedSettings(this)}
            set style        ""
        } else {
            set mouseover    {return false}
            set mouseout     {return false}
            set onclick      {return false}
            set style        "color: gray"
        }
        html::tr -class PopUpRow -onMouseOver $mouseover -onMouseOut $mouseout -onclick $onclick -id [session::url /etc/advanced-settings.tdp]  {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center -style $style { html::t [translate "Advanced Settings"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -colspan 3 { html::div -class PopMenuLine { html::t {} }}}
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick commonProc('Password','change') {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "Change Password"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -colspan 3 { html::div -class PopMenuLine { html::t {} }}}
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "aboutPresSTORE(this)" -id [session::url /etc/about.tdp] {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxt -valign center { html::t [translate "About P5"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -height 2 }
    }
}

##############################################################################
# create the job popup menu for help and suuport

proc popupProtableHelp { } {

    set lang [session::browserLanguage]

    set manLang $lang

    if { [session::isadmin] } {
        set eventSupport "supportInfo(event)"
        set style        ""
    } else {
        set eventSupport "return false"
        set style        "color: gray"
    }
    
    html::table -id "PopHelpBox" -class PopLogBoxB2go -style "top:0px; right:30px;" -onmouseover "event.cancelBubble=true" -border "0" -cellpadding "2" -cellspacing "0" {
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "onlineDocuFrame('/docs/pdf/P5Manual_EN.pdf')" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxtB2go -valign center { html::t [translate "User Guide"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick $eventSupport {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxtB2go -valign center -style $style { html::t [translate "Download support data"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "passwdChange()" {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxtB2go -valign center { html::t [translate "Change Password"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
        html::tr { html::td -colspan 3 { html::div -class PopMenuLine { html::t {} }}}
        html::tr -class PopUpRow -onMouseOver "this.className='PopUpRowM'" -onMouseOut "this.className='PopUpRow'" -onclick "aboutPresSTORE(this)" -id [session::url /etc/about.tdp] {
            html::td { html::t "&nbsp;&nbsp;" }
            html::td -class PopUpColTxtB2go -valign center { html::t [translate "About P5"] }
            html::td { html::t "&nbsp;&nbsp;" }
        }
    }
}

##############################################################################
# create the popup_basket menu to position in the window
proc popupJobMonitor { } {

    html::div -id "PopEditBox" -class PopLogBox  -style "top:0px; left:100px; width:200px; height:46px;" -onmouseover "event.cancelBubble=true" {
        html::div              -class PopLogRow1 -style "top:2px; left:0px; width:100%; height:22px;"    -onmouseover "popupMark(this)" -onclick "stopcancel(this);event.cancelBubble=true" {
            html::img          -class icon       -style "top:2px; left:8px;;width:14px" -src [session::url /img4/stop_16.png] { html::t  "" } 
            html::span         -class PopPwdCol1 -style "top:0px; left:27px; width:100px; height:22px;" { html::t [translate  "Stop/Cancel"] }
        }
        html::div              -class PopLogRow1 -style "top:24px; left:0px; width:100%; height:22px;"   -onmouseover "popupMark(this)" -onclick "startnow(this);event.cancelBubble=true" {
            html::img          -class icon       -style "top:2px; left:8px;width:14px" -src [session::url /img4/run_16.png] { html::t  "" } 
            html::span         -class PopPwdCol1 -style "top:0px; left:27px; width:100px; height:22px;" { html::t [translate  "Start now"] }
        }
    }
}

##############################################################################
# procedure to create the login-logout popup menu
proc popupJoblogFile { } {

    set siz 22
    set wid 200
    set top 0

    set col2 "top:0px; left:10px; width:100px; height:${siz}px"
    #
    html::div -id "PopFileBox" -class PopLogBox -onmouseover "event.cancelBubble=true" {
        set node [ns_tdp_node]
        html::div      -class PopLogRow1 -style "top:${top}px; left:0px; width:100%; height:${siz}px" -onmouseover "popupMark(this)" -onclick "setTimeout('top.close(this)',20)" {
            html::span -class PopLogCol1 -style "$col2" { html::t [translate "Close Window"] }
        }
        #-------------------------
        set top [expr $top + $siz + 3]
    }
    $node setAttribute style "top:0px; left:0px; width:${wid}px; height:${top}px"
}

##############################################################################

proc optionlist { args } {

    foreach parameter "-values -keyvalues -valuetext -keyoptvalues -selected -empty -stored" {
        if { [set index [lsearch $args $parameter]] != -1 } {
            set ${parameter} [lindex $args [incr index]]
        } else {
            set ${parameter} ""
        }
    }
    #
    if { ${-empty} == 1 } {
        html::option -value "" -selected 1 { html::t {} }
    }
    if { ${-stored} == 1 } {
        html::option -value ${-selected} -selected 1 { html::t ${-selected}}
    }
    if { ${-values} != "" } {
        foreach option ${-values} {
            if { [lsearch -exact ${-selected} $option] != -1 } {
                html::option -value $option -selected 1 { html::t $option }
            } else {
                html::option -value $option { html::t $option }
            }
        }
    } elseif { ${-keyvalues} != "" } {
        foreach { value text } ${-keyvalues} {
            if { $value eq "_disabled_" } {
                html::option -value $value -disabled 1 { html::t $text }
            } elseif { [lsearch -exact ${-selected} $value] != -1 } {
                html::option -value $value -selected 1 { html::t $text }
            } else {
                html::option -value $value { html::t $text }
            }
        }
    } elseif { ${-keyoptvalues} != "" } {
        set ix -1
        set nr [expr [llength ${-keyoptvalues}] -1]
        while { $ix < $nr } {
            set value [lindex ${-keyoptvalues} [incr ix]]
            set text  [lindex ${-keyoptvalues} [incr ix]]
            if { $value == "_optgroup_" } {
                html::optgroup -label $text {
                    while { $ix < $nr } {
                        set value [lindex ${-keyoptvalues} [incr ix]]
                        set text  [lindex ${-keyoptvalues} [incr ix]]
                        if { $value == "_optgroup_" } {
                            incr ix -2
                            break
                        }
                        if { $value eq "_disabled_" } {
                            html::option -value $value -disabled 1 { html::t $text }
                        } elseif { [lsearch -exact ${-selected} $value] != -1 } {
                            html::option -value $value -selected 1 { html::t $text }
                        } else {
                            html::option -value $value { html::t $text }
                        }
                    }
                }
            } else {
                if { $value eq "_disabled_" } {
                    html::option -value $value -disabled 1 { html::t $text }
                } elseif { [lsearch -exact ${-selected} $value] != -1 } {
                    html::option -value $value -selected 1 { html::t $text }
                } else {
                    html::option -value $value { html::t $text }
                }
            }
        }
    }
}

##############################################################################
# 
proc fixButtonB2go {} {
    
    #
    set butright { 
        html::a -class kutton -onclick "wstRestore(event)"   { html::t [translate "Restore"]}
        html::a -class kutton -onclick "wstRestoreTo(event)" { html::t [translate "Restore To"]}
    }
    #    
    html::div -id buttonDockBody -class dockBox {
        html::table -border "0" -cellpadding "0" -cellspacing "0" -width 100% {
            html::tr -height 17
            html::tr {
                html::td -align left -witdh 50% {
                    html::span -class dbox  {
                        eval $butright
                    }
                }
                html::td -align right -witdh 50% {
                    html::span -class dbox  { html::t "" }
                }
            }
        }
    }
}

##############################################################################
# 
proc fixButtonMonitor {} {
    
    html::div -id buttonDockBody -class dockBox {
        html::table -border "0" -cellpadding "0" -cellspacing "0" -width 100% {
            html::tr -height 17
            html::tr {
                html::td -align left -witdh 50% {
                    html::span -class dbox  {
                        html::a -class kutton -onclick "startnow(this)" { html::t [translate "Start now"]}
                        html::a -class kutton -onclick "stopcancel(this)"  { html::t [translate "Stop/Cancel"]}
                    }
                }
                html::td -align right -witdh 50%
            }
        }
    }
}

##############################################################################
# 

proc timeLine {} {
        
    if { [set listSnapshots [$::lexxCommand listSnapshots]] != "" } {
    
        set toDay     [clock seconds]
        set yesterDay [expr {$toDay - 24 * 3600}]
        set toDay     [clock format $toDay -format "%d.%b.%Y"]
        set yesterDay [clock format $yesterDay -format "%d.%b.%Y"]
        set date ""

        html::div -id snapBox -class snapBox {
            html::div -class snapUp {
                html::img -style "padding-bottom:10px" -src [session::url /img4/clock-back.png] { html::t  "" }            
            }
            html::div -id snapFrame -class snapFrame {
                html::table -id snapTable -class snapTable -border "0" -cellpadding "0" -cellspacing "0" {
                    foreach sp $listSnapshots {
                        set bold  ""
                        set snapDate [$::lexxCommand snapshotDate $sp]
                        set clock [clock format $snapDate -format "%H:%M"]
                        if { [$::lexxCommand config -snapshot] == $sp } {
                            set bold "color:#44DD88;font-weight: bold"
                        }
                        if { [clock format $snapDate -format "%d.%b.%Y"] != $date } {
                            html::tr {
                                html::td {
                                    set date  [clock format $snapDate -format "%d.%b.%Y"]
                                    if { $toDay == $date } {
                                        set pdate [translate "today"]
                                    } elseif { $yesterDay == $date } {
                                        set pdate [translate "yesterday"]
                                    } else {
                                        set pdate $date
                                    }
                                    html::div -style "font-weight: bold;color:#555555" { html::t $pdate }
                                }
                            }
                        }
                        html::tr -id "$sp" -onclick "setShnapShot(this)" {
                            html::td -style "cursor: pointer;color:#555555;$bold" {
                                html::div { html::t "&nbsp;- $clock" }
                            }
                        }
                    }
                    if { [$::lexxCommand config -snapshot] == "" } {
                        set bold "color:#44DD88;font-weight: bold"
                    } else {
                        set bold "color:#555555"
                    }
                    html::tr -id "" -onclick "setShnapShot(this)" {
                        html::td -style "cursor: pointer;$bold" {
                           html::div { html::t "&nbsp;- [translate "Last"]" }
                        }
                    }
                    html::tr { html::td -height 4 }
                }
            }
            html::div -class snapDown { 
                html::img -src [session::url /img4/clock-later.png] { html::t  "" }            
            }
        }
    }
}

##############################################################################
# 
proc waitBox {} {

    html::div -id ajxlod {
        html::div -id loaico -class ajximg {
            html::span { html::img -src [session::url /img4/ajax-loader.gif] }
        }
        html::div -id tohide -class boxhide
    }
}

##############################################################################
# 
proc waitBoxXXL {} {

    html::div -id ajxlodXXL {
        html::div -id loaicoXXL -class ajximg {
            html::span { html::img -src [session::url /img4/ajax-loader.gif] }
        }
        html::div -id tohideXXL -class boxhide
    }
}

##############################################################################
# create a help box for ressouces

proc hintHowToNew { type { visibility "visible" } } {

    set msg  ""
    set umsg ""
    
    if { $type == "Volume" } {
        set msg [translate "Volumes are created automatically during labeling. To label new volumes, please navigate to the Storage-Manager or Standalone-Tape-Drive setup."]
    } elseif { $type == "Workstation" } {
        set msg [translate "Workstations entries are created automatically when a desktop or laptop computer is installed and configured."]
    } elseif { $type == "Jukebox" } {
        set msg1 [translate "Click <b>New Disk Storage</b> on the bottom left, to add a P5 managed disk storage."]
        set msg2 [translate "Click <b>New Tape Library</b> on the bottom left, to add a tape library."]
        set umsg "<ul><li style='list-style-type:disc'>$msg1</li><li style='list-style-type:disc'>$msg2</li></ul>"
    } elseif { $type == "Device" } {
        set msg1 [translate "Click <b>New Tape Drive</b> on the bottom left, to add a standalone tape drive."]
        set msg2 [translate "Click <b>New Removable Disk</b> on the bottom left, to add a removable disk drive."]
        set umsg "<ul><li style='list-style-type:disc'>$msg1</li><li style='list-style-type:disc'>$msg2</li></ul>"
    } elseif { $type == "BackupTask" } {
        set msg [translate "No backup plan configured or enabled."]
    } elseif { $type == "SyncTask" } {
        set msg [translate "No synchronize plan configured or enabled."]
    } elseif { $type == "ArchiveTask" } {
        set msg [translate "No archive plan configured."]
    } elseif { $type == "SyncPlan" } {
        set msg [translate "To create your first synchronize plan, click <b>New</b> on the bottom left, or use the <b>Setup Assistant</b>."]
    } elseif { $type == "ArchivePlan" } {
        set button "<b>[translate "New"]</b>"
        set msg [translate "To create your first archive plan, click <b>New</b> on the bottom left, or use the <b>Setup Assistant</b>."]
    } elseif { $type == "Backup2Go" } {
        set msg [translate "No workstation configured or enabled."]
    } elseif { $type == "BackupPlan" } {
        set button "<b>[translate "New"]</b>"
        set msg [translate "To create your first backup plan, click <b>New</b> on the bottom left, or use the <b>Setup Assistant</b>."]
    } elseif { $type == "License" } {
        set msg1 [translate "Click <b>Add manually</b> on the bottom left, to add a license."]
        set msg2 [translate "Click <b>Get Trial License</b> to request a trial license."]
        set msg3 [translate "Click <b>Archiware Portal</b> to register a license."]
        set umsg "<ul><li style='list-style-type:disc'>$msg2</li><li style='list-style-type:disc'>$msg3</li><li style='list-style-type:disc'>$msg1</li></ul>"
    } elseif { $type == "ObjectStore" } {
        set msg1 [translate "Click <b>New Service</b> - to start manual configuration of a cloud service."]
        set msg2 [translate "Click <b>Add Cloud Storage</b> - to use a setup assistant to create a fully-configured cloud storage."]
        set umsg "<ul><li style='list-style-type:disc'>$msg1</li><li style='list-style-type:disc'>$msg2</li></ul>"
    } else {
        set but "<b>[translate "New"]</b>"
        set msg [translate "Click $but on the bottom left."]
    }
    
    if { $type ne "Storagemanager" } {
    html::div -id "hintHowToNewBox" -align center -style "position: absolute;width:100%;top:35%;visibility:$visibility" {
        html::table -class hintBox -border "0" -cellpadding "2" -cellspacing "0" {
            html::tr {
                html::td {
                    html::div -class hintBoxMain {
                    html::table -border "0" -cellpadding "0" -cellspacing "0" {
                        html::tr {
                            html::td -align left -valign top { html::img -src [session::url /img4/infobubble_32.png] { html::t  "" } }
                            if { $umsg != ""} { 
                                html::td -align left { html::div -class hintTxt -style "padding-left:25px;padding-top:5px;min-width: 300px;max-width: 550px;" { html::t $umsg } }
                            } else {
                                html::td -align left { html::div -class hintTxt -style "padding-left:10px;padding-top:5px;min-width: 300px;max-width: 550px;" { html::t $msg } }
                            }
                        }
                    }
                    }
                }
            }
        }
    }}
}

##############################################################################

proc logform { message pageErrorMsg } {

    regsub -all {\"} $message {'} message
    regsub -all {\"} $pageErrorMsg {'} pageErrorMsg
    html::form  -method post -name errorForm {
        html::input -type hidden -name message      -value $message
        html::input -type hidden -name pageErrorMsg -value $pageErrorMsg
    }
}

##############################################################################

proc logformOld { message pageErrorMsg } {

    regsub -all {\"} $message {'} message
    html::div -id "dialog-modal" -title "Notice" -style "display: none; white-space: pre-line;" { 
        html::t $message
    }
    html::form  -method post -name infoForm {
        html::input -type hidden -name button_ok -value [translate "OK"]
        if { $message != "" }  {
            html::input -type hidden -name isMsg -value true
        } else {
            html::input -type hidden -name isMsg -value false
        }
    }
    regsub -all {\"} $pageErrorMsg {'} pageErrorMsg
    html::form  -method post -name errorForm {
        html::input -type hidden -name message      -value $message
        html::input -type hidden -name pageErrorMsg -value $pageErrorMsg
    }
}

##############################################################################

proc msgform {} {

    html::form -method post  -name msgForm  {
        html::input -type hidden -name jsmsg1  -value [translate "Please select an element from the list."]
        html::input -type hidden -name jsmsg2  -value [translate "Please select only one element."]
        html::input -type hidden -name jsmsg3  -value [translate "Browser does not support this function."]
        html::input -type hidden -name jsmsg4  -value [translate "Please enter a resource name or description."]
        html::input -type hidden -name jsmsg7  -value [translate "The following character are not valid for a Unix Path. \"\'<>\|\\"]
        html::input -type hidden -name jsmsg8  -value [translate "Path must be in absolute form (e.g. /data/raid1)."]
        html::input -type hidden -name jsmsg9  -value [translate "Not authorized for this operation."]
        html::input -type hidden -name jsmsg10 -value [translate "No Application for this type of element."]
        html::input -type hidden -name jsmsg11 -value [translate "Please select an element from the list."]
        html::input -type hidden -name jsmsg12 -value [translate "Put selected elements in basket."]
        html::input -type hidden -name jsmsg13 -value [translate "Remove all elements from basket?"]
        html::input -type hidden -name jsmsg14 -value [translate "Remove selected element(s) from basket?"]
        html::input -type hidden -name jsmsg15 -value [translate "Download selected element(s)?"]
        html::input -type hidden -name jsmsg16 -value [translate "Delete element?"]
        html::input -type hidden -name jsmsg17 -value [translate "It is not possible to pop up a new message window. Your browser is probably configured not to allow pop-ups or there is an active spam blocker intercepting the message."]
        html::input -type hidden -name jsmsg18 -value [translate "Please select one or more elements."]
        html::input -type hidden -name jsmsg19 -value [translate "Quit Session?"]
        html::input -type hidden -name jsmsg20 -value [translate "Invalid value. Please enter a number."]
        html::input -type hidden -name jsmsg21 -value [translate "Plan is disabled and will not be started."]
        html::input -type hidden -name jsmsg23 -value [translate "Restore selected files or folders?"]
        html::input -type hidden -name jsmsg24 -value [translate "Restore started in background."]
        html::input -type hidden -name jsmsg25 -value [translate "The backup server may not exist or it is not operational at this time. Please check the backup server name or IP address and your network connection and try again."]
        html::input -type hidden -name jsmsg26 -value [translate "Connection refused. Please check the backup server name, IP address or port number and try again."]
        html::input -type hidden -name jsmsg27 -value [translate "Get file listing ..."]
        html::input -type hidden -name jsmsg28 -value [translate "Lost connection to local web server."]
        html::input -type hidden -name jsmsg29 -value [translate "Please enter a DNS Name or TCP/IP Address."]
        html::input -type hidden -name jsmsg30 -value [translate "Lost connection to P5 server."]
        html::input -type hidden -name jsmsg31 -value [translate "Enable selected items?"]
        html::input -type hidden -name jsmsg32 -value [translate "Disable selected items?"]
        html::input -type hidden -name jsmsg33 -value [translate "To import the license(s) please select the license file *.tsv."]
        html::input -type hidden -name jsmsg34 -value [translate "Do you really want to update all selected elements?"]
        html::input -type hidden -name jsmsg40 -value [translate "Please select only files. Versions on folders are not supported."]
    	html::input -type hidden -name jsmsg101 -value [translate "Invalid resource name. Only the following characters should be used: A to Z, a to z, 0 to 9 and -,_"]
        html::input -type hidden -name jsmsg102 -value [translate "Please select folders only. Modifications to files are not supported."]
    }
}

##############################################################################
