Ext.define('P5Index.view.SelectionWindowController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.selectionwindow',
    
    init: function() {
        var vm = this.getViewModel();
        
        // Konfiguration basierend auf treeType und dboper
        if (dboper === 'Archive') {
            vm.set('windowTitle', $$('Archive Selections'));
            vm.set('actionButton', $$('Archive'));
            vm.set('actionButtonAll', $$('Archive all'));
            vm.set('operation', 'selection_archive');
        } else if (dboper === 'Restore') {
            vm.set('windowTitle', $$('Restore Selections'));
            vm.set('actionButton', $$('Restore'));
            vm.set('actionButtonAll', $$('Restore all'));
            vm.set('operation', 'selection_restore');
        }
        
        vm.set('treeType', treeType);
        
        this.loadBasketList();
    },

    // Laden der gespeicherten Baskets
    loadBasketList: function() {
        var me = this;
        var combo = this.lookupReference('basketListCombo');
        var store = this.getViewModel().getStore('basketListStore');
        
        store.on('load', function(store, records) {
            if (records.length > 0) {
                combo.select(records[0]);
            }
        }, this, {single: true});
        
        store.load();
    },
    
    // Event-Handler für geladene Selektionen
    onBasketListLoaded: function(store, records) {
        console.log("onBasketListLoaded Event:", records.length, "Einträge");
    },
    
    // Handler für die Auswahl einer gespeicherten Auswahl
    onBasketListSelection: function(combo, value) {
        if (!value) return;
        
        var record = combo.getSelectedRecord();
        if (record) {
            var id = record.get('id');
            
            var store = this.getViewModel().getStore('basketContentStore');
            store.getProxy().setExtraParam('basketID', id);
            store.load();
        }
    },
    
    // Event-Handler für geladenen Selektionsinhalt
    onBasketContentLoaded: function(store, records, success, operation) {
        console.log("Selection content loaded:", records.length, "Einträge");
    },
    
    // Handler für das Hinzufügen einer leeren Auswahl
    onAddEmptySelection: function() {
        var selectionStore = this.getViewModel().getStore('basketContentStore');
        selectionStore.loadData([], false);
        
        selectionStore.getProxy().setExtraParam('basketID', '');
        var combo = this.lookupReference('basketListCombo');
        combo.reset();
    },
    
    // Handler für das Löschen einer Auswahl
    onDeleteSelection: function() {
        var combo = this.lookupReference('basketListCombo');
        var id = combo.getValue();
        
        if (id) {
            var record = combo.getSelectedRecord();
            var basketID = record.get('id');
            
            var selectionStore = this.getViewModel().getStore('basketContentStore');
            selectionStore.load({
                params: {
                    caller: 'ajaxGetBasketContent',
                    procedure: 'deleteBasket',
                    basketID: basketID
                }
            });
            
            selectionStore.loadData([], false);
            selectionStore.getProxy().setExtraParam('basketID', '');
            combo.reset();
        }
    },
    
    // Handler für das Entfernen von Elementen aus dem Basket
    outBasket: function() {
        var grid = this.lookupReference('selectionGrid');
        var numberElements = 0;
        var selectedelements = [];
        var selection = grid.getSelectionModel().getSelection();
        
        Ext.iterate(selection, function(obj, index) {
            var elm = obj.get('id');
            selectedelements.push(elm);
            numberElements++;
        });
        
        if (numberElements === 0) {
            alert(document.msgForm.jsmsg1.value);
            return 0;
        }
        
        var store = this.getViewModel().getStore('basketContentStore');
        store.load({
            params: {
                caller: 'ajaxGetBasketContent',
                procedure: 'outBasket',
                selectedelements: Ext.encode(selectedelements)
            }
        });
    },
    
    // Handler für das Hinzufügen von Elementen zum Basket (wird von außen aufgerufen)
    inBasket: function() {
        getSelctedIndexItems();
        
        if (numberElements === 0) {
            alert(document.msgForm.jsmsg1.value);
            return 0;
        }
        
        var store = this.getViewModel().getStore('basketContentStore');
        store.load({
            params: {
                caller: 'ajaxGetBasketContent',
                procedure: 'inBasket',
                selectedelements: Ext.encode(selectedelements)
            }
        });
        
        this.getView().show();
    },
    
    // Handler für die Ausführung der Aktion (Archiv oder Restore)
    onExecuteAction: function() {
        var vm = this.getViewModel();
        var combo = this.lookupReference('basketListCombo');
        var id = combo.getValue();
        if (id) {
            var record = combo.getSelectedRecord();
            var basketID = record.get('id');
            console.log(basketID)
            document.windowForm.basketID.value = basketID;
            this.doSelection(vm.get('treeType'), vm.get('operation'));
        }
    },

    onExecuteActionAll: function() {
        var vm = this.getViewModel();
        document.windowForm.basketID.value = '';
        this.doSelection(vm.get('treeType'), vm.get('operation'));
    },
    
    // Implementierung von doSelection
    doSelection: function(elementType, aktion) {
        var win = window.open("", client[elementType][aktion].target, client[elementType][aktion].wsize);
        win.focus();
        winOpenClose(win);
        document.windowForm.action = document.urls.elements[aktion].value;
        document.windowForm.elementCall.value = aktion;
        document.windowForm.target = client[elementType][aktion].target;
        document.windowForm.submit();
    }
});