Ext.define('P5Index.view.PathImportGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'mvvm-pathimportgrid',
    reference: 'pathMediaGrid',
    
    disableSelection: true,
    border: false,
    
    viewConfig: {
        markDirty: false,
        emptyText: '<div class="path-drop-zone-enhanced">' +
           '<div class="drop-content">' +
           '<i class="fa fa-upload drop-icon"></i>' +
           '<div class="drop-text-primary">' + $$('Drop files here to import') + '</div>' +
           '<div class="drop-text-secondary">' + 
                $$('Project files') + ': OTIO, FCPXML, EDL, ALE<br/>' +
                $$('Path lists') + ': TSV, TXT, LOG' +
           '</div>' +
           '</div>' +
           '</div>',
        deferEmptyText: false,
        // Row-Klassen basierend auf Record-Daten
        getRowClass: function(record) {
            var foundCount = record.get('foundVersionCount') || 0;
            if (foundCount === 0) {
                return 'no-row-expansion';
            }
            return '';
        }
    },

    bind: {
        store: '{pathProjectStore}'  // Projekt-Store statt Media-Store
    },

    // RowWidget Plugin für Archive-Details
    plugins: [{
        ptype: 'rowwidget',
        widget: {
            xtype: 'grid',
            cls: 'archive-versions-grid',
            margin: '0 0 0 0',
            bodyStyle: 'border-width: 1px 1px 0px 1px;',
            viewConfig: {
                stripeRows: false,
                trackOver: false,
                markDirty: false
            },
            bind: {
                store: '{record.archiveVersionsStore}'
            },
            listeners: {
                cellclick: 'onArchiveCellClick'
            },
            columns: [{
                dataIndex: 'selected',
                width: 40,
                xtype: 'checkcolumn',
                renderer: function(value, metaData, record) {
                    if (record.get('ranking') === 0) {
                        metaData.tdCls = 'x-item-disabled';
                        return '<div style="opacity: 0.3;"><input type="checkbox" disabled></div>';
                    }
                    return this.defaultRenderer.apply(this, arguments);
                },
                listeners: {
                    checkchange: 'onArchiveVersionCheckChange'
                }
            }, {
                text: $$('Archive time'), 
                dataIndex: 'atime',
                width: 120,
                renderer: eval('renderDate')
            }, {
                text: $$('Size'), 
                dataIndex: 'size',
                width: 80,
                renderer: eval('calcSizeIdx')
            }, {
                text: $$('Name'),
                dataIndex: 'foundFileName', 
                flex: 2,
                renderer: function(value, metaData, record) {
                    if (!value || value == '') {
                        return '<span style="color: red;">Not found in archive</span>';
                    }
                    var originalName = record.get('fileName');
                    var displayName  = value || originalName;
                    var isDirectory  = record.get('isDirectory');
                    
                    if (!displayName) return '';
    
                    var controller = this.up('window').getController();
                    
                    // Aufteilen in Base und Extension
                    var origBase = controller.getBaseName(originalName);
                    var origExt = controller.getExtension(originalName);
                    var foundBase = controller.getBaseName(displayName);
                    var foundExt = controller.getExtension(displayName);
                    
                    // Farben bestimmen
                    var baseColor = (origBase === foundBase) ? '#008000' : '#ff8c00';
                    var extColor = (origExt === foundExt) ? '#008000' : '#ff8c00';
                    
                    var icon = isDirectory ? 
                        '<i class="fa fa-folder" style="color: ' + baseColor + ';margin-right: 6px;"></i>' :
                        '';

                    // Spans mit data-action
                    var linkHtml = '<a href="javascript:void(0)" data-action="show-file-details">' + icon + 
                                '<span style="color: ' + baseColor + '; cursor: pointer;" data-action="show-file-details">' + 
                                Ext.String.htmlEncode(foundBase) + '</span>';
                    
                    if (foundExt) {
                        linkHtml += '<span style="color: ' + extColor + '; cursor: pointer;" data-action="show-file-details">.' + 
                                Ext.String.htmlEncode(foundExt) + '</span>';
                    }
                    
                    linkHtml += '</a>';
                    
                    return linkHtml;
                }
            }, {
                text: $$('Archive Location'),
                dataIndex: 'archiveLocation', 
                flex: 2,
                renderer: function(value, metaData, record) {
                    if (!value) return '';
                    
                    var archiveLocation = value;
                    var relativePath = record.get('relativePath');
                    var displayText = archiveLocation;
                    
                    // Color-Coding für den Display-Text
                    if (relativePath && archiveLocation.includes(relativePath)) {
                        var matchIndex = archiveLocation.indexOf(relativePath);
                        var beforeMatch = archiveLocation.substring(0, matchIndex);
                        displayText = beforeMatch + '<span style="color: #008000;" data-action="open-tree-browser">' + relativePath + '</span>';
                    }
                    
                    var linkHtml = '<a href="javascript:void(0)" ' +
                                'style="color: inherit;" ' +
                                'data-action="open-tree-browser" ' +
                                'data-path="' + Ext.String.htmlEncode(value) + '">' +
                                displayText + '</a>';
                                    
                    // Tooltip behalten
                    var segments = value.split('/').filter(function(seg) { return seg.length > 0; });
                    var hierarchicalPath = '';
                    segments.forEach(function(segment, index) {
                        var indent = '&nbsp;'.repeat(index * 4);
                        hierarchicalPath += indent + '└─ ' + Ext.String.htmlEncode(segment) + '<br/>';
                    });
                    
                    metaData.tdAttr = 'data-qtip="Click to open in Tree Browser<br/><br/>' + 
                                    '<div style=\'font-family: monospace; line-height: 1.4;\'>' + 
                                    hierarchicalPath + '</div>"';

                                        
                    return linkHtml;
                }          
            }]
        }
    }],

    // Main grid columns
    columns: [{
        text: $$('File'),
        dataIndex: 'fileName',
        flex: 1,
            renderer: function(value, metaData, record) {
            var originalPath = record.get('originalPath');
            if (originalPath) {
                metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(originalPath) + '"';
            }
            return value;
        }
    }, {
        text: $$('Used'),
        width: 100,
        dataIndex: 'usedDurationTC',
        bind: {
            hidden: '{!showUsedDurationTC}'
        },
        renderer: function(value, metaData, record) {
            var usedDuration = record.get('usedDurationTC');
            if (!usedDuration || usedDuration === '') {
                return '<span style="color: #666;">Full clip</span>';
            }
            return '<span style="font-family: monospace;">' + usedDuration + '</span>';
        }
    }, {
        text: $$('Available'), 
        dataIndex: 'availableDurationTC',
        width: 100,
        bind: {
            hidden: '{!showAvailableDurationTC}'
        },
        renderer: function(value) {
            return '<span style="font-family: monospace;">' + (value || '--:--:--:--') + '</span>';
        }
    }, {
        text: $$('Archive Status'),
        width: 120,
        renderer: function(value, metaData, record) {
            var foundCount = record.get('foundVersionCount') || 0;
            
            if (foundCount === 0) {
                return '<span style="color: red;"><i class="fa fa-times-circle"></i> Not found</span>';
            } else if (foundCount === 1) {
                return '<span style="color: green;"><i class="fa fa-check-circle"></i> ' + foundCount + ' version</span>';
            } else {
                return '<span style="color: green;"><i class="fa fa-clone"></i> ' + foundCount + ' versions</span>';
            }
        }
    }],

    listeners: {
        selectionchange: 'onProjectSelectionChange'
    },

    // CSS für Path-Import-Styling + RowWidget
    html: '<style>' +
        '.archive-versions-grid .x-grid-header {' +
        '  background: #f8f8f8;' +
        '  border-bottom: 1px solid #ddd;' +
        '}' +
        '.archive-versions-grid .x-grid-body {' +
        '  background: #fafafa;' +
        '}' +
        '.archive-versions-grid .x-grid-row {' +
        '  border-bottom: 1px solid #eee;' +
        '}' +
        '.path-drop-zone-enhanced {' +
        '  height: 300px;' +
        '  display: flex;' +
        '  align-items: center;' +
        '  justify-content: center;' +
        '  border: 2px dashed #ccc;' +
        '  border-radius: 8px;' +
        '  background-color: #fafafa;' +
        '  margin: 20px;' +
        '}' +
        '.drop-content {' +
        '  text-align: center;' +
        '}' +
        '.drop-icon {' +
        '  font-size: 24px;' +
        '  color: #999;' +
        '  margin-bottom: 15px;' +
        '}' +
        '.drop-text-primary {' +
        '  font-size: 14px;' +
        '  font-weight: bold;' +
        '  color: #666;' +
        '  margin-bottom: 5px;' +
        '}' +
        '.drop-text-secondary {' +
        '  font-size: 12px;' +
        '  color: #999;' +
        '}' +
        '.path-drop-zone-enhanced:hover {' +
        '  border-color: #007acc;' +
        '  background-color: #f0f8ff;' +
        '}' +
        '.no-row-expansion .x-grid-row-expander {' +
        ' opacity: 0.4;' +
        ' pointer-events: none;' +
        '}' +
    '</style>'
});
Ext.tip.QuickTipManager.init();
Ext.apply(Ext.tip.QuickTipManager.getQuickTip(), {
    dismissDelay: 0,      // Kein automatisches Ausblenden
    hideDelay: 0,       // Verzögerung beim Mouse-Leave
    showDelay: 500        // Schnelleres Einblenden
});