Ext.define('P5Index.view.ParserLogWindowController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.parserlogwindow',
    
    init: function() {
        // Client Logs laden
        var parserLogs = P5Index.util.ParserLogger.getFormattedLogs();
        this.lookupReference('clientLogArea').setValue(parserLogs);
        
        // Server Log Grid ist bereits via Binding verbunden!
    },
    
    onViewServerLog: function(grid, rowIndex) {
        var record = grid.getStore().getAt(rowIndex);
        var logs = record.get('serverLogs');
        
        if (!logs || logs.length === 0) {
            Ext.toast('No logs available');
            return;
        }
        
        //var logText = logs.join('\n');
        
        Ext.create('Ext.window.Window', {
            title: $$('Server Log') + ': ' + record.get('fileName'),
            width: 700,
            height: 500,
            layout: 'fit',
            modal: true,
            items: [{
                xtype: 'textarea',
                value: logs,
                readOnly: true,
                style: {
                    fontFamily: 'monospace',
                    fontSize: '12px',
                    backgroundColor: '#f4f4f4'
                }
            }],
            buttons: [{
                text: $$('Copy to Clipboard'),
                handler: function() {
                    var textarea = this.up('window').down('textarea');
                    textarea.selectText();
                    document.execCommand('copy');
                    Ext.toast('Server log copied to clipboard');
                }
            }, {
                text: $$('Close'),
                handler: function() {
                    this.up('window').close();
                }
            }]
        }).show();
    },
    
    onExportLogs: function() {
        var clientLogs = this.lookupReference('clientLogArea').getValue();
        var serverGrid = this.lookupReference('serverLogGrid');
        
        var exportText = "=== PARSING AND SEARCHING DETAILS ===\n";
        exportText += "Generated: " + new Date().toLocaleString() + "\n\n";
        
        exportText += "=== CLIENT PARSING LOG ===\n";
        exportText += clientLogs + "\n\n";
        
        exportText += "=== SERVER SEARCH LOGS ===\n";
        serverGrid.getStore().each(function(record) {
            exportText += "\n--- " + record.get('fileName') + " ---\n";
            exportText += "Found: " + record.get('foundCount') + " versions\n";
            exportText += "Query: " + record.get('searchQuery') + "\n";
            exportText += "Mode: " + record.get('searchMode') + "\n";
            
            var logs = record.get('serverLogs');
            if (logs && logs.length > 0) {
                exportText += "Logs:\n" + logs + "\n";
            }
        });
        
        // Download als Datei
        var blob = new Blob([exportText], {type: 'text/plain'});
        var url = URL.createObjectURL(blob);
        var a = document.createElement('a');
        a.href = url;
        a.download = 'media-recovery-log-' + Ext.Date.format(new Date(), 'Y-m-d-His') + '.txt';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
        
        Ext.toast('Log exported');
    },
    
    onClose: function() {
        this.getView().close();
    }
});