var periods = Ext.create('Ext.data.Store', {
    fields: ['id','name'],
    data: [
        {id:'12hour', 'name':'Last 12 hour'},
        {id:'today', 'name':'Today'},
        {id:'yesterday', 'name':'Yesterday'},
        {id:'pastweek', 'name':'Past week'},
        {id:'threemonth', 'name':'Past three months'},
        {id:'enterDate', 'name':'Enter period'}
    ]
});
var jobtyps = Ext.create('Ext.data.Store', {
    fields: ['id','name'],
    data: [
        {id:'any', 'name':'Any'},
        {id:'ArchiveJobGroup', 'name':'Archive'},
        {id:'BackupJobGroup', 'name':'Backup'},
        {id:'WorkstationBackupJobGroup', 'name':'Backup2Go'},
        {id:'SyncJobGroup', 'name':'Host Sync'},
        {id:'ObjectSyncJobGroup', 'name':'Cloud Sync'},
        {id:'MigrationJobGroup', 'name':'Migration'},
        {id:'QueryJobGroup', 'name':'Query'},
        {id:'RestoreJobGroup', 'name':'Restore/Verify'},
        {id:'Others', 'name':'Others'},
        {id:'Search', 'name':'Search'}
    ]
});
var results = Ext.create('Ext.data.Store', {
    fields: ['id','name'],
    data: [
        {id:'any', 'name':'Any'},
        {id:'completed', 'name':'Completed'},
        {id:'warning', 'name':'Warning'},
        {id:'break', 'name':'Interrupted'},
        {id:'error', 'name':'Error'}
    ]
});
Ext.define('P5Jobhistory.view.ConfigRegion', {
    extend: 'Ext.form.Panel',
    xtype: 'configregion',
    
    cls: 'configregion-panel',
    bodyStyle:{"background-color":"#576170"}, 

    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    
    items: [{
        xtype: 'container',
        html: $$('Job Log Query'),
        margin: '10 0 0 10'
    },{
        xtype: 'periodgrid',
        cls: 'filter-grid',
        reference: 'periodgrid_ref',
        itemId: 'periodgrid_id',
        margin: '0 0 0 15',
        border: false,
    },{
        xtype: 'fieldcontainer',
        bind:{
            hidden: '{enterDateHidden}',
        },            
        margin: '0 0 0 45',
        layout: 'vbox',
        items: [{
            xtype: 'datefield',
            format: Ext.Date.patterns['formatDateInt'],
            itemId: 'fromDate_id',
            emptyText: $$('from date ...'),    
            hideLabel: true,
            width: 120
        },{
            xtype: 'datefield',
            format: Ext.Date.patterns['formatDateInt'],
            itemId: 'toDate_id',
            emptyText: $$('to date ...'),    
            hideLabel: true,
            width: 120
        }]
    },{
        xtype: 'container',
        html: $$('Result'),
        margin: '10 0 0 10'
    },{
        xtype: 'resultgrid',
        cls: 'filter-grid',
        reference: 'resultgrid_ref',
        itemId: 'resultgrid_id',
        margin: '0 0 0 15',
        border: false,
    },{
        xtype: 'container',
        html: $$('Type'),
        margin: '10 0 0 10'
    },{
        xtype: 'jobtypegrid',
        cls: 'filter-grid',
        reference: 'jobtypegrid_ref',
        itemId: 'jobtypegrid_id',
        margin: '0 0 0 15',
        border: false,
    },{
        xtype: 'fieldcontainer',
        bind:{
            hidden: '{enterDescriptionHidden}',
        },            
        margin: '0 0 0 45',
        layout: 'vbox',
        items: [{
            xtype: 'textfield',
            itemId: 'description_id',
            hideLabel: true,
            width: 140
        }]
    },{
        xtype: 'container',
        html: $$('Client'),
        margin: '10 0 0 10'
    },{
        xtype: 'clientgrid',
        cls: 'filter-grid',
        reference: 'clientgrid_ref',
        itemId: 'clientgrid_id',
        margin: '0 0 0 15',
        flex: 1,
        border: false,
    }]
});

Ext.define('P5Jobhistory.view.PeriodGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'periodgrid',

    bodyStyle:{"background-color":"#576170"}, 
    
    store: periods,
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});
Ext.define('P5Jobhistory.view.ResultGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'resultgrid',

    bodyStyle:{"background-color":"#576170"}, 
    
    store: results,
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});
Ext.define('P5Jobhistory.view.JobTypeGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'jobtypegrid',

    bodyStyle:{"background-color":"#576170"}, 
    
    store: jobtyps,
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});
Ext.define('P5Jobhistory.view.ClientGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'clientgrid',

    bind:{
        store: '{clientstore}'
    },
    
    selModel: {
        selType: 'checkboxmodel',
        mode: 'SINGLE',
        allowDeselect: false
    },

    headerBorders: false,
    hideHeaders: true,
    rowLines: false,
    border: false,

    columns: [{
        dataIndex: 'name',
        text: $$('Name'),
        flex: 1,
        tdCls: 'vd-multiline-row'
    }]
});