Ext.define('Dashboard.view.widget.BackupOverview', {
    extend: 'Ext.grid.Panel',
    xtype: 'backup-overview-widget',
    
    requires: [
        'Dashboard.view.widget.BackupOverviewController',
        'Dashboard.view.widget.BackupOverviewModel'
    ],
    
    controller: 'backup-overview-widget',
    viewModel: {
        type: 'backup-overview-widget'
    },
    
    bind: {
        store: '{backupOverview}'
    },
        
    columns: [{
        text: $$('Plan'),
        dataIndex: 'backupPlan',
        width: 80,
        renderer: function(value, meta, record) {
            return '<a href="javascript:void(0)" class="startd" data-action="view-plan" data-name="' + 
                   record.get('plan') + '">' + value + '</a>';
        }
    }, {
        text: $$('Last Run'),
        dataIndex: 'statusText',
        flex: 1,
        renderer: function(value, meta, record) {
            var statusClass = record.get('statusClass');
            var jobId = record.get('jobId');
            var iconHtml = '';
            
            // Font Awesome Icon basierend auf Status
            switch(statusClass) {
                case 'running':
                    iconHtml = '<i class="fas fa-circle-notch fa-spin" style="color:#0088FF;"></i> ';
                    break;
                case 'finished':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'error':
                    iconHtml = '<i class="fas fa-circle" style="color:#FF3300;"></i> ';
                    break;
                case 'warning':
                case 'cancelled':
                    iconHtml = '<i class="fas fa-exclamation-triangle" style="color:#FF9900;"></i> ';
                    break;
                case 'never':
                    iconHtml = '<i class="fas fa-question-circle" style="color:#FFCC00;"></i> ';
                    break;
                default:
                    iconHtml = '<i class="fas fa-circle" style="color:#CCCCCC;"></i> ';
            }
            
            var html = iconHtml;
            
            if (jobId) {
                html += '<a href="javascript:void(0)" class="startd" ' +
                       'data-action="view-job" data-jobid="' + jobId + '">' + value + '</a>';
            } else {
                html += '<span>' + value + '</span>';
            }

            if (record.get('dataSize') > 0) {
                html += ' (' + CalcSize(record.get('dataSize')) + ')';
            }
            
            return html;
        }
    }, {
        text: $$('Last Successful'),
        dataIndex: 'lastSuccessText',
        width: 80,
        renderer: function(value, meta, record) {
            var lastSuccessClass = record.get('lastSuccessClass');
            var jobId = record.get('lastSuccessJobId');
            var iconHtml = '';
            
            // Font Awesome Icon basierend auf Status
            switch(lastSuccessClass) {
                case 'success':
                    iconHtml = '<i class="fas fa-check-circle" style="color:#66CC00;"></i> ';
                    break;
                case 'warning':
                    iconHtml = '<i class="fas fa-exclamation-triangle" style="color:#FF9900;"></i> ';
                    break;
                case 'old':
                    iconHtml = '<i class="fas fa-clock" style="color:#FF9900;"></i> ';
                    break;
                case 'never':
                    iconHtml = '<i class="fas fa-question-circle" style="color:#FFCC00;"></i> ';
                    break;
                default:
                    iconHtml = '<i class="fas fa-circle" style="color:#CCCCCC;"></i> ';
            }
            
            var html = iconHtml;
            
            if (jobId) {
                html += '<a href="javascript:void(0)" class="startd" ' +
                       'data-action="view-job" data-jobid="' + jobId + '">' + value + '</a>';
            } else {
                html += '<span>' + value + '</span>';
            }
            
            if (record.get('lastSuccessDataSize') > 0) {
                html += ' (' + CalcSize(record.get('lastSuccessDataSize')) + ')';
            }

            return html;
        }
    }, {
        text: $$('Next Run'),
        dataIndex: 'nextRun',
        width: 80
    }, {
        text: $$('Pool'),
        dataIndex: 'pool',
        flex: 1,
        renderer: function(value) {
            if (!value) return '';
            
            return '<a href="javascript:void(0)" class="startd" data-action="view-pool" ' + 
                   'data-name="' + value + '">' + value + '</a>';
        }
    }, {
        text: $$('Next Pool'),
        dataIndex: 'eventPools',
        flex: 1,
        renderer: function(value) {
            if (!value || !value.length) return '';
            
            var firstPool = value[0];
            var html = '<a href="javascript:void(0)" class="startd" data-action="view-pool" ' + 
                      'data-name="' + firstPool + '">' + firstPool + '</a>';
            
            if (value.length > 1) {
                html += ' <span class="more-pools">(+' + (value.length - 1) + ' more)</span>';
            }
            
            return html;
        }
    }, {
        text: $$('Backup Source'),
        dataIndex: 'dirlist',
        flex: 2,
        renderer: function(value) {
            if (!value || !value.length) return '';
            
            if (value.length === 1) {
                return value[0];
            }
            
            return value[0] + ' <span class="more-dirs">(+' + (value.length - 1) + ' more)</span>';
        }
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'top',
        items: [{
            xtype: 'image',
            src: 'img8/backup_32.png',
            width: 24,
            height: 24
       },'->',{
            xtype: 'segmentedbutton',
            stateful: true,
            stateId: 'backup-overview-period',
            stateEvents : ['toggle', 'pressed'],
            allowMultiple: false,
            items: [{
                text: $$('All'),
                value: 'all'
            }, {
                text: $$('Successful'),
                value: 'okay'
            }, {
                text: $$('Other'),
                value: 'other'
            }],
            listeners: {
                toggle: 'onPeriodChange'
            }
        }]
    }],
    
    listeners: {
        cellclick: 'onCellClick'
    }
});