Ext.define("Dashboard.model.SynchronizeStats", {
    extend: 'Ext.data.Model',
    fields: [{ 
        name: 'date', type: 'date' 
    },{
        name: 'dateShort',
        type: 'date',
        convert: function(v, record) {
            var value = record.get('date');
            return Ext.Date.format(new Date(value), 'M d');
        }
    },{
        name: 'durationMin', type: 'float'
    },{
        name: 'dataAmountKiB', type: 'float' 
    }],
    proxy:{
        type:'ajax',
        url: document.dashboardForm.startTdp.value,
        actionMethods:{
            read:'GET'
        },
        extraParams: {
            caller: 'ajaxSynchronizeStats',
            demoMode: localStorage.getItem('demoMode') === 'true'
        },
        reader:{
            type:'json',
            rootProperty:'data'
        }
    }
});
