//#############################################################################
//
//  rsrc.js
//
//    JavaScript Client Library
//
//    See the file "license.txt" for information on usage and
//    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
//
//#############################################################################

// this function is not used at the moment, because no lists are displayed
// for the search.
Ext.define('Fiddle.fbarlist', {
    override: 'Ext.grid.plugin.filterbar.filters.List',

    createOptionsStore: function () {
        var me = this,
            options = me.getOptions(),
            store = me.getGridStore();

        if (!options) {
            // no options provided so we need to extract them from the grid store
            // reuse the list created first
            if (me.filterlist === undefined || me.filterlist === null || me.filterlist.length === 0 ) {
                me.filterlist = Ext.Array.sort(store.collect(me.getDataIndex(), false, true));
            }
            options = me.filterlist;
        }

        if (this.store) {
            if (Ext.isString(this.store)) {
                options = Ext.StoreMgr.lookup(this.store);
            } else {
                options = this.store;
            }
        }

        return options;
    },
    getFieldConfig: function () {
        var config = this.callParent();

        if (this.store) {
            if (this.displayField) {
                config.displayField = this.displayField;
            }
            if (this.valueField) {
                config.valueField = this.valueField;
            }
        }

        config.store = this.createOptionsStore();

        return config;
    },
});

var p_paging_store = Ext.create('Ext.data.Store', {
    fields: ['value','name'],
    data: [[0,'-'],[5,'5'],[10,'10'],[20,'20'],[50,'50'],[100,'100'],[200,'200'],[500,'500'],[1000,'1000']]
});	
// read table head definition
Ext.define('colHead',{
    extend: 'Ext.data.Model',
    fields: [
        {name: 'tab',  type: 'string', defaultValue: ''},
        {name: 'text',  type: 'string', defaultValue: ''},
        {name: 'dataIndex',  type: 'string', defaultValue: ''},
        {name: 'dataType',  type: 'string', defaultValue: 'string'},
        {name: 'dateFormat',  type: 'string', defaultValue: 'U'},
        {name: 'sortable',  type: 'boolean', defaultValue: true},
        {name: 'width',  type: 'int', defaultValue: 80},
        {name: 'flex',  type: 'int', defaultValue: 0},
        {name: 'renderer',  type: 'string', defaultValue: ''},
        {name: 'align',  type: 'string', defaultValue: 'left'},
        {name: 'filter',  type: 'string', defaultValue: true},
        {name: 'menuDisabled',  type: 'boolean', defaultValue: false},
        {name: 'hidden',  type: 'boolean', defaultValue: false},
        {name: 'summaryType',  type: 'string', defaultValue: ''},
        {name: 'summaryRenderer',  type: 'string', defaultValue: ''}
    ]
});

Ext.onReady(function() {
    elementCount = '';

    startAppListing();
});

function startAppListing() {

    getData();

}

function getData() {

    browser_ressource = document.hammerForm.browser_ressource.value;

    // read data in XML format
    waitBox();
    Ext.Ajax.request({
        url: browser_ressource,
        method: 'POST',
        timeout: 90000,
        params: { 
            caller: 'ajax',
            layout: layout
        },
        scope: this,
        success:function(response, options) {
            hideWait();
            var xmldata = response.responseXML;
            doListing(xmldata);
        }
    });

}

function doListing(xmldata) {

    var layout    = Ext.DomQuery.selectValue('param > layout', xmldata);
    var rescount  = 0
    var introTab  = Ext.DomQuery.selectValue('param > introTab', xmldata);

    var resview = 'resview-'+layout
    var acttab  = resview+'-tab'

    // list of tabs  ***********************************************************

    Ext.define('m_tabs',{
        extend: 'Ext.data.Model',
        fields: [
            {name: 'tab',    type: 'string', defaultValue: ''},
            {name: 'resgroup', type: 'string', defaultValue: ''},
            {name: 'text',   type: 'string', defaultValue: ''},
            {name: 'filter', type: 'string', defaultValue: ''}
        ]
    });

    var store_tabs = new Ext.data.Store({
        storeId: 'store_tabs_id',
        model: 'm_tabs',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'panel'
            }
        }
    });

    var tabsCollect = store_tabs.collect('tab');
    // console.log(tabsCollect);

    // context menu ***********************************************************

    Ext.define('m_contextmenu',{
        extend: 'Ext.data.Model',
        fields: [
            {name: 'tab',  type: 'string', defaultValue: ''},
            {name: 'text', type: 'string', defaultValue: ''},
            {name: 'func', type: 'string', defaultValue: ''}
        ]
    });

    var store_contextmenu = new Ext.data.Store({
        model: 'm_contextmenu',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'contextmenu'
            }
        }
    });


    var menuContext = [];
    Ext.iterate(tabsCollect, function(key) { 
        var menus_attr = [];
        store_contextmenu.filter({
            property: 'tab',
            value: key,
            exactMatch: true,
            caseSensitive: true
        });
        store_contextmenu.each(function(record,id){         
            var menu_attr = {};
            var mtext = record.get('text');
            if ( mtext == '-' ) { 
                menu_attr['xtype'] = 'menuseparator';
            } else {
                menu_attr['text']    = mtext;
                menu_attr['func']    = record.get('func');
                menu_attr['handler'] = function(){eval(this.func);};
            }
            // add to column array
            menus_attr.push(menu_attr);
        });
        menuContext[key] = new Ext.menu.Menu({
            items: menus_attr
        });
    });

    // gear menu ***********************************************************

    var store_gearmenu = new Ext.data.Store({
        model: 'm_contextmenu',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'gearmenu'
            }
        }
    });


    var menuGear = [];
    Ext.iterate(tabsCollect, function(key) { 
        var menus_attr = [];
        store_gearmenu.filter({
            property: 'tab',
            value: key,
            exactMatch: true,
            caseSensitive: true
        });
        store_gearmenu.each(function(record,id){         
            var menu_attr = {};
            var mtext = record.get('text');
            if ( mtext == '-' ) { 
                menu_attr['xtype'] = 'menuseparator';
            } else {
                menu_attr['text']    = mtext;
                menu_attr['func']    = record.get('func');
                menu_attr['handler'] = function(){eval(this.func);};
            }
            // add to column array
            menus_attr.push(menu_attr);
        });
        menuGear[key] = new Ext.menu.Menu({
            items: menus_attr
        });
    });

    // bottom toolbar ***********************************************************

    var store_bottombar = new Ext.data.Store({
        model: 'm_contextmenu',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'bottombar'
            }
        }
    });
     
    var tabbuttons = [];
    Ext.iterate(tabsCollect, function(key) { 
        var tbar_attr = [{ xtype : 'tbspacer', width: 5 },{
            iconCls: 'x-fa fa-bars cogicon',
            width: 55, 
            listeners: {
                click: function(me, e, eOpts) {
                    e.stopEvent();
                    if (menuGear[key].items && menuGear[key].items.length > 0) menuGear[key].showAt(e.getXY());
                    return false;
                }          
            }
        }];
        store_bottombar.filter({
            property: 'tab',
            value: key,
            exactMatch: true,
            caseSensitive: true
        });
        store_bottombar.each(function(record,id){         
            var but_attr = {};
            var mtext = record.get('text');
            if ( mtext == '-' ) { 
                but_attr['xtype'] = 'tbfill';
            } else {
                but_attr['text']    = mtext;
                but_attr['func']    = record.get('func');
                but_attr['handler'] = function(obj,eve) {
                    var fn = window[this.func]
                    if ( typeof fn === 'function' ) {
                        fn(obj,eve);
                    } else {
                        eval(this.func)
                    }
                };
            }
            // add to column array
            tbar_attr.push(but_attr);
        });       
        tbar_attr.push({ xtype : 'tbspacer', width: 5 });
        tabbuttons[key] = tbar_attr;
    });
    
    // define and read column header
    //
    var gridHeaderStore = new Ext.data.Store({
        model: 'colHead',
        data: xmldata,
        proxy: {
            type: 'memory',
            reader: {
                type: 'xml',
                record: 'col'
            }
        }
    });
    

    var tabcols    = [];
    var cols_field = [];
    Ext.iterate(tabsCollect, function(key) {
        gridHeaderStore.filter({
            property: 'tab',
            value: key,
            exactMatch: true,
            caseSensitive: true
        });
        var cols_attr  = [];
        gridHeaderStore.each(function(record,id){         
            var col_attr = {};
            var col_field = {};
            if (!record.get('hidden')) {
                col_attr['stateId']  = 'state_id_' + record.get('dataIndex');
                col_attr['text'] = record.get('text');
                col_attr['dataIndex'] = record.get('dataIndex');
                col_attr['sortable']  = record.get('sortable');
                col_attr['width']     = record.get('width');
                col_attr['flex']      = record.get('flex');
                col_attr['renderer']  = eval(record.get('renderer'));
                col_attr['align']     = record.get('align');
                col_attr['menuDisabled']    = record.get('menuDisabled');
                col_attr['summaryType']     = window[record.get('summaryType')];
                col_attr['summaryRenderer'] = window[record.get('summaryRenderer')];
                if ( record.get('dataType') == 'date' ) {
                    col_attr['xtype']      = 'datecolumn';
                    col_attr['format']     = Ext.Date.patterns[confDateFormat];
                }
                // setup filter bar
                if ( record.get('filter') === "string" ) {
                    col_attr['filterType'] = {type: 'string'};
                } else if ( record.get('filter') == 'list' ) {
                    // The pop-up list is not loaded with all possible values during paging,
                    // which is why no combo box is displayed initially. The user must enter the value.                
                    col_attr['filterType'] = {type: 'string'};
                } else if ( record.get('filter') == 'date' ) {
                    col_attr['filterType'] = {
                        type: 'date',
                        fieldDefaults: {
                            xtype: 'datefield',
                            format: Ext.Date.patterns[confDateFormat]
                        }
                    };
                } else if (record.get('filter') == 'complex') {
                   col_attr['filterType'] = {
                        type: 'list',
                        options: [
                            ['higher_id', $$('with higher ID')],
                            ['lower_id', $$('with lower ID')]
                        ]
                    };
                }
                // add to column array
                cols_attr.push(col_attr);
            }
            // add to field array
            col_field['name'] = record.get('dataIndex');
            col_field['type'] = record.get('dataType');
            if ( col_field['type'] == 'date' ) {
                col_field['dateFormat'] = record.get('dateFormat');
            }
            cols_field.push(col_field);
        });
        
        tabcols[key] = cols_attr;
    
    });
 
    // read table body data
    //
    
    Ext.define('body',{
        extend: 'Ext.data.Model',
        fields: cols_field
    });

    Ext.define('Body.view.RsrcGrid', {
        extend: 'Ext.grid.Panel',
        alias:'widget.rsrcgrid',
        multiSelect: true,
        stateful: true,
        border: false,
        //plugins: 'gridfilters',
        plugins: {
            gridfilterbar: true
        },  
        initComponent: function() {
            var me = this;
    
            Ext.applyIf(me, {
                features: [{
                    ftype: 'summary'
                }],
                viewConfig: {
                }
            });    
            me.callParent(arguments);
        }
    });    

   tabPanel = new Ext.TabPanel({  
        deferredRender:true,
        activeTab: 0,
        margins: '0 0 0 0',  
        border: '0 0 0 0',
        plain: true,
        listeners: {
            tabchange: function (tabPanel, tab) {
                Ext.state.Manager.set(acttab,tab.id);
                restype = tab.resgroup;
            }
        }
    });
    // grids
    var nr = 1;
    function addview(record) {
        nr++
        const fltObj = [];
        var tab      = record.get('tab');
        var tabTitle = record.get('text');
        var filter   = record.get('filter');
        try {
            console.log('filter: '+filter);
            var flt = JSON.parse(filter);
            fltObj[nr] = flt['filters'];
        } catch (e) {
            fltObj[nr] = [];
        }
        var resgroup = record.get('resgroup');
        var tabId    = tab + '-view-' + nr;
        var gridId   = tabId + '-grid';
        var pgsizeId = 'pgzize_'+tab;
        var pageSize = Ext.state.Manager.get(pgsizeId,100);
        console.log('pgsizeId: '+pgsizeId);
        console.log('pageSize: '+pageSize);
        var gridViewStore = new Ext.data.Store({
            model: 'body',
		    autoLoad: true,
		    pageSize: pageSize,
		    remoteSort: true,
		    remoteFilter: true,
		    filters: fltObj[nr],
            proxy: {
                type: 'ajax',
                url: browser_ressource,
                timeout: 180000,
                actionMethods: 'POST',
                extraParams: {
                    caller: 'ajaxGetResourceList',
                    layout: layout,
                    restype: resgroup
                },
                reader: {
				    type: 'json',
				    totalProperty: 'totalCount',
				    rootProperty: 'nodes'
                }
            }
        });
        var viewGrid = Ext.create('Body.view.RsrcGrid', {
            id: gridId,
            stateId: gridId,
            columns: tabcols[tab],
            store: gridViewStore,
            listeners : {
                itemdblclick: function(dv, rec, item, index, e) {
                    dblClickRes(rec);
                },
                itemcontextmenu: function(view, rec, node, index, e) {
                    e.stopEvent();
                    if (menuContext[tab].items && menuContext[tab].items.length > 0) menuContext[tab].showAt(e.getXY());
                    return false;
                },
                afterrender: function(grid) {
                    var store = grid.getStore();
                    store.on('load', function(){
                        console.log('store loaded');
                        rescount = store.getTotalCount()
                        console.log('total: '+rescount);
                        //if no resource are existing inform user how to proceed
                        if ( document.getElementById('hintHowToNewBox') && rescount == 0 ) {
                            document.getElementById('hintHowToNewBox').style.visibility = "visible";
                        }
                        //save to cookies
                        Ext.state.Manager.set(pgsizeId,store.pageSize);
                     });
                }                
            },
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                defaultButtonUI: 'default',
                padding: '10 0 10 0',  
                border: 0,
                defaults: {
                    xtype : 'button',
                    scale: 'medium',
                    cls: 'btn-footer-button'
                },
                items: tabbuttons[tab]
            },{
                xtype: 'pagingtoolbar',
                dock: 'bottom',
                height: 30,
                padding: '0 0 0 0',  
                border: '0 0 1 0',
                store: gridViewStore,   // same store GridPanel is using
                displayInfo: true,
                displayMsg: 'Displaying {0} - {1} of {2}',
                listeners: {
                    beforeRender: function(pt) {
                        pt.getComponent('inputItem').readOnly = true;
                        pt.getComponent('afterTextItem').hidden = true;
                        pt.getComponent('last').hidden = true;
                    }
                },
                items: [{ xtype: 'tbseparator' },{
                    xtype: 'combobox',
                    itemId: 'RowsPerPage',
                    name: 'RowsPerPage',
                    hideLabel: true,
                    width: 60,
                    labelAlign: 'right',
                    hideTrigger: false,
                    displayField: 'name',
                    valueField: 'value',
                    editable: false,
                    queryMode: 'local',
                    allowBlank: true,
                    store: p_paging_store,
                    value: pageSize,
                    listeners: {
                        scope: this,
                        select: function(combo, records, eOpts) {					
                            console.log('pagingtoolbar:',combo.getValue());
                            gridViewStore.setPageSize(combo.getValue());
                            gridViewStore.loadPage(1);
                        
                        }
                    }
                },{ xtype: 'tbseparator' },{ xtype: 'tbtext', text: $$('Items per page') }]
            }]
        });

        //var viewStore = viewGrid.getStore();
        
        var newTab = tabPanel.add({
            id: tabId,
            title: tabTitle,
            resgroup: resgroup,
            margins: '0 0 0 0',  
            border: '0 0 0 0',
            layout: 'fit',
            closable:false,
            setActive: true,
            tabConfig: {
                margin: '0 0 0 0'
            },
            items: viewGrid
        });
        return newTab;
    }
    // intro view
    function addIntroView(page) {
        var viewIntro = Ext.create('Ext.Panel',{
            id: 'intro-view-1',
            autoScroll: true,
            loader: {
                url: page,
                autoLoad: true
            },
        });
        
        var newTab = tabPanel.add({
            id: 'intro-tab-1',
            title: $$('Overview'),
            margins: '0 0 0 0',  
            border: '0 0 0 0',
            layout: 'fit',
            closable:false,
            setActive: true,
            tabConfig: {
                margin: '0 0 0 0'
            },
            items: viewIntro
         });
        return newTab;
    }
    
    // load intro tab

    if ( introTab ) {
        addIntroView(introTab);
    }
    
    // create a list of tabs
    store_tabs.each(function(record,id){
        addview(record);
    });
    // activate the stored tab
    var tabid = Ext.state.Manager.get(acttab,0);
    if (tabPanel) tabPanel.setActiveTab(tabid);

    Ext.getCmp('centercenter').add(tabPanel);
    
	// add context menu to panel body
    // document.getElementById('centercenter').oncontextmenu=contextMenuExt;
    
    //release page blocker aufter redering the panel and grid
    blockBrowser(false);
    

}










