##############################################################################
#
# prepost_lib.tcl
#
#    P5 init and PrePost TCL Library
#
#    See the file "license.txt" for information on usage and
#    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
#    Rcsid: @(#)$Id: prepost_lib.tcl,v 1.56 2018/11/26 12:05:10 zv Exp $
#
##############################################################################

##############################################################################

proc lexxInit { } {

    set nsp [namespace current]

    sv_set runtimeconfig jobqueue [queue::create -queuename $nsp]
    if {[ns_config ns/server/[ns_info server] loadLanguages 1]} {
        loadLanguages languages
    }
}

##############################################################################

proc postAppStart { } {

    set user [session::user]
    #
    # ns_log notice "Running Application start procedure for user: $user"
    set ::dbgrp  [DatabaseGroup new]
    if { [catch { loadCustomerConfig customerconfig} message ] } {
       utility::error "postAppStart: can not read customer configuration Data: $message"
    }
    #
    if { [catch { loadUserConfig $user } message ] } {
       utility::error "postAppStart: can not read user settings: $message"
    }
    #
    $::dbgrp destroy
    #
    return
}

##############################################################################

proc prePageProcCommon { } {
    
    # ns_log notice "Running prePageProcCommon procedure for page: [login::procpage]."
    # reset errorInfo and errorCode
    set user [session::user]
    set ::errorInfo ""
    set ::errorCode ""
    # load often used variables
    set ::dbgrp  [DatabaseGroup new]
    try {
        set userSettings [session::get rtc.userpref.$user]
        session::put cacheUserSettingDateTime [keylget userSettings etc.user.$user.dateTime]
        session::put cacheUserOperations [keylget userSettings etc.user.$user.basketList]
        # disabled since 5.5
        # variable cacheBasketSortOr [const srtOrdrUsrBa]
    } catch {*} {
        utility::error "prePageProcCommon: can not read configuration Data: $message"
    } message
}

##############################################################################

proc prePageProcWorkspace { { database "" } } {
    
    # ns_log notice "Running prePageProcWorkspace procedure for page: [login::procpage]."
    #  
    # check from where we can get the current dbtype to work with.  
    #
    set qset       [ns_conn form] 
    
    # ns_set print $qset
    
    set caller      [ns_set get $qset caller]
    set elementurl  [ns_set get $qset elementurl]
    set snapshot    [ns_set get $qset snapshot]
    set workstation [ns_set get $qset workstation]

	if { $workstation != "" } {
    	# store workstation in session
    	session::put workstation $workstation
	}
	
    #
    set currentPage [login::procpage]
    # ns_log notice "currentPage: $currentPage - elementurl: $elementurl"
    if { $elementurl != "" } {
        # change only database for workspace if we are navigating
        if { $caller == "index" || $caller == "jumpRsrc" || $caller == "volumenListing" || $caller == "nextDir" || $caller == "previousDir"  || $caller == "cdLog" } {
            set database [decodeLexxUrl database  $elementurl]
            session::put database $database
        }
    }
    #
    if { $database == "" } {
        set database [session::get database]
    }
    # if a dbtype is still not set exit
    if { $database != "" } {
        if { $caller == "setShnapShot" } {
            keylset indexoption snapshot $snapshot
            session::put $database.indexoption $indexoption
        }
        if { [catch { set ::lexxCommand [mountDatabase $database [session::user] [session::password]] } message] } {
            catch { $::dbgrp destroy  }
            ns_log error "Could not mount database: $database"
            ns_log error $message
            utility::redirect [session::url /warning.tdp]?caller=errorIndex
        }
        set dbtype [$::lexxCommand treetype]
        session::put dbtype $dbtype
        set remote [$::lexxCommand isremote]
        session::put remote $remote
        # cache dbtype specific variables
        if $remote {
            session::put cacheIndexOperations [const $dbtype.remote]
        } else {
            session::put cacheIndexOperations [const $dbtype.local]
        }
    }
    #
    #
    return
}

##############################################################################

proc prePageProcRessource {} {
    
    # ns_log notice "Running prePageProcRessource procedure for page: [login::procpage]."
    #  
    #
    session::put cacheIndexOperations ""
    #
    #
    return
}

##############################################################################

proc prePageProcElement { { database "" } } {
    
    # ns_log notice "Running prePageProcElement procedure for page: [login::procpage]."
    #  
    # check from where we can get the current dbtype to work with.  
    #
    set qset       [ns_conn form] 
    set caller     [ns_set get $qset caller]
    set elementurl [ns_set get $qset elementurl]
    #
    if { $elementurl != "" } {
        set database [decodeLexxUrl database $elementurl]
    }
    if { $database == "" } {
        set database [session::get database]
    }
    #
    # if a dbtype is still not set exit
    if { $database != "" } {
        if { [catch { set ::lexxCommand [mountDatabase $database [session::user] [session::password]] } message] } {
            catch { $::dbgrp destroy  }
            utility::error "prePageProcElement: called from: [login::procpage] msg: $message"
        }
        set dbtype [$::lexxCommand treetype]
        session::put dbtype $dbtype
        # cache dbtype specific variables
        if { [$::lexxCommand isremote] } {
            session::put cacheIndexOperations [const $dbtype.remote]
        } else {
            session::put cacheIndexOperations [const $dbtype.local]
        }
    }
    #
    #
    return
}

##############################################################################

proc prePageProcFilepicker { { database "" } } {
    
    #  
    #
    set qset   [ns_conn form] 
    set node   [ns_set get $qset node]
    #
    # ns_set print $qset
    #
    #
    if { [set database [decodeLexxUrl database $node]] != "" } {
        if { [catch { set ::lexxCommand [mountDatabase $database [session::user] [session::password]] } message] } {
            catch { $::dbgrp destroy  }
            utility::error "prePageProcFilepicker: $message"
        }
    }
    #
    return
}

##############################################################################

proc prePageProcSearch { } {
    
    # ns_log notice "Running prePageProcSearch procedure for page: [login::procpage]."
    #  
    #
    if { [catch { set ::lexxCommand [mountDatabase [session::get database] [session::user] [session::password]] } message] } {
        catch { $::dbgrp destroy  }
        utility::error "prePageProcSearch: $message"
    }
    #
    #
    return
}

##############################################################################

proc postPageProc { } {
    
    # ns_log notice "Running postpage procedure."
    #
    # destroy the object
    #
    if { [info commands $::dbgrp] != "" } {
        catch { $::dbgrp destroy }
    }
    #
}

##############################################################################

proc postlogin { } {
        
    ns_log notice "Running login procedure for user: [session::user]"
    #
    return
}

##############################################################################

proc postlogout { } {
    
    #
    ns_log notice "Running logout procedure for user: [session::user]"
    return
}

##############################################################################
