Ext.define('P5Index.view.PathImportWindowViewModel', {
    extend: 'Ext.app.ViewModel',
    alias: 'viewmodel.pathimportwindow',

    data: {
        showUsedDurationTC: true,
        showAvailableDurationTC: true
    },

    stores: {
        pathProjectStore: {
            fields: [
                {name: 'fileName', type: 'string'},
                {name: 'sourceFormat', type: 'string', defaultValue: 'OTIO'},
                {name: 'originalPath', type: 'string'},
                {name: 'foundVersionCount', type: 'int', defaultValue: 0},
                {name: 'archiveVersionsStore', type: 'auto'},
                {name: 'usedDurationTC', type: 'string', defaultValue: ''},
                {name: 'availableDurationTC', type: 'string', defaultValue: ''},
                {name: 'searchQuery', type: 'string'},
                {name: 'searchMode', type: 'string'},
                {name: 'pathMatching', type: 'string'},
                {name: 'serverLogs', type: 'string'},
                {name: 'timestamp', type: 'date', defaultValue: new Date()}
            ],
            data: []
        }
    },
    
    // Factory-Methode für Archive-Version-Stores
    createArchiveVersionsStore: function() {
        return Ext.create('Ext.data.Store', {
            fields: [
                {name: 'fileName', type: 'string'},
                {name: 'foundFileName', type: 'string'},
                {name: 'selected', type: 'boolean', defaultValue: false},
                {name: 'atime', type: 'date', dateFormat: 'U', defaultValue: ''},
                {name: 'size', type: 'int', defaultValue: 0},
                {name: 'relativePath', type: 'string'},
                {name: 'archiveLocation', type: 'string'},
                {name: 'elementUrl', type: 'string'},
                {name: 'ranking', type: 'int', defaultValue: 0},
                {name: 'isDirectory', type: 'boolean', defaultValue: false}
            ],
            sorters: [{
                property: 'ranking', 
                direction: 'DESC'
            }],
            data: []
        });
    }
});