Ext.define("Dashboard.model.PoolUsage", {
    extend: 'Ext.data.Model',
    fields: [
        { name: 'poolName', type: 'string' },
        { name: 'totalCapacityKiB', type: 'float' },
        { name: 'usedCapacityKiB', type: 'float' },
        { name: 'percentFilled', type: 'float' },
        { name: 'percentFree', 
            type: 'float',
            calculate: function(data) {
                return parseFloat((100 - data.percentFilled).toFixed(1));
            }
        }
    ],
    proxy: {
        type: 'ajax',
        url: document.dashboardForm.startTdp.value,
        extraParams: {
            caller: 'ajaxTapeUsage',
            demoMode: localStorage.getItem('demoMode') === 'true'
        },
        reader: {
            type: 'json',
            rootProperty: 'data'
        }
    }
});
