Ext.define("P5Loginaras.view.LoginAreaList", {
    extend: 'Ext.panel.Panel',
    alias: "widget.loginarea_treelist",
    
    layout: {
        type: 'vbox',
        align: 'stretch'
    },
    margin: '0 0 0 0',
    border: true,
	bodyStyle: 'border-width: 1px 0px 0px 0px;',
    autoScroll: true,
    items: [{
        xtype: 'container',
        margin: '10 20 0 20',
        maxWidth: 450,
        bind:{
            html: '{htmlLoginareaDescription}'
        }
    },{
        xtype: 'treepanel',
        bind:{
            store: '{loginareas}'
        },
        viewConfig : {
            trackOver : false,
       	    stripeRows: false, 
        	getRowClass: function(record) { 
            	return record.get('leaf') == false ? 'mark-row-bolder' : 'mark-row-pointer'; 
        	} 
        },       
        reference: 'loginareas_tree_ref',
        itemId: 'loginareas_tree_id',
        margin: '10 20 20 10',
        border: false,
		bodyStyle: 'border-width: 0px 0px 0px 0px;',
        disableSelection: true,
	    useArrows: true,
	    rootVisible: false,
        hideHeaders: true,
        headerBorders: false
    }]
});