Ext.define('P5U.controller.Restore', {
    extend: 'Ext.app.Controller',

	init: function(){
		var me = this;
		P5U.restoreStatus = new Object();
        me.control({
            'restoreWindow button[action=restoreStart]': {
                click: this.onRestoreStart
            },
            'restoreWindow button[action=filePickerPath]': {
                click: this.onRelocatePath
            },
            'restoreStatus_x button[action=cancelRestore]': {
                click: this.onRestoreStop
            }
		});
	},
    onRestoreWindow: function(obj) {
		var me = this;
    	var creg = Ext.ComponentQuery.query('viewport > #CenterRegion')[0]
    	var iwin = Ext.ComponentQuery.query('#infoWindow_id')[0];
    	var rwin = Ext.ComponentQuery.query('#restoreWindow_id')[0];
    	if (!rwin) {
        	rwin = Ext.widget({
     			xtype: 'restoreWindow',
     			itemId: 'restoreWindow_id',
        	    title: $$('Restore'),
     			items: {
        			xtype: 'restoreForm'
        		}
 			});
        	creg.add(rwin);
        }
        rwin.setTitle( $$('Restore')+': '+P5U.globals.selectedname);
        rwin.show();
        rwin.alignTo(iwin, "b-b",[0, -10]);
        // set relocate path in filepicker window
        me.onRelocatePathCallback();
    },
    onRestoreStart: function(obj) {
		var me = this;
    	console.log('Start Restore');
    	var restoreForm = Ext.ComponentQuery.query('#restoreWindow_id restoreForm')[0];
		if (  P5U.globals.selectednames.length > 1 ) {
		    var restoreProc = 'ajaxStartMultiRestore';
		} else {
		    var restoreProc = 'ajaxStartRestore';
		}
		Ext.Msg.confirm($$('Do you really want to restore the selected items?'), '- ' + P5U.globals.selectednames.join('<br />- '), function(btn, name){
			if (btn == 'yes') {
				restoreForm.getForm().submit({
					url:  P5U.globals.serverpage,
					waitMsg: $$('Preparing restore')+' ...',
					params: {
						caller: restoreProc,
						node: P5U.globals.assetUrl,
						selectedelements: Ext.encode(P5U.globals.selectedelements),
						snapshot: P5U.globals.snapshot,
						instance: P5U.globals.instance,
						relocateClient: P5U.globals.parentClient,
						relocatePath: P5U.globals.parentPath
					},
					success:function(form, loadobj) {
						P5U.restoreStatus = Ext.decode(loadobj.response.responseText);
						me.onRestoreStatus();
						obj.up().up().up().hide();
					},
					failure: function(form, loadobj) {
						Ext.MessageBox.alert('Failed', loadobj.response.responseText);
					}
				});
			}			
		});
    },
    onRelocatePath: function(obj) {
		var me = this;
    	console.log('Relocate Path');
    	var creg = Ext.ComponentQuery.query('viewport > #CenterRegion')[0]
    	var iwin = Ext.ComponentQuery.query('#infoWindow_id')[0];
    	var rwin = Ext.ComponentQuery.query('#filePicker_id')[0];
    	if (!rwin) {
            rwin = Ext.widget({
                xtype: 'filePicker_x',
                itemId: 'filePicker_id',
                title: $$('Select a Folder'),
                aufrufer: me.onRelocatePathCallback
            });
            creg.add(rwin);
        }
        rwin.show();
        rwin.alignTo(iwin, "b-b",[0, -10]);
    },
    onRelocatePathCallback: function() {
    	console.log('Relocate Callback');
    	var dp = P5U.globals.parentPath;
    	if (dp.length > 100) {
    	    var dp = dp.substr(0, 30) + '...' + dp.substr(dp.length-80, dp.length);
    	}
		Ext.ComponentQuery.query('#restoreWindow_id restoreForm displayfield[name=displayPath]')[0].setValue(P5U.globals.parentClient+':'+dp);
		Ext.ComponentQuery.query('#restoreWindow_id restoreForm button[name=browsePath]')[0].setDisabled(!P5U.globals.allowRelocate);
    },
    onRestoreStatus: function(obj) {
    	console.log('Open Restore Status');
    	var creg = Ext.ComponentQuery.query('viewport > #CenterRegion')[0]
    	var iwin = Ext.ComponentQuery.query('#infoWindow_id')[0];
    	var rwin = Ext.ComponentQuery.query('#restoreStatus_id')[0];
    	if (!rwin) {
        	rwin = Ext.widget({
     			xtype: 'restoreStatus_x',
     			itemId: 'restoreStatus_id',
        	    title: $$('Restore status')
 			});
        	creg.add(rwin);
        }
        rwin.setTitle( $$('Restore status')+': '+P5U.globals.selectedname);
        rwin.show();
        rwin.alignTo(iwin, "b-b",[0, -10]);
    	Ext.ComponentQuery.query('restoreShortMsg_x')[0].updateText($$('Please wait')+' ...');
		progressCheck();
    },
    onRestoreStop: function(obj) {
    	console.log('Stop Restore');
		Ext.Ajax.request({
			url: P5U.globals.serverpage,
			method: 'POST',
			params: { 
				caller: 'ajaxStopRestore',
				jobname: P5U.restoreStatus.jobname
			},
			scope: this,
			success: function(result, request) {
    			console.log('Stop Restore done');
			},
			failure: function(result, request) {
				Ext.MessageBox.alert('Failed', result.responseText);
			}
		});
    },
	onLaunch: function(){
		console.log('Restore controller ready');
	}
});

var progressCheck = function() {
	var rwin = Ext.ComponentQuery.query('#restoreStatus_id')[0];
	if (rwin.isVisible()) {
		Ext.Ajax.request({
			url: P5U.globals.serverpage,
			method: 'POST',
			params: { 
				caller: 'ajaxGetRestoreProgress',
				jobname: P5U.restoreStatus.jobname
			},
			scope: this,
			success: function(result, request) {
				var json = Ext.decode(result.responseText);
				Ext.ComponentQuery.query('restoreShortMsg_x')[0].updateText(json.shortmsg);
    			Ext.ComponentQuery.query('restoreLongMsg_x')[0].update(json.longmsg);
				if (json.isrunnning) {
					setTimeout(function() {
						progressCheck();
					}, 500);
				} else {
					setTimeout(function() {
						Ext.ComponentQuery.query('#restoreStatus_id')[0].close();
					}, 2000);
				}        },
			failure: function(result, request) {
				Ext.MessageBox.alert('Failed', result.responseText);
			}
		});
    }
}