##############################################################################
#
# resource_lib.tcl
#
#    P5 Resource Library
#
#    See the file "license.txt" for information on usage and
#    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
#    Rcsid: @(#)$Id: resourse_lib.tcl,v 1.138 2019/03/14 10:30:18 jd Exp $
#
##############################################################################

proc getResourceParamater { name } {

    set resource ""
    
    switch -exact -- $name {
        Storagemanager_tab {
            set vtl [session::get gui.Jukebox.mediaType.DISK.configurable.boolean]
            set rem [session::get gui.Device.deviceType.Removable.configurable.boolean]
            if {$vtl} {
                set disk   "disk"
                set pseudo "pseudo"
            } else {
                set disk   ""
                set pseudo ""
            }
            if {$rem} {
                set rmdisk "rmdisk"
            } else {
                set rmdisk ""
            }
            keylset resource tablist          "tape device cntrdisk cloud $disk $rmdisk $pseudo"
            keylset resource reslist          "Jukebox Device ObjectStore"
            keylset resource introTab         [session::url /getting_started/Storagemanager_setup.tdp]
            keylset resource tape.resgroup    "Jukebox"
            keylset resource tape.collayout   "Jukebox"
            keylset resource tape.text        [translate "Tape Libraries"]
            keylset resource tape.filter      {{"filters":[{"property":"rsrc_mediaType","value":"TAPE"}]}}
            #keylset resource tape.filter      ""
            keylset resource tape.editmenu    "label inventory loadslot importvol reset enable disable"
            keylset resource tape.filemenu    "remove open"
            keylset resource tape.buttonsObj  "cjb"
            keylset resource tape.buttonsPro  "label inventory loadslot"
            #
            keylset resource device.resgroup   "Device"
            keylset resource device.collayout  "Device"
            keylset resource device.text       [translate "Tape Drives"]
            #keylset resource device.filter     "tapedrv"
            keylset resource device.filter     {{"filters":[{"property":"rsrc_mediaType","value":"TAPE"}]}}
            keylset resource device.editmenu   "label mount reset importvol enable disable"
            keylset resource device.filemenu   "create remove open"
            keylset resource device.buttonsObj "ctape"
            keylset resource device.buttonsPro "label mount importvol"
            #
            keylset resource cntrdisk.resgroup   "Device"
            keylset resource cntrdisk.collayout  "Device_CONTAINER"
            keylset resource cntrdisk.text       [translate "Container Storage"]
            #keylset resource cntrdisk.filter     "cntrdisk"
            keylset resource cntrdisk.filter     {{"filters":[{"property":"rsrc_mediaType","value":"CONTAINER"}]}}
            keylset resource cntrdisk.editmenu   "enable disable"
            keylset resource cntrdisk.filemenu   "remove open"
            keylset resource cntrdisk.buttonsObj "cdisk ccloud"
            keylset resource cntrdisk.buttonsPro ""
            #            
            keylset resource cloud.resgroup     "ObjectStore"
            keylset resource cloud.collayout    "ObjectStore"
            keylset resource cloud.text         [translate "Cloud Service"]
            keylset resource cloud.filter       ""
            keylset resource cloud.editmenu     "compatibility"
            keylset resource cloud.filemenu     "create remove open"
            keylset resource cloud.buttonsObj   "create"
            keylset resource cloud.buttonsPro   "compatibility"
            #
            if {$vtl} {
                keylset resource disk.resgroup      "Jukebox"
                keylset resource disk.collayout     "Jukebox"
                keylset resource disk.text          [translate "Virtual Tape Libraries"]
                #keylset resource disk.filter        "disklib"
                keylset resource disk.filter        {{"filters":[{"property":"rsrc_mediaType","value":"DISK"}]}}
                keylset resource disk.editmenu      "label inventory loadslot reset enable disable"
                keylset resource disk.filemenu      "remove open"
                keylset resource disk.buttonsObj    "cvtl"
                keylset resource disk.buttonsPro    "label inventory loadslot"
            }
            #
            if {$rem} {
                keylset resource rmdisk.resgroup    "Device"
                keylset resource rmdisk.collayout   "Device"
                keylset resource rmdisk.text        [translate "Removable Disk"]
                keylset resource rmdisk.filter      {{"filters":[{"property":"rsrc_deviceType","value":"Removable-Disk"}]}}
                #keylset resource rmdisk.filter      "rmdisk"
                keylset resource rmdisk.editmenu    "label mount reset enable disable"
                keylset resource rmdisk.filemenu    "remove open"
                keylset resource rmdisk.buttonsObj  "rmdisk"
                keylset resource rmdisk.buttonsPro  "label mount"
            }
            #            
            keylset resource pseudo.resgroup    "Device"
            keylset resource pseudo.collayout   "Device"
            keylset resource pseudo.text        [translate "Pseudo Devices"]
            keylset resource pseudo.filter      {{"filters":[{"property":"rsrc_deviceType","value":"DISK"}]}}
            #keylset resource pseudo.filter      "pseudo"
            keylset resource pseudo.editmenu    "enable disable"
            keylset resource pseudo.filemenu    "remove open"
            keylset resource pseudo.buttonsObj  ""
            keylset resource pseudo.buttonsPro  ""
        }
        Jukebox {
            keylset resource label.section    0
            keylset resource label.text       [translate "Label Volume(s)"]...
            keylset resource label.stext      [translate "Label"]
            keylset resource label.action     [session::url /system/label_jukebox.tdp]
            keylset resource label.function   "resProc3('label')"
            keylset resource inventory.section   0
            keylset resource inventory.text      [translate "Take Library Inventory"]...
            keylset resource inventory.stext     [translate "Inventory"]
            keylset resource inventory.action    [session::url /system/inventory_jukebox.tdp]
            keylset resource inventory.function  "resProc3('inventory')"
            keylset resource cjb.stext        [translate "New Tape Library"]
            keylset resource cjb.action       [session::url /system/jukebox_setup/jukebox_page_1.tdp]
            keylset resource cjb.function     "newElement1('Jukebox','cjb')"
            keylset resource open.section     1
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/jukebox_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource cvtl.stext       [translate "New VTL"]
            keylset resource cvtl.action      [session::url /system/device_setup/disk_page.tdp]
            keylset resource cvtl.function    "newElement1('Jukebox','cvtl')"
            keylset resource loadslot.section   0
            keylset resource loadslot.text      [translate "Load/Unload Slot"]...
            keylset resource loadslot.stext     [translate "Load/Unload"]
            keylset resource loadslot.action    [session::url /system/load_jukebox_slot.tdp]
            keylset resource loadslot.function  "resProc3('loadslot')"
            keylset resource importvol.section   0
            keylset resource importvol.text      [translate "Import Volume"]...
            keylset resource importvol.action    [session::url /system/import_jukebox_volume.tdp]
            keylset resource importvol.function  "resProc3('importvol')"
            keylset resource reset.section    1
            keylset resource reset.text       [translate "Reset Library"]...
            keylset resource reset.action     [session::url /system/reset_jukebox.tdp]
            keylset resource reset.function   "resProc3('reset')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Device - TAPE {
            keylset resource label.section    0
            keylset resource label.text       [translate "Label Volume(s)"]...
            keylset resource label.stext      [translate "Label"]
            keylset resource label.action     [session::url /system/label_device.tdp]
            keylset resource label.function   "resProc3('label')"
            keylset resource mount.section    0
            keylset resource mount.text       [translate "Mount/Unmount Volume"]...
            keylset resource mount.stext      [translate "Mount/Unmount"]
            keylset resource mount.action     [session::url /system/mount_device.tdp]
            keylset resource mount.function   "resProc3('mount')"
            keylset resource create.section   0
            keylset resource create.text      [translate "Add manually"]...
            keylset resource create.action    [session::url /system/device_manager.tdp]
            keylset resource create.function  "newElement1('TAPE','create')"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/device_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource ctape.section     1
            keylset resource ctape.stext       [translate "New Tape Drive"]
            keylset resource ctape.function    "newElement1('Device','ctape')"
            keylset resource ctape.action      [session::url /system/device_setup/device_page_1.tdp]
            keylset resource cdisk.section     1
            keylset resource cdisk.stext      [translate "Add Local Storage"]
            keylset resource cdisk.action     [session::url /system/device_setup/container_page.tdp]
            keylset resource cdisk.function   "newElement1('Device','cdisk')"
            keylset resource ccloud.stext      [translate "Add Cloud Storage"]
            keylset resource ccloud.action     [session::url /system/device_setup/cloud_page.tdp]
            keylset resource ccloud.function   "newElement1('Device','ccloud')"
            keylset resource rmdisk.stext      [translate "New Removable Disk"]
            keylset resource rmdisk.action     [session::url /system/device_setup/removabledisk_page.tdp]
            keylset resource rmdisk.function   "newElement1('Device','rmdisk')"
            keylset resource importvol.section   1
            keylset resource importvol.text      [translate "Import Volume"]...
            keylset resource importvol.stext     [translate "Import"]
            keylset resource importvol.action    [session::url /system/import_device_volume.tdp]
            keylset resource importvol.function  "resProc3('importvol')"
            keylset resource reset.section    1
            keylset resource reset.text       [translate "Drive Reset"]...
            keylset resource reset.action     [session::url /system/reset_device.tdp]
            keylset resource reset.function   "resProc3('reset')"
            keylset resource remove.section   0
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        ObjectStore {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New Service"]
            keylset resource create.action    [session::url /system/objectstore_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/objectstore_manager.tdp]
            keylset resource open.function    "resProc3m('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource compatibility.section     0
            keylset resource compatibility.text        [translate "Compatibility Test"]...
            keylset resource compatibility.stext       [translate "Compatibility"]
            keylset resource compatibility.action      [session::url /system/objectstore_test.tdp]
            keylset resource compatibility.function    "resProc3('compatibility')"
        }
        Database_tab {
            keylset resource reslist  "Database"
            keylset resource tablist  "database"
            keylset resource introTab ""
            keylset resource database.resgroup   "Database"
            keylset resource database.collayout  "Database"
            keylset resource database.text       [translate "Manage Indexes"]
            keylset resource database.filter     ""
            keylset resource database.editmenu   "fields indexck enable disable"
            keylset resource database.filemenu   "create remove open"
            keylset resource database.buttonsObj "create"
            keylset resource database.buttonsPro "indexck"
        }
        Database {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New Archive Index"]
            keylset resource create.action    [session::url /system/database_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/database_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource fields.section   1
            keylset resource fields.text      [translate "Fields"]...
            keylset resource fields.action    [session::url /system/database_fields.tdp]
            keylset resource fields.function  "resProc3('fields')"
            keylset resource indexck.section  0
            keylset resource indexck.text     [translate "Check Database"]...
            keylset resource indexck.stext    [translate "Check"]
            keylset resource indexck.action   [session::url /system/customer_index/index_check_1.tdp]
            keylset resource indexck.function "resProc3('indexck')"
            keylset resource indexup.section  1
            keylset resource indexup.text     [translate "Convert Database"]...
            keylset resource indexup.stext    [translate "Convert"]
            keylset resource indexup.action   [session::url /system/customer_index/index_update.tdp]
            keylset resource indexup.function "resProc3('indexup')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Filter_tab {
            keylset resource reslist  "Filter"
            keylset resource tablist  "filter"
            keylset resource introTab ""
            keylset resource filter.resgroup   "Filter"
            keylset resource filter.collayout  "Filter"
            keylset resource filter.text       [translate "File Filter"]
            keylset resource filter.filter     ""
            keylset resource filter.editmenu   "duplicate enable disable"
            keylset resource filter.filemenu   "create remove open"
            keylset resource filter.buttonsObj "create"
            keylset resource filter.buttonsPro ""
        }
        Filter {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/filter_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/filter_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        License_tab {
            keylset resource reslist  "License"
            keylset resource tablist  "license"
            keylset resource introTab ""
            keylset resource license.resgroup  "License"
            keylset resource license.collayout "License"
            keylset resource license.text       [translate "License Manager"]
            keylset resource license.filter     ""
            keylset resource license.editmenu   ""
            keylset resource license.filemenu   "create remove open import"
            keylset resource license.buttonsObj "create import remove"
            keylset resource license.buttonsPro "portal trial"
        }
        License {
            keylset resource create.section   0
            keylset resource create.text      [translate "Add manually"]...
            keylset resource create.stext     [translate "Add manually"]
            keylset resource create.action    [session::url /system/license_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/license_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource trial.section     0
            keylset resource trial.text        [translate "Get Trial License"]...
            keylset resource trial.stext       [translate "Get Trial License"]
            keylset resource trial.action      [session::url /system/license_trial.tdp]
            keylset resource trial.function    "commonProc('License','trial')"
            keylset resource portal.section    0
            keylset resource portal.text       [translate "Archiware Portal"]...
            keylset resource portal.stext      [translate "Archiware Portal"]
            keylset resource portal.action     [session::url /system/license_portal.tdp]
            keylset resource portal.function   "commonProc('License','portal')"
            keylset resource import.section    1
            keylset resource import.text       [translate "Import from File"]
            keylset resource import.stext      [translate "Import from File"]
            keylset resource import.function   "importElement()"
            keylset resource export.section    0
            keylset resource export.text       [translate "Export"]
            keylset resource export.function   "exportElement()"
        }
        Client_tab {
            keylset resource reslist  "Client"
            keylset resource tablist  "client"
            keylset resource introTab ""
            keylset resource client.resgroup   "Client"
            keylset resource client.collayout  "Client"
            keylset resource client.text       [translate "Clients"]
            keylset resource client.filter     ""
            keylset resource client.editmenu   "ping restart enable disable"
            keylset resource client.filemenu   "create remove open"
            keylset resource client.buttonsObj "create"
            keylset resource client.buttonsPro "ping"
        }
        Client {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/client_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/client_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource ping.section     0
            keylset resource ping.text        [translate "Ping Client"]...
            keylset resource ping.stext       [translate "Ping"]
            keylset resource ping.action      [session::url /system/client_ping.tdp]
            keylset resource ping.function    "resProc3('ping')"
            keylset resource restart.section  0
            keylset resource restart.text     [translate "Restart Client"]...
            keylset resource restart.action   [session::url /system/client_restart.tdp]
            keylset resource restart.function "resProc3('restart')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Server_tab {
            keylset resource reslist  "Server"
            keylset resource tablist  "server"
            keylset resource introTab ""
            keylset resource server.resgroup   "Server"
            keylset resource server.collayout  "Server"
            keylset resource server.text       [translate "Remote P5 Server"]
            keylset resource server.filter     ""
            keylset resource server.editmenu   "enable disable"
            keylset resource server.filemenu   "create remove open"
            keylset resource server.buttonsObj "create remove"
            keylset resource server.buttonsPro ""
        }
        Server {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/server_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/server_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   1
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Workstation_tab {
            keylset resource reslist  "Workstation"
            keylset resource tablist  "workstation"
            keylset resource introTab ""
            keylset resource workstation.resgroup   "Workstation"
            keylset resource workstation.collayout  "Workstation"
            keylset resource workstation.text       [translate "Workstations"]
            keylset resource workstation.filter     ""
            keylset resource workstation.editmenu   "enable disable"
            keylset resource workstation.filemenu   "create remove open"
            keylset resource workstation.buttonsObj ""
            keylset resource workstation.buttonsPro ""
        }
        Workstation {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/workstation_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/workstation_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   1
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Backup2Go_tab {
            keylset resource reslist  "Backup2Go"
            keylset resource tablist  "backup2go"
            keylset resource introTab ""
            keylset resource backup2go.resgroup   "Backup2Go"
            keylset resource backup2go.collayout  "Backup2Go"
            keylset resource backup2go.text       [translate "Workstation Groups"]
            keylset resource backup2go.filter     ""
            keylset resource backup2go.editmenu   "enable disable"
            keylset resource backup2go.filemenu   "create remove open"
            keylset resource backup2go.buttonsObj "create"
            keylset resource backup2go.buttonsPro ""
        }
        Backup2Go {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/backup2go_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.stext       [translate "Edit"]
            keylset resource open.action      [session::url /system/backup2go_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Volume_tab {
            keylset resource reslist  "Volume"
            keylset resource tablist  "volume"
            keylset resource introTab ""
            keylset resource volume.resgroup   "Volume"
            keylset resource volume.collayout  "Volume"
            keylset resource volume.text       [translate "Volumes"]
            keylset resource volume.filter     ""
            keylset resource volume.editmenu   "slotexp label clocopy syncvol updstats enable disable jobvol"
            keylset resource volume.filemenu   "remove open"
            keylset resource volume.buttonsObj ""
            keylset resource volume.buttonsPro "label slotexp"
        }
        Volume {
            keylset resource create.section   0
            keylset resource create.text      ""
            keylset resource create.action    [session::url /system/volume_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/volume_manager.tdp]
            keylset resource open.function    "resProc3m('open')"
            keylset resource open_container.section     0
            keylset resource open_container.text        [translate "Edit"]...
            keylset resource open_container.action      [session::url /system/volume_container.tdp]
            keylset resource open_container.function    "resProc3('open_container')"
            keylset resource clocopy.section  0
            keylset resource clocopy.text     [translate "Regenerate/Copy Volume"]...
            keylset resource clocopy.action   [session::url /system/volume_clocopy.tdp]
            keylset resource clocopy.function "resProc3('clocopy')"
            keylset resource syncvol.section  1
            keylset resource syncvol.text     [translate "Re-sync Cloud Volume(s)"]...
            keylset resource syncvol.action   [session::url /system/volume_sync.tdp]
            keylset resource syncvol.function "resProc3m('syncvol')"
            keylset resource inventory.section  1
            keylset resource inventory.text     [translate "Create Inventory"]...
            keylset resource inventory.action   [session::url /system/volume_inventory.tdp]
            keylset resource inventory.function "resProc3m('inventory')"
            keylset resource jobvol.section   0
            keylset resource jobvol.text      [translate "Job History"]...
            keylset resource jobvol.action    [session::url /system/volume_joblist.tdp]
            keylset resource jobvol.function  "resProc3('jobvol')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.action    [session::url /system/volume_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource label.section    0
            keylset resource label.text       [translate "Label Volume(s)"]...
            keylset resource label.stext      [translate "Label"]
            keylset resource label.action     [session::url /system/volume_label.tdp]
            keylset resource label.function   "resProc3m('label')"
            keylset resource slotexp.section  0
            keylset resource slotexp.text     [translate "Unload to Mail Slot"]...
            keylset resource slotexp.stext    [translate "Unload"]
            keylset resource slotexp.action   [session::url /system/unload_volume.tdp]
            keylset resource slotexp.function "resProc3m('slotexp')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
            keylset resource updstats.section   1
            keylset resource updstats.text      [translate "Update Statistics"]
            keylset resource updstats.function  "updateElementM('updateStats')"
        }
        LoginArea_tab {
            keylset resource reslist  "LoginArea"
            keylset resource tablist  "loginarea"
            keylset resource introTab ""
            keylset resource loginarea.resgroup   "LoginArea"
            keylset resource loginarea.collayout  "LoginArea"
            keylset resource loginarea.text       [translate "Login Areas"]
            keylset resource loginarea.filter     ""
            keylset resource loginarea.editmenu   "enable disable"
            keylset resource loginarea.filemenu   "create remove open duplicate"
            keylset resource loginarea.buttonsObj "create"
            keylset resource loginarea.buttonsPro ""
        }
        LoginArea {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/loginarea_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/loginarea_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  1
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        UserPref_tab {
            keylset resource reslist  "UserPref"
            keylset resource tablist  "userpref"
            keylset resource introTab ""
            keylset resource userpref.resgroup   "UserPref"
            keylset resource userpref.collayout  "UserPref"
            keylset resource userpref.text       [translate "User Preferences"]
            keylset resource userpref.filter     ""
            keylset resource userpref.editmenu   "enable disable"
            keylset resource userpref.filemenu   "create remove open duplicate"
            keylset resource userpref.buttonsObj "create"
            keylset resource userpref.buttonsPro ""
        }
        UserPref {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/userpref_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/userpref_manager.tdp]
            keylset resource open.function    "resProc3m('open')"
            keylset resource duplicate.section  1
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        GroupPref_tab {
            keylset resource reslist  "GroupPref"
            keylset resource tablist  "grouppref"
            keylset resource introTab ""
            keylset resource grouppref.resgroup   "GroupPref"
            keylset resource grouppref.collayout  "GroupPref"
            keylset resource grouppref.text       [translate "Group Preferences"]
            keylset resource grouppref.filter     ""
            keylset resource grouppref.editmenu   "enable disable"
            keylset resource grouppref.filemenu   "create remove open duplicate"
            keylset resource grouppref.buttonsObj "create"
            keylset resource grouppref.buttonsPro ""
        }
        GroupPref {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/grouppref_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/grouppref_manager.tdp]
            keylset resource open.function    "resProc3m('open')"
            keylset resource duplicate.section  1
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        Translation_tab {
            keylset resource reslist  "Translation"
            keylset resource tablist  "translation"
            keylset resource introTab ""
            keylset resource translation.resgroup   "Translation"
            keylset resource translation.collayout  "Translation"
            keylset resource translation.text       [translate "Translation"]
            keylset resource translation.filter     ""
            keylset resource translation.editmenu   "exportlang importlang testlang refresh"
            keylset resource translation.filemenu   "create remove open"
            keylset resource translation.buttonsObj "create remove"
            keylset resource translation.buttonsPro ""
        }
        Translation {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/translat_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/translat_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource exportlang.section   1
            keylset resource exportlang.text      [translate "Export Translation"]...
            keylset resource exportlang.action    [session::url /system/translat_export.tdp]
            keylset resource exportlang.function  "commonProc('Translation','exportlang')"
            keylset resource importlang.section   0
            keylset resource importlang.text      [translate "Import Translation"]...
            keylset resource importlang.action    [session::url /system/translat_import.tdp]
            keylset resource importlang.function  "commonProc('Translation','importlang')"
            keylset resource testlang.section   1
            keylset resource testlang.text      [translate "Test Translation"]...
            keylset resource testlang.action    [session::url /system/translat_test.tdp]
            keylset resource testlang.function  "commonProc('Translation','testlang')"
            keylset resource refresh.section  1
            keylset resource refresh.text     [translate "Refresh Cache"]...
            keylset resource refresh.action   [session::url /system/translat_refresh.tdp]
            keylset resource refresh.function "commonProc('Translation','refresh')"
        }
        Pool_tab {
            keylset resource reslist  "Pool"
            keylset resource tablist  "pool"
            keylset resource introTab ""
            keylset resource pool.resgroup   "Pool"
            keylset resource pool.collayout  "Pool"
            keylset resource pool.text       [translate "Pools"]
            keylset resource pool.filter     ""
            keylset resource pool.editmenu   "updstats enable disable volchain"
            keylset resource pool.filemenu   "create remove open"
            keylset resource pool.buttonsObj "create"
            keylset resource pool.buttonsPro ""
        }
        Pool {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/pool_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/pool_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3('remove')"
            keylset resource volchain.section   1
            keylset resource volchain.text      [translate "Volume Chain"]...
            keylset resource volchain.action    [session::url /system/volume_chain.tdp]
            keylset resource volchain.function  "resProc3('volchain')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
            keylset resource updstats.section   1
            keylset resource updstats.text      [translate "Update Statistics"]
            keylset resource updstats.function  "updateElementS('updateStats')"
        }
        ArchivePlan_tab {
            keylset resource reslist  "ArchivePlan"
            keylset resource tablist  "archiveplan"
            keylset resource introTab ""
            keylset resource archiveplan.resgroup   "ArchivePlan"
            keylset resource archiveplan.collayout  "ArchivePlan"
            keylset resource archiveplan.text       [translate "Archive Plan"]
            keylset resource archiveplan.filter     ""
            keylset resource archiveplan.editmenu   "duplicate enable disable"
            keylset resource archiveplan.filemenu   "create remove open wizard"
            keylset resource archiveplan.buttonsObj "create wizard"
            keylset resource archiveplan.buttonsPro ""
        }
        ArchivePlan {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/archiveplan_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource wizard.section   1
            keylset resource wizard.text      [translate "Setup Assistant"]...
            keylset resource wizard.stext     [translate "Setup Assistant"]
            keylset resource wizard.function  "markToolRow('archive:6','archive_setup')"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/archiveplan_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        MigrationPlan_tab {
            keylset resource reslist  "MigrationPlan"
            keylset resource tablist  "migrationplan"
            keylset resource introTab ""
            keylset resource migrationplan.resgroup   "MigrationPlan"
            keylset resource migrationplan.collayout  "MigrationPlan"
            keylset resource migrationplan.text       [translate "Migration Plan"]
            keylset resource migrationplan.filter     ""
            keylset resource migrationplan.editmenu   "duplicate enable disable"
            keylset resource migrationplan.filemenu   "create remove open"
            keylset resource migrationplan.buttonsObj "create"
            keylset resource migrationplan.buttonsPro ""
        }
        MigrationPlan {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/migrationplan_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/migrationplan_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        VerifyPlan_tab {
            keylset resource reslist  "VerifyPlan"
            keylset resource tablist  "verifyplan"
            keylset resource introTab ""
            keylset resource verifyplan.resgroup   "VerifyPlan"
            keylset resource verifyplan.collayout  "VerifyPlan"
            keylset resource verifyplan.text       [translate "Verify Plan"]
            keylset resource verifyplan.filter     ""
            keylset resource verifyplan.editmenu   "duplicate enable disable"
            keylset resource verifyplan.filemenu   "create remove open"
            keylset resource verifyplan.buttonsObj "create"
            keylset resource verifyplan.buttonsPro ""
        }
        VerifyPlan {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/verifyplan_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/verifyplan_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        ObjectBucket_tab {
            keylset resource reslist  "ObjectBucket"
            keylset resource tablist  "objectbucket"
            keylset resource introTab ""
            keylset resource objectbucket.resgroup   "ObjectBucket"
            keylset resource objectbucket.collayout  "ObjectBucket"
            keylset resource objectbucket.text       [translate "S3 Object Archive"]
            keylset resource objectbucket.filter     ""
            keylset resource objectbucket.editmenu   "enable disable"
            keylset resource objectbucket.filemenu   "create remove open"
            keylset resource objectbucket.buttonsObj "create"
            keylset resource objectbucket.buttonsPro ""
        }
        ObjectBucket {
            keylset resource create.section   0
            keylset resource create.text      [translate "New Archive Bucket"]...
            keylset resource create.stext     [translate "New Archive Bucket"]
            keylset resource create.action    [session::url /system/objectbucket_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/objectbucket_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        BackupPlan_tab {
            keylset resource reslist  "BackupPlan"
            keylset resource tablist  "backupplan"
            keylset resource introTab ""
            keylset resource backupplan.resgroup  "BackupPlan"
            keylset resource backupplan.collayout "BackupPlan"
            keylset resource backupplan.text       [translate "Backup Plan"]
            keylset resource backupplan.filter     ""
            keylset resource backupplan.editmenu   "duplicate enable disable"
            keylset resource backupplan.filemenu   "create remove open wizard"
            keylset resource backupplan.buttonsObj "create wizard"
            keylset resource backupplan.buttonsPro ""
        }
        BackupPlan {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/backupplan_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource wizard.section   0
            keylset resource wizard.text      [translate "Setup Assistant"]...
            keylset resource wizard.stext     [translate "Setup Assistant"]
            keylset resource wizard.function  "markToolRow('backup:6','backup_setup')"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/backupplan_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        SyncPlan_tab {
            keylset resource reslist  "SyncPlan"
            keylset resource tablist  "syncplan"
            keylset resource introTab ""
            keylset resource syncplan.resgroup   "SyncPlan"
            keylset resource syncplan.collayout  "SyncPlan"
            keylset resource syncplan.text       [translate "Synchronize Plan"]
            keylset resource syncplan.filter     ""
            keylset resource syncplan.editmenu   "duplicate enable disable"
            keylset resource syncplan.filemenu   "create remove open wizard"
            keylset resource syncplan.buttonsObj "create wizard"
            keylset resource syncplan.buttonsPro ""
        }
        SyncPlan {
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.stext     [translate "New"]
            keylset resource create.action    [session::url /system/syncplan_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource wizard.section   0
            keylset resource wizard.text      [translate "Setup Assistant"]...
            keylset resource wizard.stext     [translate "Setup Assistant"]
            keylset resource wizard.function  "markToolRow('synchronize:0','sync_starter')"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/syncplan_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource duplicate.section  0
            keylset resource duplicate.text     [translate "Duplicate"]...
            keylset resource duplicate.action   [session::url /system/resource_duplicate.tdp]
            keylset resource duplicate.function "resProc3('duplicate')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.stext     [translate "Delete"]
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
            keylset resource enable.section   1
            keylset resource enable.text      [translate "Enable"]
            keylset resource enable.function  "modeElement('enable')"
            keylset resource disable.section   0
            keylset resource disable.text      [translate "Disable"]
            keylset resource disable.function  "modeElement('disable')"
        }
        BackupTask {
            keylset resource editmenu         ""
            keylset resource filemenu         "create remove open"
            keylset resource buttonsObj       "create remove open"
            keylset resource buttonsPro       ""
            keylset resource create.section   0
            keylset resource create.text      [translate "New"]...
            keylset resource create.action    [session::url /system/backuptask_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        [translate "Edit"]...
            keylset resource open.action      [session::url /system/backuptask_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource remove.section   0
            keylset resource remove.text      [translate "Delete"]...
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3m('remove')"
        }
        Job {
            keylset resource editmenu         "archive monitor"
            keylset resource filemenu         "create remove open"
            keylset resource create.section   0
            keylset resource create.text      "New"
            keylset resource create.action    [session::url /system/job_manager.tdp]
            keylset resource create.function  "newElement()"
            keylset resource open.section     0
            keylset resource open.text        "Job Details..."
            keylset resource open.action      [session::url /system/job_manager.tdp]
            keylset resource open.function    "resProc3('open')"
            keylset resource archive.section  0
            keylset resource archive.text     "Archive Job Entry..."
            keylset resource archive.action   [session::url /system/resource_archive.tdp]
            keylset resource archive.function "resProc3('archive')"
            keylset resource monitor.section  1
            keylset resource monitor.text     "Monitor Running Job(s)..."
            keylset resource monitor.action   [session::url /system/jobmonitor/index.tdp]
            keylset resource monitor.function "jobMonitor(this)"
            keylset resource remove.section   0
            keylset resource remove.text      "Delete Job..."
            keylset resource remove.action    [session::url /system/resource_remove.tdp]
            keylset resource remove.function  "resProc3('remove')"
        }
        Log {
            keylset resource editmenu         ""
            keylset resource filemenu         "open"
            keylset resource open.section     0
            keylset resource open.text        [translate "Log Details"]...
            keylset resource open.action      [session::url /system/log_manager/log.tdp]
            keylset resource open.function    "resProc3('open')"
        }
        CustIndex {
            keylset resource ixck.action      [session::url /system/restore_config.tdp]
        }
        Password {
            keylset resource change.action      [session::url /system/password_change.tdp]
        }
        JobMonitor {
            keylset resource editmenu         ""
            keylset resource filemenu         ""
            keylset resource buttonsObj       ""
            keylset resource buttonsPro       "stop start"
            keylset resource stop.stext       [translate "Stop/Cancel"]
            keylset resource stop.function    "stopcancel(this)"
            keylset resource start.stext      [translate "Start now"]
            keylset resource start.function   "startnow(this)"
        }
    }
    
    if { $resource ne {} } {
        return $resource
    } else {
        return -code [TCL_ERROR] "There are no resource parameters defined for: $name"
    }
    
}

##############################################################################
