Ext.define('Dashboard.view.widget.BackupOverviewController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.backup-overview-widget',
    
    onPeriodChange: function(segmentedButton, button, pressed) {
        if (pressed) {
            var store = this.getViewModel().getStore('backupOverview');
            store.getProxy().setExtraParam('period', button.value);
            store.load();
        }
    },

    onCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
        var me = this;
        var target = e.getTarget();
        
        if (target && target.hasAttribute('data-action')) {
            var action = target.getAttribute('data-action');
            
            switch (action) {
                case 'view-plan':
                    var planName = target.getAttribute('data-name');
                    me.viewPlan(planName);
                    break;
                case 'view-job':
                    var jobId = target.getAttribute('data-jobid');
                    me.viewJob(jobId);
                    break;
                case 'view-pool':
                    var poolName = target.getAttribute('data-name');
                    me.viewPool(poolName);
                    break;
            }
        }
        
        // Wenn auf den "more dirs" Eintrag geklickt wurde, zeige alle Verzeichnisse an
        if (target && target.className === 'more-dirs') {
            var dirs = record.get('dirlist');
            Ext.Msg.show({
                title: 'Backup Source Directories',
                message: dirs.join('<br>'),
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.INFO
            });
        }
        
        // Wenn auf den "more pools" Eintrag geklickt wurde, zeige alle Pools an
        if (target && target.className === 'more-pools') {
            var pools = record.get('eventPools');
            Ext.Msg.show({
                title: 'Next Pools',
                message: pools.join('<br>'),
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.INFO
            });
        }
    },
    
    viewPlan: function(planName) {
        // Weiterleitung zur Plan-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('BackupPlan', planName);
        }
    },
    
    viewJob: function(jobId) {
        // Weiterleitung zur Job-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Job', jobId);
        }
    },
    
    viewPool: function(poolName) {
        // Weiterleitung zur Pool-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Pool', poolName);
        }
    }
});