//#############################################################################

//config.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

console.log('Dashboard started');

Ext.define("Dashboard.Application", {
    extend: "Ext.app.Application",
    name: "Dashboard",
    launch: function() {
        Ext.state.Manager.setProvider(new Ext.state.LocalStorageProvider({
            prefix: 'dashboard-'
        }));
        var window_tree = Ext.create('Dashboard.view.Main', {
            layout: 'border',
            padding: '0',
            border: false
        });
	    Ext.getCmp('centercenter').add(window_tree);
    }
});

blockBrowser(false);

Ext.onReady(function() {

    Ext.define('Dashboard.globals',{
        singleton : true,
        attention: 0,
        jobmonitorstoreLoop: null,
        joblogstoreLoop: null,
        serverpage: document.dashboardForm.startTdp.value,
    });

    Ext.scopeCss = true;
    Ext.application({
        name: "Dashboard",
        extend: "Dashboard.Application",
        appFolder: '/lexxapp/dashboard',
        requires: [
            'Dashboard.view.Main'
        ]
    });

    Ext.Ajax.on('requestexception', function(con, resp, op, e) {
        if (resp && resp.status === 404) {
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Page not found!') );
            },200);
        } else if (resp && resp.status === 500) {
            Dashboard.globals.attention = 1;
            // delay needed because of refreshing after loading will overwrite the Msg
            setTimeout(function(){
                Ext.Msg.show({
                    title:'Session Expired',
                    message: resp.responseText + '<br>' + resp.statusText,
                    buttons: Ext.Msg.YESNO,
                    buttonText:{ 
                        yes: "Login", 
                        no: 'Cancel' 
                    },
                    icon: Ext.Msg.WARNING,
                    fn: function(btn) {
                        if (btn === 'yes') {
                            console.log('Reloading');
                            window.location.href=window.location.href.split('#')[0]
                        }
                    }
                });
            },200);
        } else if (resp && resp.status === 0) {
            Dashboard.globals.attention = 1;
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Server has aborted the connection'));
            },200);
        } else if (resp && resp.status !== undefined) {
            setTimeout(function(){
                Ext.Msg.alert('Error', Ext.util.Format.htmlEncode('Server connection error: ') + resp.status );
            },200);
        } else {
            Dashboard.globals.attention = 1;
            setTimeout(function(){
                Ext.Msg.alert('Error', 'Server error');
            },200);
        }
    });
	
});

function CalcSize(kbytes) {

    var bytes = kbytes * 1024;  
    var precision = 2;
    var kilobyte  = 1024;
    var megabyte  = kilobyte * 1024;
    var gigabyte  = megabyte * 1024;
    var terabyte  = gigabyte * 1024;
      
   	if ( bytes == 0 ) {
        return '--';   	
    } else if ((bytes >= 0) && (bytes < kilobyte)) {
        return bytes + ' bytes';
 
    } else if ((bytes >= kilobyte) && (bytes < megabyte)) {
        return (bytes / kilobyte).toFixed(precision) + ' KiB';
 
    } else if ((bytes >= megabyte) && (bytes < gigabyte)) {
        return (bytes / megabyte).toFixed(precision) + ' MiB';
 
    } else if ((bytes >= gigabyte) && (bytes < terabyte)) {
        return (bytes / gigabyte).toFixed(precision) + ' GiB';
 
    } else if (bytes >= terabyte) {
        return (bytes / terabyte).toFixed(precision) + ' TiB';
 
    } else {
        return bytes + ' bytes';
    }
};

Ext.define('Dashboard.overrides.SegmentedButtonState', {
    override: 'Ext.button.Segmented',

    getState: function() {
        return {
            value: this.getValue()
        };
    },

    applyState: function(state) {
        var me = this;
        var valueToSet;
        
        // Take value from state, if available
        if (state && state.value !== undefined) {
            valueToSet = state.value;
        } 
        // Otherwise, use the value of the first button as the default
        else if (me.items.getCount() > 0) {
            valueToSet = me.items.getAt(0).value;
        }
        if (valueToSet !== undefined) {
            var button = me.items.findBy(function(item) {
                return item.value === valueToSet;
            });
            
            if (button) {
                // Set button directly with toggle event
                button.setPressed(true);
            }
        }
    },

    afterRender: function() {
        this.callParent(arguments);
        // If no button is pressed, we set the default
        if (!this.items.findBy(function(item) { return item.pressed; })) {
            this.applyState(null);
        }
    }
});