//#############################################################################

//LTFSPanelController.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

Ext.define("P5LTFS.view.LTFSPanelController", {
    extend: "Ext.app.ViewController",
    alias: "controller.ltfspanel",
    init: function() {
 		var me = this;
        me.control({
            '#p5showvolumes_id': {
                 change: me.onP5showHide
            },
            '#drive_slot_grid_id': {
                 beforeselect: me.onLTFSselect,
                 itemmouseenter: me.onLTFSmouseover
            },
            '#readwritstatus_id button[action=cancelReadWrite]': {
                click: me.onJobStop
            },
            '#ltfsclienttabpanel_id': {
                select: me.onLtfsClientSelect
            },
            '#ltfsservervolumegrid_id': {
                viewready: function(a,b,c) {
                    console.log('ltfsservervolumegrid viewready');
                    var volumeType = me.getViewModel().get('volumeType');
                    var volumePath = me.getViewModel().get('volumePath');
                    var volume_store = me.getStore('servervolumestore');
                    volume_store.proxy.extraParams.hostname = 'localhost';
                    volume_store.proxy.extraParams.volumeType = volumeType;
                    volume_store.proxy.extraParams.volumePath = volumePath;
                    volume_store.load();
                },
                select: me.onLtfsVolumeSelect
            },
            '#ltfsarchivegrid_id': {
                select: me.onLtfsVolumeSelect
            },
            '#ltfsfoldercontentgrid_id': {
                select: function(me,rec,index) {
                    var node = me.getStore().getNodeById(rec.get('id'));
                    // check if checkboxes are visible
                    var chkd = node.get('checked')
                    if (chkd !== null && chkd !== undefined) {
                        node.set("checked", true);
                    }
                }
            },
            '#tabpanelOnlineArchive_id': {
                tabchange: me.onLtfsOnlineArchiveGrid
            }
		});
    },
    onLtfsOnlineArchiveGrid: function(tabPanel, newTab, oldTab) {
		var me = this;
		console.log('onLtfsOnlineArchiveGrid');
        var volume_store = newTab.getStore();
		console.log(volume_store);
		volume_store.removeAll();
        volume_store.load();
    },
    onLtfsClientSelect: function(view, record, item, index, event) {
		var me = this;
		console.log('onLtfsClientSelect');
		console.log(record.data.name);
        var volume_store = me.getStore('servervolumestore');
		volume_store.removeAll();
        volume_store.proxy.extraParams = {
            caller: 'ajaxGetLTFSserverVolume',
            hostname: record.data.name,
            volumeType: 'disk',
            volumePath: '',
            volumePool: ''
        };
        volume_store.load();
    },
    onLtfsVolumeSelect: function(view, record, item, index, event) {
		var me = this;
        console.log('onLtfsVolumeSelect');
        var folder_store = me.getStore('foldercontentstore');
		folder_store.removeAll();
		folder_store.setRootNode({});
		var newRoot = {
			expanded: true,
            nodes: [{
			    name: record.get('name'),
			    id: record.get('elementurl'),
			    path: record.get('path'),
    			iconCls: 'leafIcon_Dir',
			    //checked: false,
			    expanded: true,
            }]
		}
		folder_store.setRootNode(newRoot);           
    },
    onLTFSmouseover: function(view, record, item) {
        me = this;
        var jbpos = record.get('jbpos')
        if ( record.get('p5used') > 0 ) {
            Ext.fly(item).set({'data-qtip': $$('At this location is a P5 volume: ') + record.get('qtip')});
        } else if ( !record.get('occupied') ) {
            Ext.fly(item).set({'data-qtip': $$('This location is empty'+' ('+jbpos+')')});
        }
    },
    onLTFSselect: function(row, record, index, eOpts) {
        me = this;
        console.log('onLTFSselect');
        if ( record.get('p5used') > 0 || !record.get('occupied')) {
            return false;
        }
    },
    onLTFSStoreLoad: function( store, records, successful, eOpts ) {
        me = this;
        console.log('onLTFSStoreLoad');
        me.onP5showHide(null,false,false);
    },
    onVolumeStoreBeforeload: function( store, records, successful, operation, node, eOpts) {
        me = this;
        console.log('onVolumeStoreBeforeload');
        var folder_store = me.getStore('foldercontentstore');
		folder_store.removeAll();
		folder_store.setRootNode({});
		folder_store.loadData([],false);
        folder_store.proxy.extraParams.multiSelect = me.getViewModel().get('multiSelect');
    },
    onVolumeStoreLoad: function( store, records, successful, operation, node, eOpts) {
        me = this;
        console.log('onVolumeStoreLoad');
        var JSONdata = operation.getResponse().responseJson;
        // if set pre-select a volume
        if ( JSONdata.selected !== "" ) { 
            console.log('JSONdata.selected');
            var tree = me.lookupReference('ltfsservervolumegrid_ref');
            var node = store.getNodeById(JSONdata.selected);
            if (node !== null && node !== undefined) {
                console.log('select node');
                tree.getSelectionModel().select([node],0,0);
            }
        }
    },
    onIndexStoreLoad: function( store, records, successful, operation, node, eOpts) {
        me = this;
        console.log('onIndexStoreLoad');
        var JSONdata = operation.getResponse().responseJson;
        // if set pre-select a volume
        if ( JSONdata.selected !== "" ) { 
            console.log('JSONdata.selected');
            var tree = me.lookupReference('ltfsarchivegrid_ref');
            var node = store.getNodeById(JSONdata.selected);
            if (node !== null && node !== undefined) {
                console.log('select node');
                tree.getSelectionModel().select([node],0,0);
            }
        }
    },
    onP5showHide: function(chkbox , newValue , oldValue , eOpts) {
        console.log('onP5showHide');
        var drive_slot_grid = this.lookupReference('drive_slot_grid_ref');
        drive_slot_grid.store.clearFilter();
        if (!newValue) {
            drive_slot_grid.store.filter({
                filterFn: function(record) {
                    var isHit = false;
                    if ( record.get('p5used') === 0
                          && record.get('state') == 'occupied'
                          || record.get('indrive') != ""
                          /*|| record.get('type') == 'ie'*/
                          || record.get('type') == 'dt' ) isHit = true;

                    return isHit;
                }
            });
        }
    },
     onDiveSlotGridReload: function(grid, tool, event) {
        me = this;
        console.log('onInventoryReload');
        var drive_slot_grid = this.lookupReference('drive_slot_grid_ref');
        drive_slot_grid.store.reload();
    },
    onWriteClientToggel: function(obj) {
        me = this;
        console.log('onWriteClientToggel');
        var clientregion = Ext.ComponentQuery.query('#ltfsclienttabpanel_id')[0];
        clientregion.toggleCollapse();                
    },
    // READ READ READ READ READ READ READ READ READ READ 
    onReadStart: function(obj) {
		var me = this;
    	console.log('onReadStart');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        // in case LTO tape drive has already a mounted LTFS volume
        if (record.get('ltfs_url') != "" ) {
            me.onFilePickerReadSource();
        } else {
            var msg1 = $$('Preparing and reading a tape may take a few moments.')
            var msg2 = $$('First, the LTFS label is checked. If okay, the tape will be mounted for reading.')
            Ext.Msg.show({
                title: $$('Confirm to read from tape'),
                message: msg1 +'<p>'+ msg2 ,
                buttons: Ext.Msg.YESNO,
                buttonText:{ 
                    yes: $$('Read Tape'), 
                    no: $$('Cancel') 
                },
                icon: Ext.Msg.QUESTION,
                fn: function(btn) {
                    if (btn == 'yes') {
                        myViewPort.mask($$('Preparing to read from tape ...'));
                        Ext.Ajax.request({
                            url: document.dataForm.ltfs_config.value,
                            method: 'POST',
                            params: { 
                                caller: 'ajaxMountLTFS',
                                drive: record.get('drive'),
                                ltfs_url: record.get('ltfs_url'),
                                device: record.get('device'),
                                jbpos: record.get('jbpos'),
                                volid: record.get('volid'),
                                barcode: record.get('barcode')
                            },
                            scope: this,
                            success: function(result, request) {
                                var jobStatus = Ext.decode(result.responseText);
                                extAlert(jobStatus.attention,jobStatus.message);
                                myViewPort.unmask();
                                if ( jobStatus.ltfs_url != "" ) {
                                    me.onFilePickerReadSource(jobStatus);
                                } else {
                                    me.onDiveSlotGridReload();
                                    me.callbackNext = me.onFilePickerReadSource;
                                    me.getViewModel().set('showMonitor', false);
                                    me.onJobStatus(jobStatus);
                                }
                            },
                            failure: function(result, request) {
                                Ext.MessageBox.alert('Failed', result.responseText);
                                myViewPort.unmask();
                            }
                        });
                    }
                }		
            });
        }
    },
    onFilePickerReadSource: function(completedJobObject) {
		var me = this;
    	console.log('onFilePickerReadSource');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        // if no row is selected try to select a device record after ajaxMountLTFS
        if ( (!record || !record.length) && completedJobObject && completedJobObject.device != "" ) {
            var ltfsstore = me.getStore('ltfsstore');
            var idx = ltfsstore.findRecord('drive', completedJobObject.device);
            var row = drive_slot_grid.store.indexOf(idx);
			drive_slot_grid.getSelectionModel().select(row);
            var record  = drive_slot_grid.getSelectionModel().getSelection()[0];
        }
        me.getViewModel().setData({
            showP5Client: false,
            showNewFolder: false,
            showArchiveIndex: false,
            multiSelect: false,
            selectHandler: 'onFilePickerReadTarget',
            selectText: $$('Select'),
            filepickerTitle: $$('Select data to READ from tape'),
            volumeType: 'ltfs',
            volumePath: record.get('ltfs_url'),
            volumePool: record.get('ltfs_pool')
        })
        me.onFilePicker();
    },
    onFilePickerReadTarget: function(obj) {
		var me = this;
    	console.log('onFilePickerReadTarget');
        var picker = me.lookupReference('ltfsfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        var selectedsource = record.get('id');
        /* 5.6 disable multi select
		selectedsource = [];
        var selection = picker.getView().getChecked();
        var record    = selection[0];
		Ext.iterate(selection, function(obj, index) {
			var path = obj.get('id');
			selectedsource.push(path);
		});
		*/
        me.getViewModel().setData({
            selectedsource: selectedsource,
            showP5Client: true,
            showNewFolder: true,
            showArchiveIndex: false,
            multiSelect: false,
            selectHandler: 'onStartReadSync',
            selectText: $$('Select Target Folder'),
            filepickerTitle: $$('Select the target folder'),
            volumeType: 'disk',
            volumePath: '',
            volumePool: ''
        })
        // close file picker window
    	var picker = Ext.ComponentQuery.query('#ltfsfilePicker_id')[0];
    	if (picker) picker.close();
        myViewPort.mask($$('Preparing data source ...'));
        setTimeout(function() {
            myViewPort.unmask();
            me.onFilePicker();
        }, 2000);
    },
    onStartReadSync: function(obj) {
		var me = this;
    	console.log('onStartReadSync')
        var picker = me.lookupReference('ltfsfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        var selectedtarget = record.get('id');
    	var selectedsource = me.getViewModel().get('selectedsource');
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you really want to start the copy process?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Start Copy'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    // close file picker window
    	            var picker = Ext.ComponentQuery.query('#ltfsfilePicker_id')[0];
    	            if (picker) picker.close();
                    myViewPort.mask($$('Starting copy process ...'));
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxStartRestore',
                            selectedsource: Ext.encode(selectedsource),
                            selectedtarget: Ext.encode(selectedtarget),
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            myViewPort.unmask();
                            if ( !jobStatus.attention) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', true);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        })
    },
    //
    //
    // WRITE WRITE WRITE WRITE WRITE WRITE WRITE WRITE WRITE WRITE 
    onWriteStart: function(obj) {
		var me = this;
    	console.log('onWriteStart');
    	// setup filepicker 
        me.getViewModel().setData({
            showP5Client: true,
            showNewFolder: false,
            showArchiveIndex: true,
            multiSelect: false,
            selectHandler: 'onWriteDialog',
            selectText: $$('Select Source Folder'),
            filepickerTitle: $$('Select data to WRITE to tape'),
            volumeType: 'disk',
            volumePath: '',
            volumePool: ''
        })
        me.onFilePicker();
    },
    onWriteDialog: function(obj) {
        me = this;
        console.log('onWriteDialog');
        var picker = me.lookupReference('ltfsfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        var selectedsource = record.get('id');
        /* 5.6 disable multi select
		selectedsource = [];
        var selection = picker.getView().getChecked();
        var record    = selection[0];
		Ext.iterate(selection, function(obj, index) {
			var path = obj.get('id');
			selectedsource.push(path);
		});
		*/
        // store the selected elements and setup next panel
        me.getViewModel().setData({
            selectedsource: selectedsource,
            writedialogTitle: $$('Write to an LTFS tape') + ': ' +  record.get('name')
        })
        // close file picker window
    	var picker = Ext.ComponentQuery.query('#ltfsfilePicker_id')[0];
    	if (picker) picker.close();
        // in case LTO tape drive has already a mounted LTFS volume
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        if (record.get('ltfs_url') != "" ) {
            me.onFilePickerWriteTarget();
        } else {
            var msg1 = $$('Preparing and reading a tape may take a few moments.')
            var msg2 = $$('First the LTFS label is check. If okay the tape will be mounted for writing.')
            Ext.Msg.show({
                title: $$('Confirm to write to tape'),
                message: msg1 +'<p>'+ msg2 ,
                buttons: Ext.Msg.YESNO,
                buttonText:{ 
                    yes: $$('Write Tape'), 
                    no: $$('Cancel') 
                },
                icon: Ext.Msg.QUESTION,
                fn: function(btn) {
                    if (btn == 'yes') {
                        myViewPort.mask($$('Preparing to write to tape ...'));
                        Ext.Ajax.request({
                            url: document.dataForm.ltfs_config.value,
                            method: 'POST',
                            params: { 
                                caller: 'ajaxMountLTFS',
                                drive: record.get('drive'),
                                ltfs_url: record.get('ltfs_url'),
                                device: record.get('device'),
                                jbpos: record.get('jbpos'),
                                volid: record.get('volid'),
                                barcode: record.get('barcode')
                            },
                            scope: this,
                            success: function(result, request) {
                                var jobStatus = Ext.decode(result.responseText);
                                extAlert(jobStatus.attention,jobStatus.message);
                                myViewPort.unmask();
                                if ( jobStatus.ltfs_url != "" ) {
                                    me.onFilePickerWriteTarget(jobStatus);
                                } else {
                                    me.onDiveSlotGridReload();
                                    me.callbackNext = me.onFilePickerWriteTarget;
                                    me.getViewModel().set('showMonitor', false);
                                    me.onJobStatus(jobStatus);
                                }
                            },
                            failure: function(result, request) {
                                Ext.MessageBox.alert('Failed', result.responseText);
                                myViewPort.unmask();
                            }
                        });
                    }
                }		
            });
        }
    },
    onFilePickerWriteTarget: function(completedJobObject) {
		var me = this;
    	console.log('onFilePickerWriteTarget');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        // if no row is selected try to select a device record after ajaxMountLTFS
        if ( (!record || !record.length) && completedJobObject && completedJobObject.device != "" ) {
            var ltfsstore = me.getStore('ltfsstore');
            var idx = ltfsstore.findRecord('drive', completedJobObject.device);
            var row = drive_slot_grid.store.indexOf(idx);
			drive_slot_grid.getSelectionModel().select(row);
            var record  = drive_slot_grid.getSelectionModel().getSelection()[0];
        }
        me.getViewModel().setData({
            showP5Client: false,
            showNewFolder: true,
            showArchiveIndex: false,
            multiSelect: false,
            selectHandler: 'ajaxStartArchive',
            selectText: $$('Select Target Folder'),
            filepickerTitle: $$('Select the target folder on tape'),
            volumeType: 'ltfs',
            volumePath: record.get('ltfs_url'),
            volumePool: record.get('ltfs_pool')
        })
        me.onFilePicker();
    },
    ajaxStartArchive: function(obj) {
		var me = this;
    	console.log('ajaxStartArchive')
    	var volumePool = me.getViewModel().get('volumePool')
        var picker = me.lookupReference('ltfsfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        var selectedtarget = record.get('id');
    	var selectedsource = me.getViewModel().get('selectedsource');
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you really want to start the copy process?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Start Copy'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    // close file picker window
    	            var picker = Ext.ComponentQuery.query('#ltfsfilePicker_id')[0];
    	            if (picker) picker.close();
                    myViewPort.mask($$('Starting copy process ...'));
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxStartArchive',
                            targetPool: volumePool,
                            selectedsource: Ext.encode(selectedsource),
                            selectedtarget: Ext.encode(selectedtarget),
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            myViewPort.unmask();
                            if ( !jobStatus.attention) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', true);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        })
    },
    //
    // FilePicker FilePicker FilePicker FilePicker FilePicker FilePicker
    onFilePicker: function(obj) {
		var me = this;
    	console.log('onFilePicker');
    	var fwin = Ext.ComponentQuery.query('#ltfsfilePicker_id')[0];
    	if (!fwin) {
            fwin = me.getView().add({
                xtype: 'ltfsfilePicker',
                itemId: 'ltfsfilePicker_id',
                viewController: me
            });
        }
        fwin.show();
    },
    onNewFolder: function(obj) {
		var me = this;
        console.log('onNewFolder');
        var picker = me.lookupReference('ltfsfoldercontentgrid_ref');
        var record = picker.getSelectionModel().getSelection()[0];
        if (record) {
            Ext.Msg.prompt($$('Name of new folder'), '', function(btn, foldername){
                if (btn == 'ok') {
                    var elementurl = record.get('id');                    
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxNewFolder',
                            node: elementurl,
                            folder: foldername
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            if ( !jobStatus.attention) {
                                var folder_store = me.getStore('foldercontentstore');
		                        record.removeAll();
                                folder_store.load({ 
                                    node: record,
                                    callback : function(records, operation, success){
                                        var rootNode  = picker.getRootNode();
                                        var newObj    = rootNode.findChild('id',jobStatus.newnode, true);
                                        newObj.parentNode.expand();
                                        picker.getSelectionModel().select(newObj);
                                    }
                                });
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                };
            });
        } else {
            extAlert(2,'Please select the parent folder')
        }
    },
    //
    //
    // Progress Progress Progress Progress Progress Progress
    onJobStatus: function(startedJobObject) {
        var me = this;
       	console.log('onJobStatus');
    	var fwin = Ext.ComponentQuery.query('#readwritstatus_id')[0];
    	if (!fwin) {
            fwin = me.getView().add({
                xtype: 'readwritstatus',
                itemId: 'readwritstatus_id',
                title: $$('Status'),
                viewController: me
            });
        }
        fwin.show();
        Ext.ComponentQuery.query('readWriteShortMsg')[0].updateText($$('Please wait')+' ...');
        Ext.ComponentQuery.query('#readwritstatusform_id')[0].getForm().findField('jobname').setValue(startedJobObject.jobname);
        me.progressCheck(startedJobObject);
    },
    progressCheck: function(startedJobObject) {
        var me = this;
       	console.log('progressCheck');
        var rwin = Ext.ComponentQuery.query('#readwritstatus_id')[0];
        if (rwin.isVisible()) {
            Ext.Ajax.request({
                url: document.dataForm.ltfs_config.value,
                method: 'GET',
                params: { 
                    caller: 'ajaxGetJobProgress',
                    jobname: startedJobObject.jobname
                },
                scope: this,
                success: function(result, request) {
                    var jobStatus = Ext.decode(result.responseText);
                    extAlert(jobStatus.attention,jobStatus.message);
                    Ext.ComponentQuery.query('readWriteShortMsg')[0].updateText(jobStatus.shortmsg);
                    Ext.ComponentQuery.query('readWriteLongMsg')[0].update(jobStatus.longmsg);
                    if (jobStatus.isrunnning) {
                        setTimeout(function() {
                            me.progressCheck(startedJobObject);
                        }, 1000);
                    } else {
                        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
                        drive_slot_grid.store.on('load',function (store, records, successful, eOpts ){
                            drive_slot_grid.getSelectionModel().deselectAll();
                            if ( !jobStatus.attention && typeof me.callbackNext === 'function') me.callbackNext(jobStatus);
                        }, null, {single: true});                       
                        me.onDiveSlotGridReload();
                        setTimeout(function() {
                            Ext.ComponentQuery.query('#readwritstatus_id')[0].close();
                        }, 500);
                    }
                },
                failure: function(result, request) {
                    Ext.MessageBox.alert('Failed', result.responseText);
                }
            });
        }
    },
    //
    //
    // Cancel Job Cancel Job Cancel Job Cancel Job Cancel Job Cancel Job
    onJobResult: function(completedJobObject) {
    	console.log('onJobResult');
        Ext.MessageBox.alert({
           title: $$('Job Completed'),
           msg: completedJobObject.message+'<br>',
           icon: Ext.Msg['INFO'],
           minHeight: 200,
           minWidth: 450,
           buttons:  Ext.MessageBox.OK
        });
    },
    //
    //
    // Cancel Job Cancel Job Cancel Job Cancel Job Cancel Job Cancel Job
    onJobStop: function(btn) {
    	console.log('onJobStop');
    	var jobname = btn.up('form').getForm().findField('jobname').getValue()
		Ext.Ajax.request({
            url: document.dataForm.ltfs_config.value,
			method: 'POST',
			params: { 
				caller: 'ajaxStopJob',
				jobname: jobname
			},
			scope: this,
			success: function(result, request) {
                Ext.ComponentQuery.query('readWriteShortMsg')[0].updateText($$('Job canceled, please wait')+' ...');
			},
			failure: function(result, request) {
				Ext.MessageBox.alert('Failed', result.responseText);
			}
		});
    },
    //
    //
    // LABEL LABEL LABEL LABEL LABEL LABEL LABEL LABEL LABEL LABEL LABEL 
    onLabelDialog: function(obj) {
		var me = this;
    	console.log('onLabelStart');
        // open label dialog
    	var fwin = Ext.ComponentQuery.query('#ltfslabel_id')[0];
    	if (!fwin) {
            fwin = me.getView().add({
                xtype: 'ltfslabel',
                itemId: 'ltfslabel_id',
                viewController: me
            });
        }
        fwin.show();
    },
    onCreateFS: function() {
		var me = this;
    	console.log('onCreateFS');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        var thisForm = Ext.ComponentQuery.query('#ltfslabelform_id')[0];
        if(!thisForm.isValid()){
            Ext.Msg.alert($$('Error: Invalid serial number'),$$('Either empty or exact 6 alphanumeric characters. (A–Z, 0–9)'));
            return;
        }
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you really want to create a new file system?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Create File System'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    // close write dialog window
    	            var dialog = Ext.ComponentQuery.query('#ltfslabel_id')[0];
    	            if (dialog) dialog.close();
                    thisForm.submit({
                        waitMsg: $$('Starting process ...'),
                        submitEmptyText: false,
                        url: document.dataForm.ltfs_config.value,
                        params: {
                            caller: 'ajaxCreateFS',
                            drive: record.get('drive'),
                            device: record.get('device'),
                            jbpos: record.get('jbpos'),
                            volid: record.get('volid'),
                            barcode: record.get('barcode')
                        },
                        success:function(form, loadobj) {
                            var jobStatus = Ext.decode(loadobj.response.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            if ( !jobStatus.attention) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', false);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure:function(form, loadobj) {
                            var json = Ext.decode(loadobj.response.responseText);
                            extAlert(json.attention,json.message);
                        }
                    });
                }
            }
        });
    },
    // MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT MOUNT 
    onMountStart: function() {
		var me = this;
    	console.log('onMountStart');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you want to load and mount the LTFS media?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Mount'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    myViewPort.mask($$('Starting process ...'));
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxMountLTFS',
                            drive: record.get('drive'),
                            ltfs_url: record.get('ltfs_url'),
                            device: record.get('device'),
                            jbpos: record.get('jbpos'),
                            volid: record.get('volid'),
                            barcode: record.get('barcode')
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            myViewPort.unmask();
                            if ( !jobStatus.attention && jobStatus.ltfs_url == "" ) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', false);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        });
    },
    // UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT UNMOUNT 
    onUnmountDialog: function(obj) {
		var me = this;
    	console.log('onUnmountDialog');
        // open unmount dialog
    	var fwin = Ext.ComponentQuery.query('#ltfsunmount_id')[0];
    	if (!fwin) {
            fwin = me.getView().add({
                xtype: 'ltfsunmount',
                itemId: 'ltfsunmount_id',
                viewController: me
            });
        }
        fwin.show();
    },
    onUnmountStart: function() {
		var me = this;
    	console.log('onUnmountStart');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        //var thisForm = Ext.ComponentQuery.query('#ltfsunmountform_id')[0];
        //var unloadTo = thisForm.getForm().findField('unloadTo').getValue();
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you really want to unmount and unload the tape?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Unmount'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    // close write dialog window
    	            var dialog = Ext.ComponentQuery.query('#ltfsunmount_id')[0];
    	            if (dialog) dialog.close();
                    myViewPort.mask($$('Starting process ...'));
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxUnmountLTFS',
                            device: record.get('device'),
                            jbpos: record.get('jbpos'),
                            volid: record.get('volid'),
                            barcode: record.get('barcode'),
                            drive: record.get('drive')
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            myViewPort.unmask();
                            if ( !jobStatus.attention) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', false);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        });
    },
    onRepairStart: function() {
		var me = this;
    	console.log('onRepairStart');
        var drive_slot_grid = me.lookupReference('drive_slot_grid_ref');
        var record   = drive_slot_grid.getSelectionModel().getSelection()[0];
        Ext.Msg.show({
            title: $$('Confirmation'),
            message: $$('Do you really want to run a file system check and repair?'),
            buttons: Ext.Msg.YESNO,
            buttonText:{ 
                yes: $$('Check & Repair'), 
                no: $$('Cancel') 
            },
            icon: Ext.Msg.QUESTION,
            fn: function(btn) {
                if (btn == 'yes') {
                    myViewPort.mask($$('Starting process ...'));
                    Ext.Ajax.request({
                        url: document.dataForm.ltfs_config.value,
                        method: 'POST',
                        params: { 
                            caller: 'ajaxCheckLTFS',
                            device: record.get('device'),
                            jbpos: record.get('jbpos'),
                            volid: record.get('volid'),
                            barcode: record.get('barcode'),
                            drive: record.get('drive')
                        },
                        scope: this,
                        success: function(result, request) {
                            var jobStatus = Ext.decode(result.responseText);
                            extAlert(jobStatus.attention,jobStatus.message);
                            myViewPort.unmask();
                            if ( !jobStatus.attention) {
                                me.callbackNext = me.onJobResult;
                                me.getViewModel().set('showMonitor', false);
                                me.onJobStatus(jobStatus);
                            }
                        },
                        failure: function(result, request) {
                            Ext.MessageBox.alert('Failed', result.responseText);
                        }
                    });
                }
            }
        });
    },
});
