//#############################################################################

//config.js

//JavaScript Client Library

//See the file "license.txt" for information on usage and
//redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.


//#############################################################################

console.log('LTFS Exchange start');

Ext.define("P5LTFS.Application", {
    extend: "Ext.app.Application",
    name: "P5LTFS",
    launch: function() {
         myViewPort = Ext.create('P5LTFS.view.LTFSPanel');

        //console.log(Ext.Loader.getPath('P5LTFS'));
        //console.log(Ext.Loader.getPath('P5LTFS.view.LTFSPanelViewModel'));
    }
});
Ext.scopeCss = true;
Ext.application({
    name: "P5LTFS",
    extend: "P5LTFS.Application",
	appFolder: '/lexxapp/ltfs',
    //models: ['LTFSlocation'],
    //views: ['LTFSPanel'],
	requires: [ 
	    'P5LTFS.view.DiveSlotGrid',
	    'P5LTFS.view.LTFSOperation',
	    'P5LTFS.view.LTFSPanelViewModel',
	    'P5LTFS.view.LTFSPanelController',
	    'P5LTFS.view.ReadWriteStatus',
	    'P5LTFS.view.LTFSFilePicker',
	    'P5LTFS.view.LTFSlabel'
	],
});

// general Ext message
function extAlert(attention,msg) {
	if ( attention == 1 ) {
		var icon = Ext.Msg['ERROR'];
		var text = $$('Error');
	} else if ( attention == 2 ) {
		var icon = Ext.Msg['WARNING'];
		var text = $$('Warning');
	} else if ( attention == 3 ) {
		var icon = Ext.Msg['INFO'];
		var text = $$('Note');
	} else {
		var icon = '';
	}
	// br required because of line cropping
	if ( attention > 0 ) {
		Ext.MessageBox.alert({
		   title: text, 
		   msg: msg+'<br>',
		   icon: icon,
		   minHeight: 200,
		   minWidth: 450,
		   buttons:  Ext.MessageBox.OK
		});
	}
}

// translation
(function () {
    if (!window.$$) {
        window.$$ = function(){
            var tran = [];
            var arg = arguments;
            var msg = arg[0];
            
            var idx = 0;
            var reg = /\%s/;
            var parts = [];
            
            // try to find translation
            if(typeof AWLOC !== 'undefined') {
                var translation = AWLOC[msg];
                var msg = (translation) ? translation : msg
            };
            
            //analyze the string, extract the parts with the %s identifier.
            for ( var m = reg.exec(msg); m; m = reg.exec(msg) ) {        
                parts.push(msg.substr(0, m[0][0] == "%" ? m.index : m.index));
                parts.push("%s");
                msg = msg.substr(m.index+m[0].length);
            }
            
            parts.push(msg);
                        
            //analyze the parts, replace the %s with the given arguments. beware of undefined!
            for (var i = 0; i < parts.length; ++i){
                var part = parts[i];
                
                if (part && part === "%s") {
                    var object = arg[++idx];
                
                    if (object === undefined) {
                        tran.push("%s");
                    } else {
                        tran.push(object);
                    };
                } else {
                    tran.push(part);
                };            
            };
            return tran.join('');
        };
    };
})();