Ext.define('Dashboard.view.widget.SynchronizeOverviewController', {
    extend: 'Ext.app.ViewController',
    alias: 'controller.synchronize-overview-widget',
    
    onPeriodChange: function(segmentedButton, button, pressed) {
        if (pressed) {
            var store = this.getViewModel().getStore('synchronizeOverview');
            store.getProxy().setExtraParam('period', button.value);
            store.load();
        }
    },
        
    onCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e) {
        var me = this;
        var target = e.getTarget();
        
        if (target && target.hasAttribute('data-action')) {
            var action = target.getAttribute('data-action');
            
            switch (action) {
                case 'view-plan':
                    var planName = target.getAttribute('data-name');
                    me.viewPlan(planName);
                    break;
                case 'view-job':
                    var jobId = target.getAttribute('data-jobid');
                    me.viewJob(jobId);
                    break;
                case 'view-client':
                    var clientName = target.getAttribute('data-name');
                    me.viewClient(clientName);
                    break;
            }
        }
        
        // Wenn auf den "more dirs" Eintrag geklickt wurde, zeige alle Verzeichnisse an
        if (target && target.className === 'more-dirs') {
            var dirs = record.get('sourceDirs');
            Ext.Msg.show({
                title: 'Source Directories',
                message: dirs.join('<br>'),
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.INFO
            });
        }
    },
    
    viewPlan: function(planName) {
        // Weiterleitung zur Plan-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('SyncPlan', planName);
        }
    },
    
    viewJob: function(jobId) {
        // Weiterleitung zur Job-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Job', jobId);
        }
    },
    
    viewClient: function(clientName) {
        // Weiterleitung zur Client-Detailseite
        if (typeof actLinkRes === 'function') {
            actLinkRes('Client', clientName);
        }
    }
});