Ext.define('Dashboard.view.widget.PoolUsage', {
    extend: 'Ext.panel.Panel',
    xtype: 'pool-usage-widget',
    
    requires: [
        'Dashboard.view.widget.PoolUsageModel',
        'Dashboard.view.widget.PoolUsageController'
    ],
    
    controller: 'pool-usage',
    viewModel: {
        type: 'pool-usage'
    },
    
    layout: 'fit',
 
    items: [{
        xtype: 'cartesian',
        width: '100%',
        flipXY: true,
        insetPadding: '10 20 0 10',
        animation: false,
        bind: {
            store: '{poolUsage}'
        },
        legend: {
            type: 'dom',
            docked: 'right',
            hidden: true // Legend is necessary to prevent flickering on mouseover
        },
        captions: {
            credits: {
                text: 'Showing pools with write activity in the last 4 weeks',
                align: 'left',
                style: {
                    color: '#666',
                    fontSize: '11px',
                    fontStyle: 'italic'
                }
            }
        },
        border: 0,
        axes: [{
            type: 'numeric',
            position: 'bottom',
            grid: true,
            minimum: 0,
            maximum: 100,
            majorTickSteps: 10,
            renderer: function(axis, label) {
                return label + '%';
            }
        }, {
            type: 'category',
            fields: 'poolName',
            position: 'left',
            label: {
                text: '',
                hidden: true
            },
            grid: false
        }],
        series: [{
            type: 'bar',
            xField: 'poolName',
            yField: ['percentFilled', 'percentFree'],
            //title: [$$('Used size'), $$('Free size')],
            axis: 'bottom',
            stacked: true,
            style: {
                opacity: 0.80,
                maxBarWidth: 50,
                minGapWidth: 3
            },
            colors: ['#c6c6ec', '#f0f0f0'],
            renderer: function(sprite, config, data, index) {
                const store = data.store;
                const storeItems = store.getData().items;
                const record = storeItems[index];
                const field = sprite.getField();
                if (record) {
                    if (field === 'percentFilled') {
                        switch(record.get('usage')) {
                            case 'Archive':
                                return { fillStyle: '#ffcc33' };
                            case 'Backup':
                                return { fillStyle: '#8c8cd9' };
                            default:
                                return { fillStyle: '#f0f0f0' };
                        }
                    }
                    if (field === 'percentFree') {
                        return { fillStyle: '#f0f0f0' };
                    }
                }
            },
            label: {
                display: 'insideEnd',
                color: '#000',
                fontSize: 11,
                field: 'poolName'
            },
            tooltip: {
                trackMouse: true,
                renderer: function(tooltip, record) {
                    var used = CalcSize(record.get('usedCapacityKiB'));
                    var free = CalcSize(record.get('totalCapacityKiB') - record.get('usedCapacityKiB'));
                    tooltip.setHtml(
                        'Pool: ' + record.get('poolName') + '<br>' +
                        'Used: ' + used + '<br>' +
                        'Free: ' + free + '<br>' +
                        'Total: ' + CalcSize(record.get('totalCapacityKiB'))
                    );
                }
            }
        }]
    }]
 });