Ext.define('P5U.store.Clients', {
    extend: 'Ext.data.Store',
    model: 'P5U.model.Clients',
    autoLoad: false,
    
    proxy: {
		type: 'ajax',
		url: P5U.globals.serverpage,
		timeout: 10000,
		actionMethods: 'POST',
		extraParams: {
			caller: 'ajaxGetClients'
		},
        reader: {
            type: 'xml',
            root: 'clients',
            record: 'client'
        },
        afterRequest: function(req, res) {
            if (req.getOperation().success) {
                var panel_client = Ext.ComponentQuery.query('#clienttabpanel_id')[0];
                var client_store = panel_client.getStore();
                var cl = this.extraParams.defaultClient
                var id = client_store.find('text',cl);
                if ( id >= 0 ) {
                    panel_client.getSelectionModel().select(id);
                    panel_client.fireEvent('itemclick', panel_client, panel_client.getSelectionModel().getLastSelected());
                }
            } else {
                alert($$('Server session has expired.'))
                parent.location.href='/login/logout'
            }
        }
    },
	sorters: [{
		property: 'leaf',
		direction: 'ASC'
	},{
		property: 'name',
		direction: 'ASC'
	}]
});