DQ = Ext.DomQuery;


// add template methode for afterRequest (since ext 5.0)
Ext.define('awProxy', {
	override: 'Ext.data.proxy.Ajax', 
	
	config: {
		afterRequest: Ext.emptyFn
	}
	
});

Ext.onReady(function() {

	startApp(document.hammerForm.elementurl.value);
	
});

function startApp(elementurl) {

	Ext.define('P5U.globals',{
		singleton : true,
		serverpage: document.hammerForm.serverapp.value,
		modus: document.hammerForm.modus.value,
		nodeUrl: elementurl,
		snapshot: 0,
		previous: 0
	});
	
	Ext.application({
		name: 'P5U',

		appFolder: '/lexxapp/userapp',

		//controllers: ['Information'],
		controllers: ['Information','Restore','FilePicker'],
		// define models and stores
    	models: ['MetadataForm','Versions','Preview','Clients','ErrorMsg'],
		stores: ['MetadataForm','Versions','Preview','Clients','ServerVolume','FolderContent','IndexContent'],
		// this allows us to use the defined xtypes
    	requires: [
        	'P5U.view.InfoWindow',
        	'P5U.view.RestoreWindow',
        	'P5U.view.RestoreStatus',
        	'P5U.view.FilePicker',
        	/*'P5U.controller.Information',
        	'P5U.controller.Restore',
        	'P5U.controller.FilePicker',
        	'P5U.model.Versions',
        	'P5U.model.MetadataForm',
        	'P5U.model.Preview',
        	'P5U.model.Metadata',
        	'P5U.model.ErrorMsg',
        	'P5U.store.MetadataForm',
        	'P5U.store.Versions',
        	'P5U.store.Preview',
        	'P5U.store.ServerVolume',
        	'P5U.store.FolderContent',
        	'P5U.store.IndexContent'*/
    	],
    	launch: function() {
			console.log('Application Start');
			//Ext.create( "P5U.view.Viewport");
    	},
    	autoCreateViewport: true
    	
	});
}

