//#############################################################################
//
// start.js
//
//    JavaSribt Client Library
//
//    See the file "license.txt" for information on usage and
//    redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
//    Rcsid: @(#)$Id: start.js,v 1.72 2019/03/14 10:30:18 jd Exp $
//
//#############################################################################

Ext.Loader.setConfig({enabled: true});
//Ext.Loader.setPath("Ext.ux", "http://cdn.sencha.io/ext-4.0.7-gpl/examples/ux");
//Ext.Loader.setPath("Ext.ux", "../../../../lexxapp/lib/extjs/ux");
Ext.require([
    'Ext.grid.*',
    'Ext.tree.*',
    /*'Ext.ux.grid.FiltersFeature',*/
    'Ext.window.Window',
    'Ext.container.Viewport',
    'Ext.layout.container.Border',
    'Ext.state.*',
    'Ext.data.*'
]);

DQ = Ext.DomQuery;
/*
Ext.MessageBox.buttonText = {
   yes: $$('Yes'),
   ok: $$('OK'),
   no: $$('No'),
   cancel: $$('Cancel')
};
*/
Ext.override(Ext.LoadMask, { componentCls: 'x-loadmask' });

//Ext.BLANK_IMAGE_URL = '/lexxapp/css/ext/resources/images/tree/s.gif'

var waitboxhtml = {
    tag: 'div',
    id: 'ajxlod',
    children: [{
        tag: 'div',
        id: 'loaico',
        cls: 'ajximg', 
        children: [{
            tag: 'span',
            children: [{
                tag: 'img',
                src: '/lexxapp/img4/ajax-loader.gif'
            }]
        }]
    }]
};
waitboxTpl = Ext.DomHelper.createTemplate(waitboxhtml);

//
// start P5
//

Ext.onReady(function() {
    
    // setup the state provider, all state information will be saved to a cookie
    // Ext.state.Manager.setProvider(Ext.create('Ext.state.CookieProvider'));

    Ext.state.Manager.setProvider(Ext.create('Ext.state.LocalStorageProvider'));
    
    msproper = document.hammerForm.msproper.value;
    
    document.dataForm.platform.value  = clientPlatform;
    loadArrays();
    
    showTool  = 'tool_home';
    rowMarked  = '';
    markedIcon = 'home';
    cachedRow = new Array();
    cachedCmd = new Array();
    
    swichTo     = document.localForm.swichTo.value;
    gotoApp     = document.localForm.gotoApp.value;
    isAdminUser = document.localForm.isAdminUser.value;
    isArchive   = document.localForm.isArchive.value;
    menuSize    = document.localForm.menuSize.value;
    
    menuFrame = true;
    Ext.QuickTips.init();
    
    var msize = (menuSize == 'small') ? 32 : 94;
    
    /*
    Ext.define('Ext.bugs.view.AbstractView', {
        override: 'Ext.view.AbstractView',
        onMaskBeforeShow: function() {
            return false;        
        }
    });
    */
    
    myViewPort =  Ext.create('Ext.container.Viewport', {
        layout: 'border',
        padding: '0',
        items: [
            Ext.create('Ext.Component', {
            region: 'north',
            id: 'northmenu',
            border: false,
            height: msize,
            contentEl: 'topmenu'
        }), {
            region: 'west',
            id: 'westtool',
            border: false,
            layout: 'fit',
            width: 200,
            contentEl: 'lefttool',
            bodyStyle:'background-color: #576170;'
        },{
            region: 'center',
            layout: 'fit',
            id: 'centercenter',
            border: false,
            contentEl: 'centerdata'
        }]
    });
        
    if ( swichTo == 'Backup' ) {
        MenuSwitchToolbar('restore','restore_backup_direct')
    } else if ( swichTo == 'Archive' ) {
        MenuSwitchToolbar('restore','restore_archive_direct')
    } else if ( swichTo == 'Backup2Go' ) {
        MenuSwitchToolbar('restore','restore_backup2go_direct')
    } else if ( swichTo == 'Online' && isArchive == '1' ) {
        MenuSwitchToolbar('archive','archive_manul')
    } else if ( isAdminUser == 0 && document.getElementById('restore') ) {
            MenuSwitchToolbar('restore')
    } else if ( gotoApp != '' ) {
            //used only from license manager
            var nxt = Ext.decode(gotoApp);
            MenuSwitchToolbar(nxt[0],nxt[1]);
    } else {
        MenuSwitchToolbar('home')
    }


});

//
// tool bar
//
function MenuSwitchToolbar(swichTo,appl) {
     console.log('MenuSwitchToolbar tool: ' + swichTo + ' appl: ' + appl);
     hideMenu(markedMenu);
     document.hammerForm.sector.value = swichTo;
     if ( document.getElementById(markedIcon) ) {
        if ( markedIcon == 'home' ) {
            document.getElementById(markedIcon + ':icon').className='home_48';
        }
        document.getElementById(markedIcon).className='iconOuterBox';
    }
    if ( document.getElementById(swichTo) ) {
        if ( swichTo == 'home' ) {
            document.getElementById(swichTo + ':icon').className='home_48_a';
            document.getElementById(swichTo).className='iconOuterBoxS';
        } else {
            document.getElementById(swichTo).className='iconOuterBoxS';
        }
        markedIcon = swichTo;
    }
    if ( typeof appl == 'undefined' ) {
        // check if a tool (modul) was visit before within this session
        if ( typeof cachedRow['tool_'+swichTo] != 'undefined' && typeof cachedCmd['tool_'+swichTo] != 'undefined' ) {
            switchToolbar('tool_'+swichTo,cachedCmd['tool_'+swichTo]);
        // check if a setup exist already for the plan
        } else if ( swichTo == 'backup' || swichTo == 'backup2go' || swichTo == 'archive' || swichTo == 'synchronize' ) {
            Ext.Ajax.request({
                url: msproper,
                method: 'POST',
                params: { 
                    caller: 'setupOrOverview',
                    modul: swichTo
                },
                scope: this,
                success:function(response, options) {
                    var appl = response.responseText;
                    switchToolbar('tool_'+swichTo,appl);
                }
            });
        } else {
            // as fallback switch to default of tool (modul)
            switchToolbar('tool_'+swichTo, markedCmd['tool_'+swichTo]);
        }
    } else {
        switchToolbar('tool_'+swichTo,appl);
    }
}

function switchToolbar(tools,appl) {
    console.log('switchToolbar:  tool: ' + tools + ' appl: ' + appl);
    // if appl is set and defined overwrite the default for this area
    // This is only required if the user jumps direct to a resource from
    // a module which he not visit before within a session.
    // e.g MenuSwitchToolbar('backup','Volume')
    if (appl && cRow[tools][appl]) {
        // default e.g for tool_home is
        // markedRow['tool_home'] = 'home:0';
        // markedCmd['tool_home'] = 'GettingStarted';
        // markedRow and markedCmd is used for two reasons 
        // 1. it's defining the default rows/cmds for an tool (module)
        // 2. it learns/cached in markToolRow the rows/cmds where the user
        //    visited by click
        // the cachedRow cachedCmd are only used to check if a user
        // has already visited an tool (modul)
        markedRow[tools] = cRow[tools][appl];
        markedCmd[tools] = appl;
    }
    if ( document.getElementById(showTool) ) {
        document.getElementById(showTool).style.display   = "none";
    }
    if ( document.getElementById(showTool+'_o') ) {
        document.getElementById(showTool+'_o').style.display   = "none";
    }
    if ( document.getElementById(tools) ) {
        document.getElementById(tools).style.display   = "block";
        showTool = tools;
        markToolRow(markedRow[showTool],markedCmd[showTool]);
    }
    if ( document.getElementById(tools+'_o') ) {
        document.getElementById(tools+'_o').style.display   = "table";
    }
}

function markToolRow(row,appl) {
    console.log('markToolRow row: ' + row + ' appl: ' + appl);
    if (isBrowserBlocked()) return;
    if ( rowMarked != "" && document.getElementById(rowMarked) ) {
        var td = document.getElementById(rowMarked).cells;
        td[0].className='tbBuL';
        td[1].className='tbBuR';
    }
    if ( row.match("_o:") ) {
        var opt = row.split(':')[0];
        swOption(opt,false);
    }
    if ( document.getElementById(row) ) {
        var td = document.getElementById(row).cells;
        td[0].className='tbBuLMark';
        td[1].className='tbBuRMark';
        rowMarked = row;
        execmd = new Function(cmd[appl]);
        execmd(row);
        // it's hard to explain why two pairs of arrays are required to cache
        // a visited tool (module)
        // the markedRow and markedCmd are required because they hold already
        // the defaults for each tool (module)
        // And the cachedRow cachedCmd are used to cache the last visited row/cmd
        // from a tool (module) 
        markedRow[showTool] = row;
        markedCmd[showTool] = appl;
        cachedRow[showTool] = row;
        cachedCmd[showTool] = appl;
    }
}
function swOption(optid,isuser) {
    //console.log('swOption option: ' + optid + ' User: ' + isuser);    
    if ( document.getElementById(optid+'_a') ) {
        if ( document.getElementById(optid+'_a').className == "tbar" || !isuser ) {
            document.getElementById(optid+'_a').className = "tbad";
            showRow(2,'tool_'+optid)
        } else {
            document.getElementById(optid+'_a').className = "tbar";
            hideRow(2,'tool_'+optid)
        }
    }
}
function hideRow(rownr,optid) {
    var tr = document.getElementById(optid).rows;
    var minrow = tr.length - 2;
    if ( rownr < minrow ) {
        var row = tr.length - rownr;
        tr[row].style.display = "none";
        rownr = rownr + 1;
        setTimeout(function() { hideRow(rownr,optid) },20)
    }
}
function showRow(rownr,optid) {
    var tr = document.getElementById(optid).rows;
    var maxrow = tr.length;
    if ( rownr < maxrow ) {
        tr[rownr].style.display = "table-row";
        rownr = rownr + 1;
        setTimeout(function() { showRow(rownr,optid) },20)
    }
}
function showAdvanced(evt) {
    if ( evt.altKey && document.getElementById('tool_advanced_o') ) {
        document.getElementById('tool_advanced_o').style.display = "table";
    }
}

function startPage(res) {
    popupHide();
    if(isBrowserBlocked()) return;
    // browser block release in rsrc.js
    blockBrowser(true);
    var td  = document.getElementById(rowMarked).cells;
    var txt = td[1].innerHTML;
    var url = document.dataForm.browser_ressource.value;
    layout = res;
    //remove fix bottom bar as div element because it is not controlled by EXT
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    //if (Ext.getCmp('selection_id')) Ext.getCmp('selection_id').destroy();
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    Ext.get('centerdata').load({
        url:url,
        scripts:true,
        success: function(){
            hideWait();
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        params:{
            caller:'listing',
            layout:res,
            restext:txt
        }
    });
}
function startLoginareas(dbusage,operation) {
    popupHide();
    console.log('startLoginareas');
    if(isBrowserBlocked()) return;
    // browser block release in rsrc.js
    blockBrowser(true);
    var td  = document.getElementById(rowMarked).cells;
    var txt = td[1].innerHTML;
    var url = document.dataForm.loginareas.value;
    //remove fix bottom bar as div element because it is not controlled by EXT
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    //if (Ext.getCmp('selection_id')) Ext.getCmp('selection_id').destroy();
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    Ext.get('centerdata').load({
        url:url,
        scripts:true,
        success: function(){
            hideWait();
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        params:{
            caller:'listing',
            dbusage: dbusage,
            operation: operation
        }
    });
}
function Goto(target,dbusage,operation) {
    popupHide();
    if(isBrowserBlocked()) return;
    blockBrowser(true);
    var page = document.dataForm[target].value;
    //remove fix bottom bar as div element because it is not controlled by EXT
    rmDiv('wstreebody');
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    //if (Ext.getCmp('selection_id')) Ext.getCmp('selection_id').destroy();
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    var tmpdiv = getTempDiv('loaderdiv');
    //load data into div element
    tmpdiv.load({
        url:page,
        timeout: 180000,
        scripts:true,
        success: function(){
            hideWait();
            blockBrowser(false);
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        params:{
            dbusage:dbusage,
            operation:operation
        }
    });
    // create panel for scrolling
    var myPanel = Ext.create('Ext.panel.Panel', {
        contentEl: 'loaderdiv',
        layout: 'fit',
        autoScroll: true,
        //bodyStyle:{"background-color":"#F7F7F7"},
        border: false
    });
    //add panel to region
    Ext.getCmp('centercenter').add(myPanel);

}
// direct jump into tree
function directIndex() {
    //get url plus form params
    var browser_filelist = document.dataForm.browser_index.value;
    rmDiv('wstreebody');
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    Ext.get('centerdata').load({
        url:browser_filelist,
        scripts:true,
        success: function(){
            hideWait();
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }
    });
}
// dashboard
function dashboard() {
    popupHide();
    if(isBrowserBlocked()) return;
    blockBrowser(true);
    var url  = document.dataForm.dashboard.value;
    rmDiv('wstreebody');
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    Ext.get('centerdata').load({
        url:url,
        scripts:true,
        success: function(){
            hideWait();
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        params:{
            caller:'listing',
        }
    });
}
// dashboard_module
function dashboard_module(module) {
    popupHide();
    if(isBrowserBlocked()) return;
    blockBrowser(true);
    var url  = document.dataForm[module].value;
    rmDiv('wstreebody');
    rmDiv('loaderdiv');
    rmDiv('fixButton');
    Ext.getCmp('centercenter').removeAll();
    waitBox('centerdata');
    Ext.get('centerdata').load({
        url:url,
        scripts:true,
        success: function(){
            hideWait();
        },
        failure: function(){
            extAlert(1,'Could not connect to server')
        }, 
        params:{
            caller:'listing',
        }
    });
}
function loadArrays(eButton) {
    // defaults for row to mark and command/page to execute
    markedRow = new Array();
    markedRow['tool_home']        = 'home:0';
    //markedRow['tool_legacy']      = 'home:3';
    markedRow['tool_backup']      = 'backup:0';
    markedRow['tool_archive']     = 'archive:0';
    markedRow['tool_backup2go']   = 'backup2go:0';
    markedRow['tool_synchronize'] = 'synchronize:0';
    markedRow['tool_agent']       = 'agent:0';
    markedRow['tool_restore']     = 'restore:0';
    markedCmd = new Array();
    markedCmd['tool_home']        = 'GettingStarted';
    markedCmd['tool_backup']      = 'backup_starter';
    markedCmd['tool_backup2go']   = 'backup2go_starter';
    markedCmd['tool_synchronize'] = 'sync_starter';
    markedCmd['tool_agent']       = 'agent_starter';
    markedCmd['tool_archive']     = 'archive_starter';
    markedCmd['tool_restore']     = 'restore_starter';
    // definition which is js-command is to execute
    cmd = new Array();
    cmd['GettingStarted']    = 'dashboard()';
    //cmd['Legacy']            = 'Goto("home_legacy")';

    cmd['backup_setup']      = 'Goto("backup_setup")';
    cmd['backup_starter']    = 'Goto("backup_starter")';
    cmd['backup_overview']   = 'Goto("backup_overview")';
    
    cmd['archive_setup']     = 'Goto("archive_setup")';
    cmd['archive_starter']   = 'Goto("archive_starter")';
    cmd['archive_overview']  = 'Goto("archive_overview")';
    
    cmd['sync_setup']        = 'Goto("sync_setup")';
    cmd['sync_starter']      = 'Goto("sync_starter")';
    cmd['sync_overview']     = 'Goto("sync_overview")';

    cmd['backup2go_starter']  = 'Goto("backup2go_starter")';
    cmd['backup2go_overview'] = 'Goto("backup2go_overview")';
    
    cmd['agent_starter']     = 'Goto("agent_starter")';
    //cmd['archive_manul']     = 'Goto("archive_manul","Online","Archive")';
    cmd['archive_manul']     = 'startLoginareas("Online","Archive")';
    cmd['archive_migrate']   = 'Goto("archive_migrate","Online","Archive")';
    cmd['migrate_setup']     = 'Goto("migrate_setup","Online","Archive")';
    //cmd['synchronize_manul'] = 'Goto("synchronize_manul","Online","Synchronize")';
    cmd['synchronize_manul'] = 'startLoginareas("Online","Synchronize")';
    cmd['restore_starter']   = 'Goto("restore_starter")';
    //cmd['restore_backup']    = 'Goto("restore_backup","Backup","Restore")';
    cmd['restore_backup']    = 'startLoginareas("Backup","Restore")';
    //cmd['restore_archive']   = 'Goto("restore_archive","Archive","Restore")';
    cmd['restore_archive']    = 'startLoginareas("Archive","Restore")';
    //cmd['restore_synchronize']   = 'Goto("restore_synchronize","Synchronize","Synchronize")';
    cmd['restore_synchronize']   = 'startLoginareas("Synchronize","Synchronize")';
    cmd['restore_backup2go'] = 'Goto("restore_backup2go","Workstation")';
    cmd['restore_backup_direct']    = 'directIndex()';
    cmd['restore_backup2go_direct'] = 'directIndex()';
    cmd['restore_archive_direct']   = 'directIndex()';
    cmd['BackupPlan']  = 'startPage("BackupPlan")';
    cmd['ArchivePlan'] = 'startPage("ArchivePlan")';
    cmd['MigrationPlan'] = 'startPage("MigrationPlan")';
    cmd['VerifyPlan'] = 'startPage("VerifyPlan")';
    cmd['ObjectBucket'] = 'startPage("ObjectBucket")';
    cmd['SyncPlan']    = 'startPage("SyncPlan")';
    cmd['Backup2Go']   = 'startPage("Backup2Go")';
    cmd['Client']      = 'startPage("Client")';
    cmd['Server']      = 'startPage("Server")';
    cmd['License']     = 'startPage("License")';
    cmd['Workstation'] = 'startPage("Workstation")';
    cmd['Filter']      = 'startPage("Filter")';
    cmd['Storagemanager'] = 'startPage("Storagemanager")';
    cmd['Pool']        = 'startPage("Pool")';
    cmd['Volume']      = 'startPage("Volume")';
    cmd['Database']    = 'startPage("Database")';
    cmd['Userpref']    = 'startPage("UserPref")';
    cmd['Grouppref']   = 'startPage("GroupPref")';
    cmd['Loginarea']   = 'startPage("LoginArea")';
    cmd['Translation'] = 'startPage("Translation")';
    cmd['Logout']      = 'logoutSession()';
    // definition for direct jumps (from menu) to pages
    cRow = new Array();
    cRow['tool_home'] = [];
    cRow['tool_home']['License'] = 'home:1';
    cRow['tool_backup'] = [];
    cRow['tool_backup']['backup_starter'] = 'backup:0';
    cRow['tool_backup']['backup_overview'] = 'backup:1';
    cRow['tool_backup']['Client'] = 'backup:2';
    cRow['tool_backup']['Storagemanager'] = 'backup:3a';
    cRow['tool_backup']['BackupPlan'] = 'backup:6';
    cRow['tool_backup']['Volume'] = 'backup:8';
    cRow['tool_backup']['Loginarea'] = 'backup_o:5';
    cRow['tool_backup2go'] = [];
    cRow['tool_backup2go']['backup2go_overview'] = 'backup2go:1';
    cRow['tool_archive'] = [];
    cRow['tool_archive']['archive_overview'] = 'archive:1';
    cRow['tool_archive']['archive_manul'] = 'archive:2';
    cRow['tool_archive']['Client'] = 'archive:3';
    cRow['tool_archive']['Storagemanager'] = 'archive:4a';
    cRow['tool_archive']['ArchivePlan'] = 'archive:6';
    cRow['tool_archive']['Volume'] = 'archive:9';
    cRow['tool_archive']['MigrationPlan'] = 'archive:11';
    cRow['tool_archive']['VerifyPlan'] = 'archive:12';
    cRow['tool_archive']['ObjectBucket'] = 'archive:13';
    cRow['tool_archive']['Database'] = 'archive_o:4';
    cRow['tool_archive']['Loginarea'] = 'archive_o:5';
    cRow['tool_archive']['ObjectBucket'] = 'archive_o:6';
    cRow['tool_synchronize'] = [];
    cRow['tool_synchronize']['sync_overview'] = 'synchronize:1';
    cRow['tool_synchronize']['synchronize_manul'] = 'synchronize:2';
    cRow['tool_synchronize']['Client'] = 'synchronize:3';
    cRow['tool_synchronize']['SyncPlan'] = 'synchronize:5';
    cRow['tool_synchronize']['Loginarea'] = 'synchronize_o:5';
    cRow['tool_restore'] = [];
    cRow['tool_restore']['restore_backup']    = 'restore:1';
    cRow['tool_restore']['restore_backup2go'] = 'restore:2';
    cRow['tool_restore']['restore_archive']   = 'restore:3';
    cRow['tool_restore']['restore_synchronize']   = 'restore:4';
    cRow['tool_restore']['restore_backup_direct']    = 'restore:1';
    cRow['tool_restore']['restore_backup2go_direct'] = 'restore:2';
    cRow['tool_restore']['restore_archive_direct']   = 'restore:3';
    cRow['tool_agent'] = [];
    cRow['tool_agent']['agent_starter'] = 'agent:0';
}
//
// top menu
//

function showMenu(e,box) {
    popupMenu(e,box);
    if ( document.getElementById(box+'_top') ) {
        markedMenu  = box;
        document.getElementById(box+'_top').className=box+'_a';
    }
}

function menuReSize(size) {
    nowWaitXXL();
    document.menuForm.menuSize.value = size
    document.menuForm.submit()
}

//
// new Ext part
//
Ext.define('Ext.ux.tab.Tab', {
    extend: 'Ext.tab.Tab',
    alias: 'widget.ux.menutab',
    requires: [
        //We just need the onClick from Split button
        'Ext.button.Split'
    ],

    /**
     * Menu align, if you need to hack the menu alignment
     */
    menuAlign: 'tl-bl?',

    constructor: function() {
        this.callParent(arguments);

        //Kind of harsh, we need the click action from
        //split button instead.
        //Or if you preferred, you can always override this
        //function and write your own handler.
        this.onClick = Ext.button.Split.prototype.onClick;
    },


    /**
     * Hack the default css class and add
     * some resonable padding so to make it looks
     * great :)
     */
    onRender: function() {
        this.callParent(arguments);
        //We change the button wrap class here! (HACK!)
        //this.btnWrap.replaceCls('x-tab-arrow x-tab-arrow-right','x-btn-split x-btn-split-right');
        this.btnWrap.replaceCls('x-tab-wrap x-tab-arrow x-tab-arrow-right','x-btn-wrap x-btn-split x-btn-split-right');
        // !important is not working with setStyle
        //this.btnWrap.setStyle('padding-right', '30px !important');
        var elm = this.btnWrap.getAttribute('id');
        document.getElementById(elm).setAttribute('style', 'padding-right:25px !important;');
    }
});

// to render column with mulible rows
function rendercolrows(value, metaData, record, rowIndex, colIndex, store, view) {
    var dirs = "";
    var paths = Ext.decode(value);
    for(var i in paths) {
        var dirs = dirs+'<div>'+paths[i]+'</div>';
    }
    if (paths.length > 1 ) {
        metaData.tdAttr = 'data-qtip="' + Ext.String.htmlEncode(dirs) + '"';
        return '<div>'+paths[0]+'</div><div>...</div>';
    } else {
        return Ext.String.htmlEncode(paths[0]);
    }
}
// to render rsrc icon
function renderIcon(value, metaData, record, rowIndex, colIndex, store, view) {
    var icon = AWRSRCICON[value];
    if (!icon) return
    metaData.style = 'padding:3px 2px 1px 2px;'
    return '<span class="icon_' + record.data['rsrc_status'] + '"></span><img src="'+icon+'">';
}
// to render rsrc icon
function renderVolumeIcon(value, metaData, record, rowIndex, colIndex, store, view) {
    var icon = AWRSRCICON[value];
    if (!icon) return;
    metaData.style = 'padding:3px 2px 1px 2px;';
    var statusTooltips = {
        'StaleStats': 'Size calculation required - Use Update statistics',
        'OutOfSync': 'Synchronization pending - Use Re-sync Cloud Volume(s)',
        'Disabled': 'Tape disabled',
        'Suspect': 'Tape defective/suspect'
    };
    var status = record.data['rsrc_status'];
    var tooltip = statusTooltips[status] || '';
    return '<span class="icon_' + status + '" data-qtip="' + tooltip + '"></span>' +
           '<img src="' + icon + '">' +
           '<span class="icon_nanopure_' + record.data['rsrc_nanopureQuality'] + '"></span>';
}
// to render rsrc icon
function renderIndexType(value, metaData, record, rowIndex, colIndex, store, view) {
	return value;
}
// caculate from clock seconds to days and weeks
function calcDaysWeek(value, metaData, record, rowIndex, colIndex, store, view) {
    return AWCLKDAYS[value] ? AWCLKDAYS[value] : calcDays(value);
}
// caculate from clock seconds to days and weeks
function calcDays(value, metaData, record, rowIndex, colIndex, store, view) {
	var ftime = "";
	var t = parseInt(value);
	var days = parseInt(t/86400);
	if (days > 0) ftime += (days > 1) ? days+' '+$$('days')+' ' : days+' '+$$('day')+' ';
	
	t = t-(days*86400);
	var hours = parseInt(t/3600);
	if (hours > 0) ftime += (hours > 1) ? hours+' '+$$('hours')+' ' : hours+' '+$$('hour')+' ';
	
	t = t-(hours*3600);
	var minutes = parseInt(t/60);
	if (minutes > 0) ftime += (minutes > 1) ? minutes+' '+$$('minutes')+' ' : minutes+' '+$$('minute')+' ';

	t = t-(minutes*60);
	if (t > 0) ftime += (t > 1) ? t+' '+$$('seconds') : t+' '+$$('second');

    return ftime;
}
// caculate bytes (for config) in other measurement units
function calcSize(bytes) {
    var precision = 2;
    var kilobyte  = 1;
    var megabyte  = kilobyte * 1024;
    var gigabyte  = megabyte * 1024;
    var terabyte  = gigabyte * 1024;
   
    if ((bytes >= 0) && (bytes < kilobyte)) {
        return bytes + ' bytes';
 
    } else if ((bytes >= kilobyte) && (bytes < megabyte)) {
        return (bytes / kilobyte).toFixed(precision) + ' KiB';
 
    } else if ((bytes >= megabyte) && (bytes < gigabyte)) {
        return (bytes / megabyte).toFixed(precision) + ' MiB';
 
    } else if ((bytes >= gigabyte) && (bytes < terabyte)) {
        return (bytes / gigabyte).toFixed(precision) + ' GiB';
 
    } else if (bytes >= terabyte) {
        return (bytes / terabyte).toFixed(precision) + ' TiB';
 
    } else {
        return bytes;
    }
}
// caculate bytes for index
function calcSizeIdx(bytes, metaData, record, rowIndex, colIndex, store, view) {
    var precision = 2;
    var kilobyte  = 1024;
    var megabyte  = kilobyte * 1024;
    var gigabyte  = megabyte * 1024;
    var terabyte  = gigabyte * 1024;

	if ( record.data.type == "Directory" ) {
        return '--';   	
    } else if ((bytes >= 0) && (bytes < kilobyte)) {
        return bytes + ' bytes';
 
    } else if ((bytes >= kilobyte) && (bytes < megabyte)) {
        return (bytes / kilobyte).toFixed(precision) + ' KiB';
 
    } else if ((bytes >= megabyte) && (bytes < gigabyte)) {
        return (bytes / megabyte).toFixed(precision) + ' MiB';
 
    } else if ((bytes >= gigabyte) && (bytes < terabyte)) {
        return (bytes / gigabyte).toFixed(precision) + ' GiB';
 
    } else if (bytes >= terabyte) {
        return (bytes / terabyte).toFixed(precision) + ' TiB';
 
    } else {
        return bytes + ' bytes';
    }
}
// pre-defined date formats
Ext.Date.patterns = {
    formatDateTimeInt:"d-M-Y H:i",
    formatDateInt:"d-M-Y",
    ISO8601Long:"Y-m-d H:i:s",
    ISO8601Short:"Y-m-d",
    ShortDate: "n/j/Y",
    LongDate: "l, F d, Y",
    FullDateTime: "l, F d, Y g:i:s A",
    MonthDay: "F d",
    ShortTime: "g:i A",
    LongTime: "g:i:s A",
    SortableDateTime: "Y-m-d\\TH:i:s",
    UniversalSortableDateTime: "Y-m-d H:i:sO",
    YearMonth: "F, Y",
    formatDateTimeLongDe: "D d.M.Y H:i",
    formatDateTimeShortDe: "d.M.Y H:i",
    formatDateTimeDe: "d.m.y H:i",
    formatDateTimeLongUSA: "D M d, Y h:i a",
    formatDateTimeShortUSA: "d M Y h:i a",
    formatDateShortUSA: "d M Y",
    formatDateTimeUSA: "m/d/y h:i a",
    formatDateUSA: "m/d/y",
    formatTimeShort: "d.M H:i",
    formatDateTimeJa: "y/m/d h:i a"
};

var AWRSRCICON = {
    License     : '/lexxapp/img4/license_16.png',
    LoginArea   : '/lexxapp/img4/loginarea_16.png',
    Client      : '/lexxapp/img4/clients_16.png',
    Workstation : '/lexxapp/img4/workstation_16.png',
    Server      : '/lexxapp/img4/server_16.png',
    Backup2Go   : '/lexxapp/img4/workstations_16.png',
    Translation : '/lexxapp/img4/translate_16.png',
    Database    : '/lexxapp/img4/database_16.png',
    UserPref    : '/lexxapp/img4/user_pref_16.png',
    GroupPref   : '/lexxapp/img4/user_pref_16.png',
    DeviceType  : '/lexxapp/img4/unknown.png',
    JukeboxType : '/lexxapp/img4/unknown.png',
    Device      : '/lexxapp/img4/TAPE_device_16.png',
    Device_DISK : '/lexxapp/img4/DISK_device_16.png',
    Device_TAPE : '/lexxapp/img4/TAPE_device_16.png',
    Device_CONTAINER : '/lexxapp/img4/TAPE_device_16.png',
    Jukebox     : '/lexxapp/img4/jukebox_16.png',
    Pool_TAPE   : '/lexxapp/img4/Pool_TAPE_16.png',
    Pool_DISK   : '/lexxapp/img4/Pool_DISK_16.png',
    Pool_CONTAINER : '/lexxapp/img4/Pool_DISK_16.png',
    Pool_CLOUD  : '/lexxapp/img4/Pool_CLOUD_16.png',
    Pool_UPLOAD : '/lexxapp/img4/Pool_UPLOAD_16.png',
    ArchivePlan : '/lexxapp/img4/scheduler_16.png',
    BackupPlan  : '/lexxapp/img4/scheduler_16.png',
    SyncPlan    : '/lexxapp/img4/scheduler_16.png',
    MigrationPlan : '/lexxapp/img4/scheduler_16.png',
    VerifyPlan  : '/lexxapp/img4/scheduler_16.png',
    ObjectBucket : '/lexxapp/img4/objectstorage_16.png',
    Volume      : '/lexxapp/img4/volume_16.png',
    Volume_DISK : '/lexxapp/img4/DISK_volume_16.png',
    Volume_CONTAINER : '/lexxapp/img4/DISK_volume_16.png',
    Volume_TAPE : '/lexxapp/img4/TAPE_volume_16.png',
    Volume_CLOUD : '/lexxapp/img4/CLOUD_volume_16.png',
    Job         : '/lexxapp/img4/job_16.png',
    Filter      : '/lexxapp/img4/filter_16.png',
    Log         : '/lexxapp/img4/log_16.png',
    ObjectStore : '/lexxapp/img4/objectstorage_16.png',
    Noaccess    : '/lexxapp/img4/no_access_16.png'
};

var AWCLKDAYS = {
      86400 : '1 '+ $$('day'),
     172800 : '2 '+ $$('days'),
     259200 : '3 '+ $$('days'),
     345600 : '4 '+ $$('days'),
     432000 : '5 '+ $$('days'),
     518400 : '6 '+ $$('days'),
     604800 : '1 '+ $$('week'),
    1209600 : '2 '+ $$('weeks'),
    1814400 : '3 '+ $$('weeks'),
    2419200 : '4 '+ $$('weeks'),
    4838400 : '8 '+ $$('weeks'),
    7257600 : '12 '+ $$('weeks')
};

function sumVolSizeFree(records){
	var sumSize = 0;
	var sumEsti = 0;
	var sumFree = 0;
	var record;
	for (var i = 0; i < records.length; ++i) {
		record = records[i];
		if ( record.data['rsrc_mode'] != 'Recyclable' ) {
			sumSize += parseInt(record.data['rsrc_usedSize']);
		}
		sumEsti += record.data['rsrc_estimatedSize'];
	}
	sumFree = sumEsti - sumSize;
	return { sumSize: sumSize, sumEsti: sumEsti, sumFree: sumFree };
}

function renderSumVolSize(obj){
	var nrleds = 10;
	var sumSize = obj.sumSize;
	var sumEsti = obj.sumEsti;
	var sumFree = obj.sumFree;
	if ( sumEsti > 0 ) {
		var leds = (nrleds * sumSize / sumEsti).toFixed(0);
		if ( leds > nrleds || leds < 0 ) {
			var leds = nrleds;
		}
	} else {
		var leds = 0;
	}
	var usize = calcSize(obj.sumSize);    
	var fsize = calcSize(obj.sumFree);    
	var str   = 'free';    
	return '<img style="position:relative;top:3px" src="/lexxapp/img4/fill-'+ leds +'.png"/><span style="padding-left:5px">'+ usize +'</span><span style="padding-left:5px">('+ fsize +' '+ str + ')</span>';
}


// render volume size leds
function renderVolSize(value, metaData, record, rowIndex, colIndex, store, view) {

    var nrleds = 10;
    var rsrc_usedSize      = value;
    var rsrc_mode          = store.getAt(rowIndex).data.rsrc_mode;
    var rsrc_estimatedSize = store.getAt(rowIndex).data.rsrc_estimatedSize;

    if ( rsrc_mode == 'Recyclable' ) {
        var leds = 'Recyclable';
    // Check on usedSize can be removed in 8.0. This is only temporary.
    } else if ( rsrc_usedSize < 0 ) {
        var leds = "Unlimited";
    } else if ( rsrc_estimatedSize != 0 ) {
        var leds = (nrleds * rsrc_usedSize / rsrc_estimatedSize).toFixed(0);
        if ( leds > nrleds || leds < 0 ) {
            var leds = nrleds;
        }
    } else {
        var leds = 0;
    }
    
    var usize = calcSize(rsrc_usedSize);    
    return '<img style="position:relative;top:3px" src="/lexxapp/img4/fill-'+ leds +'.png"/><span style="padding-left:5px">'+ usize +'</span>';
};
// render pool size leds
function renderPoolSize(value, metaData, record, rowIndex, colIndex, store, view) {

    var nrleds  = 10;
    var sumSize = value;
    var sumEsti   = store.getAt(rowIndex).data.esti;
    var mediaType = store.getAt(rowIndex).data.rsrc_mediaType;
     
    if ( mediaType != "CONTAINER" ) {
        // Check on usedSize can be removed in 8.0. This is only temporary.
        if ( sumSize < 0 ) {
            var leds = "Unlimited";
        } else if ( sumEsti > 0 ) {
            var leds = (nrleds * sumSize / sumEsti).toFixed(0);
            if ( leds > nrleds || leds < 0 ) {
                var leds = nrleds;
            }
        } else {
            var leds = 0;
        }
    } else {
        var leds = "Unlimited";
    }
    
    var usize = calcSize(sumSize);    
    return '<img style="position:relative;top:3px" src="/lexxapp/img4/fill-'+ leds +'.png"/><span style="padding-left:5px">'+ usize +'</span>';
};
// render date as pre-defined in Ext.Date.patterns
function renderDate (value, metaData, record, rowIndex, colIndex, store, view) {
    if ( value > 0 ) {
        var clockSeconds = new Date( value * 1000);
        return Ext.Date.format(value, Ext.Date.patterns[userDateFormat]);
    } else {
        return '';
    }
};
function switchOption(page,flag) {
    Ext.get('loaderdiv').load({url:page,scripts:true, params:{showlic:flag}});
};
function showDirs(row) {
    document.getElementById('ps_right'+row).style.display = "none";
    document.getElementById('ps_down'+row).style.display = "block";
    document.getElementById('path'+row).style.display = "none";
    document.getElementById('dirs'+row).style.display = "block";
};
function showPath(row) {
    document.getElementById('ps_down'+row).style.display = "none";
    document.getElementById('ps_right'+row).style.display = "block";
    document.getElementById('dirs'+row).style.display = "none";
    document.getElementById('path'+row).style.display = "block";
};
function periodSwitch(period,page) {
    var tab    = 'summary';
    Ext.get('loaderdiv').load({url:page, scripts:true, params:{nlayer:tab,period:period}});
};