Ext.define('P5Admin.Processbar', {
    extend: 'Ext.window.Window',
    alias: 'widget.processbar',

	width:400,
	height:160,
	layout:'fit',
	resizable: false,
	border: false,
	constrain: true,
	closeAction: 'hide',
	modal: true,

	items: {
		xtype: 'form',
        itemId: 'readwritstatusform_id',
		frame: true,
		items: [{
        	xtype: 'hiddenfield',
        	name: 'jobid',
			value: ''
		},{
        	xtype: 'component',
        	margin: '5 20 0 20',
			html: "<span id='readWriteProcess'><span>"
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			items: [{
				xtype: 'readWriteShortMsg',
				cls: 'configpogress_bar',
			    width: 280,
			    height: 18,
        		margin: '7 0 0 20'
			},{
				xtype: 'button',
                handler: function(me) {
                    ajaxSetJobStop();
                },
				text: $$('Cancel'),
        		margin: '4 20 0 5'
			}]
		},{
        	xtype: 'readWriteLongMsg',
        	margin: '0 20 0 20',
			width: 350,
			cls: 'readWriteLongMsg',
			html: "<span id='readWriteProcessLong'><span>"
        }]
    }
});

Ext.define('P5Admin.ReadWriteShortMsg', {
    extend: 'Ext.ProgressBar',
    alias: 'widget.readWriteShortMsg',

    textEl: 'readWriteProcess'
});

Ext.define('P5Admin.ReadWriteLongMsg', {
    extend: 'Ext.Component',
    alias: 'widget.readWriteLongMsg',

    textEl: 'readWriteProcessLong'
});

function ajaxGetVolumeChain() {
    console.log('ajaxGetVolumeChain')
    Ext.Ajax.request({
        url: document.volumechainForm.action,
        method: 'POST',
        params: { 
            caller: 'ajaxGetVolumeChain',
            elementType: document.volumechainForm.elementType.value,
            selected: document.volumechainForm.selected.value,
        },
        scope: this,
        success: function(result, request) {
            var jobStatus = Ext.decode(result.responseText);
            extAlert(jobStatus.attention,jobStatus.message);
            console.log(jobStatus);
            if ( !jobStatus.attention) {
                onJobStatus(jobStatus);
            }
        },
        failure: function(result, request) {
            Ext.MessageBox.alert('Failed', result.responseText);
        }
    });
}
function onJobStatus(startedJobObject) {
    var win = Ext.create('P5Admin.Processbar', {
        itemId: 'readwritstatus_id',
        title: 'Status',
    });
    win.show();
    //Ext.ComponentQuery.query('readWriteShortMsg')[0].updateText($$('Please wait')+' ...');
    Ext.ComponentQuery.query('#readwritstatusform_id')[0].getForm().findField('jobid').setValue(startedJobObject);
    progressCheck(startedJobObject);
}
function progressCheck(startedJobObject) {
    var me = this;
    console.log('progressCheck');
    var rwin = Ext.ComponentQuery.query('#readwritstatus_id')[0];
    if (rwin.isVisible()) {
        Ext.Ajax.request({
            url: document.volumechainForm.action,
            method: 'GET',
            params: { 
                caller: 'ajaxGetJobProgress',
                jobid: startedJobObject.jobid
            },
            scope: this,
            success: function(result, request) {
                var jobStatus = Ext.decode(result.responseText);
                extAlert(jobStatus.attention,jobStatus.message);
                if ( !jobStatus.attention) {
                    Ext.ComponentQuery.query('readWriteShortMsg')[0].updateText(jobStatus.shortmsg);
                    Ext.ComponentQuery.query('readWriteLongMsg')[0].update(jobStatus.longmsg);
                    if (jobStatus.isrunnning) {
                        setTimeout(function() {
                            progressCheck(startedJobObject);
                        }, 1000);
                    } else {
                        Ext.ComponentQuery.query('#readwritstatus_id')[0].close();
                        setTimeout(function() {
                            showVolumeChain(jobStatus);
                        }, 500);
                    }
                } else {
                    Ext.ComponentQuery.query('#readwritstatus_id')[0].close();
                    Ext.Msg.alert($$('Note'), jobStatus.message, function() {
                        showVolumeChain(jobStatus);
                    });
                }
            },
            failure: function(result, request) {
                Ext.MessageBox.alert('Failed', result.responseText);
            }
        });
    }
}
function ajaxSetJobStop() {
    console.log('ajaxSetJobStop')
    Ext.Ajax.request({
        url: document.volumechainForm.action,
        method: 'POST',
        params: { 
            caller: 'ajaxSetJobStop'
        },
        scope: this,
        success: function(result, request) {
            var jobStatus = Ext.decode(result.responseText);
            extAlert(jobStatus.attention,jobStatus.message);
            console.log(jobStatus);
        },
        failure: function(result, request) {
            Ext.MessageBox.alert('Failed', result.responseText);
        }
    });
}
